/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.riena.beans.common.TestBean;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.TextRidget;
import org.eclipse.riena.internal.ui.swt.test.UITestHelper;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextRidgetMultilineTest
extends AbstractSWTRidgetTest {
    private TestBean bean;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.bean = new TestBean();
        Shell shell = this.getShell();
        shell.layout();
    }

    @Override
    protected IRidget createRidget() {
        return new TextRidget();
    }

    protected Control createWidget(Composite parent) {
        return new Text((Composite)this.getShell(), 2050);
    }

    protected ITextRidget getRidget() {
        return (ITextRidget)super.getRidget();
    }

    protected Text getWidget() {
        return (Text)super.getWidget();
    }

    public void testMultilineIgnoreEnterKey() throws Exception {
        Text control = this.getWidget();
        TextRidgetMultilineTest.assertTrue((String)"This test case expects a multiline text field.", ((control.getStyle() & 2) != 0 ? 1 : 0) != 0);
        ITextRidget ridget = this.getRidget();
        ridget.bindToModel((Object)this.bean, "property");
        control.setFocus();
        TextRidgetMultilineTest.assertEquals(null, (Object)this.bean.getProperty());
        UITestHelper.sendString((Display)control.getDisplay(), (String)"1\r");
        TextRidgetMultilineTest.assertEquals((Object)"1\r\n", (Object)this.bean.getProperty());
        ridget.setMultilineIgnoreEnterKey(true);
        TextRidgetMultilineTest.assertEquals((Object)"1\r\n", (Object)this.bean.getProperty());
        UITestHelper.sendString((Display)control.getDisplay(), (String)"2\r");
        TextRidgetMultilineTest.assertEquals((Object)"1\r\n", (Object)this.bean.getProperty());
        ridget.setMultilineIgnoreEnterKey(false);
        TextRidgetMultilineTest.assertEquals((Object)"1\r\n", (Object)this.bean.getProperty());
        UITestHelper.sendString((Display)control.getDisplay(), (String)"2\r");
        TextRidgetMultilineTest.assertEquals((Object)"1\r\n2\r\n2\r\n", (Object)this.bean.getProperty());
    }
}

