/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.net.URL;
import junit.framework.TestCase;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.navigation.ui.swt.views.ImageReplacer;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.menus.CommandContributionItemParameter;

@UITestCase
public class ImageReplacerTest
extends TestCase {
    public void testGetImageName() throws Exception {
        ImageReplacer replacer = ImageReplacer.getInstance();
        String imageName = (String)ReflectionUtils.invokeHidden((Object)replacer, (String)"getImageName", (Object[])new Object[]{""});
        ImageReplacerTest.assertEquals((String)"", (String)imageName);
        imageName = (String)ReflectionUtils.invokeHidden((Object)replacer, (String)"getImageName", (Object[])new Object[]{"abc"});
        ImageReplacerTest.assertEquals((String)"abc", (String)imageName);
        imageName = (String)ReflectionUtils.invokeHidden((Object)replacer, (String)"getImageName", (Object[])new Object[]{"def.txt"});
        ImageReplacerTest.assertEquals((String)"def", (String)imageName);
        imageName = (String)ReflectionUtils.invokeHidden((Object)replacer, (String)"getImageName", (Object[])new Object[]{"ghi00.txt"});
        ImageReplacerTest.assertEquals((String)"ghi00", (String)imageName);
        RienaDefaultLnf originalLnf = LnfManager.getLnf();
        LnfManager.setLnf((RienaDefaultLnf)new MyLnf());
        imageName = (String)ReflectionUtils.invokeHidden((Object)replacer, (String)"getImageName", (Object[])new Object[]{"ghi00.txt"});
        ImageReplacerTest.assertEquals((String)"ghi", (String)imageName);
        imageName = (String)ReflectionUtils.invokeHidden((Object)replacer, (String)"getImageName", (Object[])new Object[]{"/folder00/jkl00_d_.txt"});
        ImageReplacerTest.assertEquals((String)"jkl00_d_", (String)imageName);
        imageName = (String)ReflectionUtils.invokeHidden((Object)replacer, (String)"getImageName", (Object[])new Object[]{"/folderXY/MNO00.png"});
        ImageReplacerTest.assertEquals((String)"MNO", (String)imageName);
        LnfManager.setLnf((RienaDefaultLnf)originalLnf);
    }

    public void testGetScaledImage() throws Exception {
        RienaDefaultLnf originalLnf = LnfManager.getLnf();
        LnfManager.setLnf((RienaDefaultLnf)new MyLnf());
        ImageReplacer replacer = ImageReplacer.getInstance();
        ImageDescriptor fileImageDescriptor = ImageDescriptor.createFromFile(null, (String)"/icons/testimagea00.png");
        ImageDescriptor imageDescriptor = (ImageDescriptor)ReflectionUtils.invokeHidden((Object)replacer, (String)"getScaledImage", (Object[])new Object[]{fileImageDescriptor});
        ImageReplacerTest.assertNotNull((Object)imageDescriptor);
        ImageReplacerTest.assertEquals((int)16, (int)imageDescriptor.getImageData().width);
        ImageReplacerTest.assertEquals((int)16, (int)imageDescriptor.getImageData().height);
        Point dpi = SwtUtilities.getDpi();
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpi", (Object)new Point(144, 144));
        fileImageDescriptor = ImageDescriptor.createFromFile(null, (String)"/icons/testimagea00.png");
        imageDescriptor = (ImageDescriptor)ReflectionUtils.invokeHidden((Object)replacer, (String)"getScaledImage", (Object[])new Object[]{fileImageDescriptor});
        ImageReplacerTest.assertNotNull((Object)imageDescriptor);
        ImageReplacerTest.assertEquals((int)24, (int)imageDescriptor.getImageData().width);
        ImageReplacerTest.assertEquals((int)24, (int)imageDescriptor.getImageData().height);
        URL url = ((Object)((Object)this)).getClass().getResource("/icons/testimagea00.png");
        ImageDescriptor urlimageDescriptor = ImageDescriptor.createFromURL((URL)url);
        imageDescriptor = (ImageDescriptor)ReflectionUtils.invokeHidden((Object)replacer, (String)"getScaledImage", (Object[])new Object[]{urlimageDescriptor});
        ImageReplacerTest.assertNotNull((Object)imageDescriptor);
        ImageReplacerTest.assertEquals((int)24, (int)imageDescriptor.getImageData().width);
        ImageReplacerTest.assertEquals((int)24, (int)imageDescriptor.getImageData().height);
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpi", (Object)dpi);
        LnfManager.setLnf((RienaDefaultLnf)originalLnf);
    }

    public void testIsImageDescriptorSupported() throws Exception {
        ImageReplacer replacer = ImageReplacer.getInstance();
        ImageDescriptor fileImageDescriptor = ImageDescriptor.createFromFile(null, (String)"/icons/testimagea00.png");
        boolean isSupported = (Boolean)ReflectionUtils.invokeHidden((Object)replacer, (String)"isImageDescriptorSupported", (Object[])new Object[]{fileImageDescriptor});
        ImageReplacerTest.assertTrue((boolean)isSupported);
        URL url = ((Object)((Object)this)).getClass().getResource("/icons/testimagea00.png");
        ImageDescriptor urlimageDescriptor = ImageDescriptor.createFromURL((URL)url);
        isSupported = (Boolean)ReflectionUtils.invokeHidden((Object)replacer, (String)"isImageDescriptorSupported", (Object[])new Object[]{urlimageDescriptor});
        ImageReplacerTest.assertTrue((boolean)isSupported);
    }

    public void testGetInstance() throws Exception {
        ImageReplacer replacer = ImageReplacer.getInstance();
        ImageReplacerTest.assertNotNull((Object)replacer);
        ImageReplacerTest.assertSame((Object)replacer, (Object)ImageReplacer.getInstance());
    }

    public void testReplaceImagesCommandContributionItemParameter() throws Exception {
        ImageDescriptor urlImageDescriptor;
        ImageReplacer replacer = ImageReplacer.getInstance();
        RienaDefaultLnf originalLnf = LnfManager.getLnf();
        LnfManager.setLnf((RienaDefaultLnf)new MyLnf());
        CommandContributionItemParameter parameter = new CommandContributionItemParameter(null, "id", "cmdId", 8);
        boolean replaced = (Boolean)ReflectionUtils.invokeHidden((Object)replacer, (String)"replaceImages", (Object[])new Object[]{parameter});
        ImageReplacerTest.assertFalse((boolean)replaced);
        URL url = ((Object)((Object)this)).getClass().getResource("/icons/testimagea00.png");
        parameter.icon = urlImageDescriptor = ImageDescriptor.createFromURL((URL)url);
        replaced = (Boolean)ReflectionUtils.invokeHidden((Object)replacer, (String)"replaceImages", (Object[])new Object[]{parameter});
        ImageReplacerTest.assertTrue((boolean)replaced);
        ImageReplacerTest.assertNotSame((Object)urlImageDescriptor, (Object)parameter.icon);
        ImageReplacerTest.assertEquals((int)16, (int)parameter.icon.getImageData().width);
        ImageReplacerTest.assertEquals((int)16, (int)parameter.icon.getImageData().height);
        Point dpi = SwtUtilities.getDpi();
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpi", (Object)new Point(144, 144));
        parameter = new CommandContributionItemParameter(null, "id", "cmdId", 8);
        parameter.icon = urlImageDescriptor;
        replaced = (Boolean)ReflectionUtils.invokeHidden((Object)replacer, (String)"replaceImages", (Object[])new Object[]{parameter});
        ImageReplacerTest.assertTrue((boolean)replaced);
        ImageReplacerTest.assertNotSame((Object)urlImageDescriptor, (Object)parameter.icon);
        ImageReplacerTest.assertEquals((int)24, (int)parameter.icon.getImageData().width);
        ImageReplacerTest.assertEquals((int)24, (int)parameter.icon.getImageData().height);
        parameter = new CommandContributionItemParameter(null, "id", "cmdId", 8);
        parameter.disabledIcon = urlImageDescriptor;
        replaced = (Boolean)ReflectionUtils.invokeHidden((Object)replacer, (String)"replaceImages", (Object[])new Object[]{parameter});
        ImageReplacerTest.assertTrue((boolean)replaced);
        ImageReplacerTest.assertNotSame((Object)urlImageDescriptor, (Object)parameter.disabledIcon);
        ImageReplacerTest.assertEquals((int)24, (int)parameter.disabledIcon.getImageData().width);
        ImageReplacerTest.assertEquals((int)24, (int)parameter.disabledIcon.getImageData().height);
        parameter = new CommandContributionItemParameter(null, "id", "cmdId", 8);
        parameter.hoverIcon = urlImageDescriptor;
        replaced = (Boolean)ReflectionUtils.invokeHidden((Object)replacer, (String)"replaceImages", (Object[])new Object[]{parameter});
        ImageReplacerTest.assertTrue((boolean)replaced);
        ImageReplacerTest.assertNotSame((Object)urlImageDescriptor, (Object)parameter.hoverIcon);
        ImageReplacerTest.assertEquals((int)24, (int)parameter.hoverIcon.getImageData().width);
        ImageReplacerTest.assertEquals((int)24, (int)parameter.hoverIcon.getImageData().height);
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpi", (Object)dpi);
        LnfManager.setLnf((RienaDefaultLnf)originalLnf);
    }

    private static class MyLnf
    extends RienaDefaultLnf {
        private MyLnf() {
        }

        public String getIconScaleSuffix(Point dpi) {
            if (dpi == null) {
                return "00";
            }
            if (dpi.x <= 96) {
                return "00";
            }
            return "03";
        }
    }
}

