/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.tree2;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.ui.ridgets.tree2.ITreeNode;
import org.eclipse.riena.ui.ridgets.tree2.TreeNode;
import org.eclipse.riena.ui.tests.base.PropertyChangeEventEquals;

@NonUITestCase
public class TreeNodeTest
extends TestCase {
    private PropertyChangeListener propertyChangeListenerMock;

    protected void setUp() throws Exception {
        super.setUp();
        this.propertyChangeListenerMock = (PropertyChangeListener)EasyMock.createMock(PropertyChangeListener.class);
    }

    public void testGetSetValue() {
        TreeNode root = new TreeNode((Object)"value");
        root.addPropertyChangeListener(this.propertyChangeListenerMock);
        TreeNodeTest.assertEquals((Object)"value", (Object)root.getValue());
        this.expectPropertyChangeEvent(root, "value", "value", "newValue");
        root.setValue((Object)"newValue");
        this.verifyPropertyChangeEvents();
        TreeNodeTest.assertEquals((Object)"newValue", (Object)root.getValue());
        this.expectNoPropertyChangeEvent();
        root.setValue((Object)"newValue");
        this.verifyPropertyChangeEvents();
        TreeNodeTest.assertEquals((Object)"newValue", (Object)root.getValue());
        this.expectPropertyChangeEvent(root, "value", "newValue", null);
        root.setValue(null);
        this.verifyPropertyChangeEvents();
        TreeNodeTest.assertNull((Object)root.getValue());
    }

    public void testGetParent() {
        TreeNode root = new TreeNode((Object)"value");
        TreeNodeTest.assertNull((Object)root.getParent());
        TreeNode child = new TreeNode((ITreeNode)root, (Object)"child1");
        TreeNodeTest.assertNull((Object)root.getParent());
        TreeNodeTest.assertSame((Object)root, (Object)child.getParent());
    }

    public void testGetChildren() {
        TreeNode root = new TreeNode((Object)"value");
        TreeNodeTest.assertEquals((int)0, (int)root.getChildren().size());
        TreeNode child1 = new TreeNode((ITreeNode)root, (Object)"child1");
        TreeNode child2 = new TreeNode((ITreeNode)root, (Object)"child2");
        TreeNodeTest.assertEquals((int)2, (int)root.getChildren().size());
        TreeNodeTest.assertTrue((boolean)root.getChildren().contains(child1));
        TreeNodeTest.assertTrue((boolean)root.getChildren().contains(child2));
        root.getChildren().remove(0);
        TreeNodeTest.assertEquals((int)2, (int)root.getChildren().size());
    }

    public void testSetChildren() {
        TreeNode root = new TreeNode((Object)"value");
        root.addPropertyChangeListener(this.propertyChangeListenerMock);
        TreeNode child1 = new TreeNode((ITreeNode)root, (Object)"child1");
        TreeNode child2 = new TreeNode((ITreeNode)root, (Object)"child2");
        TreeNodeTest.assertEquals((int)2, (int)root.getChildren().size());
        List twoChildren = root.getChildren();
        List oneChild = root.getChildren();
        oneChild.remove(child1);
        this.expectPropertyChangeEvent(root, "children", twoChildren, oneChild);
        root.setChildren(oneChild);
        this.verifyPropertyChangeEvents();
        TreeNodeTest.assertEquals((int)1, (int)root.getChildren().size());
        TreeNodeTest.assertTrue((boolean)root.getChildren().contains(child2));
    }

    public void testSetEnabled() {
        TreeNode root = new TreeNode((Object)"value");
        root.addPropertyChangeListener(this.propertyChangeListenerMock);
        TreeNodeTest.assertTrue((boolean)root.isEnabled());
        this.expectPropertyChangeEvent(root, "enabled", true, false);
        root.setEnabled(false);
        this.verifyPropertyChangeEvents();
        TreeNodeTest.assertFalse((boolean)root.isEnabled());
        this.expectNoPropertyChangeEvent();
        root.setEnabled(false);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvent(root, "enabled", false, true);
        root.setEnabled(true);
        this.verifyPropertyChangeEvents();
        TreeNodeTest.assertTrue((boolean)root.isEnabled());
    }

    public void testSetVisible() {
        TreeNode root = new TreeNode((Object)"value");
        root.addPropertyChangeListener(this.propertyChangeListenerMock);
        TreeNodeTest.assertTrue((boolean)root.isVisible());
        this.expectPropertyChangeEvent(root, "visible", true, false);
        root.setVisible(false);
        this.verifyPropertyChangeEvents();
        TreeNodeTest.assertFalse((boolean)root.isVisible());
        this.expectNoPropertyChangeEvent();
        root.setVisible(false);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvent(root, "visible", false, true);
        root.setVisible(true);
        this.verifyPropertyChangeEvents();
        TreeNodeTest.assertTrue((boolean)root.isVisible());
    }

    private PropertyChangeEvent createArgumentMatcher(PropertyChangeEvent propertyChangeEvent) {
        return PropertyChangeEventEquals.eqPropertyChangeEvent(propertyChangeEvent);
    }

    private void expectNoPropertyChangeEvent() {
        EasyMock.reset((Object[])new Object[]{this.propertyChangeListenerMock});
        EasyMock.replay((Object[])new Object[]{this.propertyChangeListenerMock});
    }

    private void expectPropertyChangeEvents(PropertyChangeEvent ... propertyChangeEvents) {
        EasyMock.reset((Object[])new Object[]{this.propertyChangeListenerMock});
        PropertyChangeEvent[] propertyChangeEventArray = propertyChangeEvents;
        int n = propertyChangeEvents.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeEvent propertyChangeEvent = propertyChangeEventArray[n2];
            this.propertyChangeListenerMock.propertyChange(this.createArgumentMatcher(propertyChangeEvent));
            ++n2;
        }
        EasyMock.replay((Object[])new Object[]{this.propertyChangeListenerMock});
    }

    private void expectPropertyChangeEvent(Object bean, String propertyName, Object oldValue, Object newValue) {
        this.expectPropertyChangeEvents(new PropertyChangeEvent(bean, propertyName, oldValue, newValue));
    }

    private void verifyPropertyChangeEvents() {
        EasyMock.verify((Object[])new Object[]{this.propertyChangeListenerMock});
    }
}

