/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation;

import junit.framework.TestCase;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.ui.ridgets.validation.MaxLength;

@NonUITestCase
public class MaxLengthTest
extends TestCase {
    protected MaxLength createRule() {
        return new MaxLength();
    }

    protected MaxLength createRule(int length) {
        return new MaxLength(length);
    }

    public void testLength() {
        MaxLength rule = this.createRule(10);
        MaxLengthTest.assertTrue((boolean)rule.validate((Object)"abcde").isOK());
        MaxLengthTest.assertTrue((boolean)rule.validate((Object)"abcdeabcde").isOK());
        MaxLengthTest.assertFalse((boolean)rule.validate((Object)"abcdeabcdefg").isOK());
    }

    public void testIsBlocking() {
        MaxLength rule = this.createRule(3);
        IStatus status = rule.validate((Object)"abcd");
        MaxLengthTest.assertFalse((boolean)status.isOK());
        MaxLengthTest.assertEquals((int)1024, (int)status.getCode());
    }

    public void testSetInitializationData() throws Exception {
        MaxLength rule = this.createRule();
        MaxLengthTest.assertTrue((boolean)rule.validate((Object)"").isOK());
        MaxLengthTest.assertFalse((boolean)rule.validate((Object)"1").isOK());
        rule = this.createRule();
        rule.setInitializationData(null, null, (Object)"5");
        MaxLengthTest.assertTrue((boolean)rule.validate((Object)"1").isOK());
        MaxLengthTest.assertFalse((boolean)rule.validate((Object)"123456").isOK());
        rule = this.createRule();
        rule.setInitializationData(null, null, (Object)"6,7");
        MaxLengthTest.assertTrue((boolean)rule.validate((Object)"123456").isOK());
        MaxLengthTest.assertFalse((boolean)rule.validate((Object)"1234567").isOK());
    }
}

