/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import junit.framework.TestCase;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.ui.swt.CompletionCombo;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class CompletionComboTest
extends TestCase {
    private Shell shell;
    private CompletionCombo combo;
    private Text text;

    protected void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
        this.shell.setLayout((Layout)new RowLayout());
        this.shell.setBounds(0, 0, 200, 200);
        this.combo = UIControlsFactory.createCompletionCombo((Composite)this.shell, (int)0);
        this.text = UIControlsFactory.createText((Composite)this.shell, (int)2048);
    }

    protected void tearDown() throws Exception {
        SwtUtilities.dispose((Widget)this.shell);
    }

    public void testSetBackground() {
        Color red = this.combo.getDisplay().getSystemColor(3);
        this.combo.setBackground(red);
        CompletionComboTest.assertEquals((Object)red, (Object)this.combo.getBackground());
        CompletionComboTest.assertEquals((Object)red, (Object)this.combo.getTextBackground());
        CompletionComboTest.assertEquals((Object)red, (Object)this.combo.getListBackground());
    }

    public void testSetTextBackground() {
        Color red = this.combo.getDisplay().getSystemColor(3);
        Color green = this.combo.getDisplay().getSystemColor(5);
        this.combo.setBackground(red);
        this.combo.setTextBackground(green);
        CompletionComboTest.assertEquals((Object)red, (Object)this.combo.getBackground());
        CompletionComboTest.assertEquals((Object)green, (Object)this.combo.getTextBackground());
        CompletionComboTest.assertEquals((Object)red, (Object)this.combo.getListBackground());
    }

    public void testSetListBackground() {
        Color red = this.combo.getDisplay().getSystemColor(3);
        Color green = this.combo.getDisplay().getSystemColor(5);
        Color blue = this.combo.getDisplay().getSystemColor(5);
        this.combo.setBackground(red);
        this.combo.setTextBackground(green);
        this.combo.setListBackground(blue);
        CompletionComboTest.assertEquals((Object)red, (Object)this.combo.getBackground());
        CompletionComboTest.assertEquals((Object)green, (Object)this.combo.getTextBackground());
        CompletionComboTest.assertEquals((Object)blue, (Object)this.combo.getListBackground());
    }

    public void testGetChildren() {
        Control[] children = this.combo.getChildren();
        CompletionComboTest.assertEquals((int)2, (int)children.length);
        CompletionComboTest.assertTrue((boolean)(children[0] instanceof Text));
        CompletionComboTest.assertTrue((boolean)(children[1] instanceof Button));
    }

    public void testArrowButtonEnabled() {
        this.shell.setEnabled(false);
        this.combo.setEnabled(false);
        this.combo.setEnabled(true);
        this.combo.setEditable(true);
        this.shell.setEnabled(true);
        CompletionComboTest.assertTrue((boolean)this.combo.isEnabled());
        Text textControl = (Text)ReflectionUtils.invokeHidden((Object)this.combo, (String)"getTextControl", (Object[])new Object[0]);
        CompletionComboTest.assertTrue((boolean)textControl.isEnabled());
        Button buttonControl = (Button)ReflectionUtils.invokeHidden((Object)this.combo, (String)"getButtonControl", (Object[])new Object[0]);
        CompletionComboTest.assertTrue((boolean)buttonControl.isEnabled());
    }

    public void testSetFocus() {
        this.shell.open();
        this.text.setFocus();
        CompletionComboTest.assertTrue((boolean)this.text.isFocusControl());
        this.text.setFocus();
        this.combo.setAutoCompletionMode(CompletionCombo.AutoCompletionMode.ALLOW_MISSMATCH);
        this.combo.setFocus();
        CompletionComboTest.assertTrue((boolean)((Text)ReflectionUtils.invokeHidden((Object)this.combo, (String)"getTextControl", (Object[])new Object[0])).isFocusControl());
        this.text.setFocus();
        this.combo.setAutoCompletionMode(CompletionCombo.AutoCompletionMode.FIRST_LETTER_MATCH);
        this.combo.setFocus();
        CompletionComboTest.assertTrue((boolean)((Text)ReflectionUtils.invokeHidden((Object)this.combo, (String)"getTextControl", (Object[])new Object[0])).isFocusControl());
        this.text.setFocus();
        this.combo.setAutoCompletionMode(CompletionCombo.AutoCompletionMode.NO_MISSMATCH);
        this.combo.setFocus();
        CompletionComboTest.assertTrue((boolean)((Text)ReflectionUtils.invokeHidden((Object)this.combo, (String)"getTextControl", (Object[])new Object[0])).isFocusControl());
        this.text.setFocus();
        this.combo.setEnabled(false);
        this.combo.setFocus();
        CompletionComboTest.assertFalse((boolean)((Text)ReflectionUtils.invokeHidden((Object)this.combo, (String)"getTextControl", (Object[])new Object[0])).isFocusControl());
        this.text.setFocus();
        this.combo.setEnabled(true);
        this.combo.setVisible(false);
        this.combo.setFocus();
        CompletionComboTest.assertFalse((boolean)((Text)ReflectionUtils.invokeHidden((Object)this.combo, (String)"getTextControl", (Object[])new Object[0])).isFocusControl());
    }
}

