/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.utils;

import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.ui.swt.utils.MouseWheelAdapter;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class MouseWheelAdapterTest
extends TestCase {
    private static final int OS_SETTING_MOUSE_WHEEL = 3;
    private Display display;
    private Shell shell;
    private MouseWheelAdapter.Scroller scroller;
    private MouseWheelAdapter mouseWheelAdapter;

    protected void setUp() throws Exception {
        super.setUp();
        this.display = Display.getDefault();
        this.shell = new Shell(this.display);
        this.shell.open();
        this.scroller = (MouseWheelAdapter.Scroller)EasyMock.createMock(MouseWheelAdapter.Scroller.class);
        this.mouseWheelAdapter = new MouseWheelAdapter((Control)this.shell, this.scroller);
    }

    protected void tearDown() {
        SwtUtilities.dispose((Widget)this.shell);
    }

    public void testSetNegativeScrollingSpeed() throws Exception {
        try {
            this.mouseWheelAdapter.setScrollingSpeed(-1);
            MouseWheelAdapterTest.fail((String)"Exception expected - setting a negative scrolling speed is not allowed!");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void atestSetScrollingSpeed() throws Exception {
        EasyMock.expect((Object)this.scroller.mayScroll()).andReturn((Object)true);
        this.mouseWheelAdapter.setScrollingSpeed(15);
        this.scroller.scrollUp(45);
        EasyMock.replay((Object[])new Object[]{this.scroller});
        Event event = new Event();
        event.time = 1;
        event.widget = this.shell;
        event.count = 3;
        event.x = this.shell.toDisplay((int)0, (int)0).x + 1;
        event.y = this.shell.toDisplay((int)0, (int)0).y + 1;
        this.mouseWheelAdapter.handleEvent(event);
        EasyMock.verify((Object[])new Object[]{this.scroller});
    }
}

