/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.communication.publisher.hessian;

import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.communication.core.RemoteServiceDescription;
import org.eclipse.riena.communication.core.hooks.IServiceMessageContext;
import org.eclipse.riena.communication.core.hooks.IServiceMessageContextAccessor;
import org.eclipse.riena.communication.core.publisher.IServicePublisher;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.communication.publisher.hessian.Activator;
import org.eclipse.riena.internal.communication.publisher.hessian.MessageContextHolder;

public class HessianRemoteServicePublisher
implements IServicePublisher {
    private static final String PROTOCOL = "hessian";
    private static final String SERVLET_PATH = "/hessian";
    private final IServiceMessageContextAccessor mca = new MsgCxtAcc();
    private final HashMap<String, RemoteServiceDescription> webServiceDescriptions = new HashMap();
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), HessianRemoteServicePublisher.class);
    private static final String PORT = System.getProperty("org.eclipse.equinox.http.jetty.http.port");

    public synchronized String publishService(RemoteServiceDescription rsd) {
        if (!this.testInterface(rsd.getServiceInterfaceClass())) {
            String error = "cannot publish " + rsd + " because its interface contains multiple methods with the same name." + "That is not allowed for remote services (even if they have a different signature).";
            throw new RuntimeException(error);
        }
        String localhost = "localhost";
        try {
            localhost = Inet4Address.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {}
        if (PORT != null) {
            localhost = String.valueOf(localhost) + ":" + PORT;
        }
        String url = "http://" + localhost + SERVLET_PATH + rsd.getPath();
        rsd.setURL(url);
        this.webServiceDescriptions.put(SERVLET_PATH + rsd.getPath(), rsd);
        LOGGER.log(4, "published web service. " + rsd);
        LOGGER.log(4, "web service count: " + this.webServiceDescriptions.size());
        return url;
    }

    private boolean testInterface(Class<?> interfaceClazz) {
        Method[] declaredMethods;
        HashSet<String> methods = new HashSet<String>();
        Method[] methodArray = declaredMethods = interfaceClazz.getDeclaredMethods();
        int n = declaredMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (methods.contains(method.getName())) {
                return false;
            }
            methods.add(method.getName());
            ++n2;
        }
        return true;
    }

    public synchronized void unpublishService(RemoteServiceDescription rsd) {
        this.webServiceDescriptions.remove(SERVLET_PATH + rsd.getPath());
        LOGGER.log(4, "unpublished web service. " + rsd);
        LOGGER.log(4, "web service count: " + this.webServiceDescriptions.size());
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public synchronized RemoteServiceDescription findService(String requestURI) {
        RemoteServiceDescription rsd = this.webServiceDescriptions.get(requestURI);
        return rsd;
    }

    public IServiceMessageContextAccessor getMessageContextAccessor() {
        return this.mca;
    }

    static class MsgCxtAcc
    implements IServiceMessageContextAccessor {
        MsgCxtAcc() {
        }

        public IServiceMessageContext getMessageContext() {
            return MessageContextHolder.getMessageContext();
        }
    }
}

