/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core.logging;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.BlockingQueue;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.logging.ConsoleLogger;
import org.eclipse.riena.internal.core.logging.DeferredLogEvent;
import org.eclipse.riena.internal.core.logging.LoggerProvider;

public class DeferringLoggerHandler
implements InvocationHandler {
    private final String name;
    private final LoggerProvider loggerProvider;
    private final BlockingQueue<DeferredLogEvent> queue;
    private Logger logger = null;

    DeferringLoggerHandler(String name, LoggerProvider loggerProvider, BlockingQueue<DeferredLogEvent> queue) {
        this.name = name;
        this.loggerProvider = loggerProvider;
        this.queue = queue;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.logger == null) {
            this.logger = this.loggerProvider.getRealLogger(this.name);
        }
        if (this.logger != null) {
            try {
                return method.invoke((Object)this.logger, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        DeferredLogEvent logEvent = new DeferredLogEvent(this.name, System.currentTimeMillis(), Thread.currentThread().getName(), method, args);
        this.queue(logEvent);
        if (method.getName().equals("isLoggable")) {
            return true;
        }
        if (method.getName().equals("getName")) {
            return this.name;
        }
        return null;
    }

    private void queue(DeferredLogEvent logEvent) {
        try {
            this.queue.put(logEvent);
        }
        catch (InterruptedException e) {
            new ConsoleLogger(DeferringLoggerHandler.class.getName()).log(1, "Queueing log event failed: " + logEvent, e);
        }
    }
}

