/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.e4.launcher.part;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.e4.core.commands.ExpressionContext;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.riena.e4.launcher.part.E4ImageReplacer;
import org.eclipse.riena.e4.launcher.part.MenuPartHelper;
import org.eclipse.riena.navigation.ui.swt.component.IEntriesProvider;
import org.eclipse.riena.navigation.ui.swt.component.MenuCoolBarComposite;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Composite;

public class MainMenuPart {
    public static final String MENU_COMPOSITE_KEY = String.valueOf(MainMenuPart.class.getName()) + ".rienaMenuCoolBarComposite";
    @Inject
    private IEclipseContext eclipseContext;
    @Inject
    private EModelService modelService;
    @Inject
    private MApplication application;

    @Inject
    public void create(Composite parent, final MTrimmedWindow window, MPart part) {
        MenuCoolBarComposite menuCoolBarComposite = new MenuCoolBarComposite(parent, 0, new IEntriesProvider(){

            public IContributionItem[] getTopLevelEntries() {
                Object c2;
                HashMap parentIdToElement = new HashMap();
                MMenu mainMenu = window.getMainMenu();
                if (mainMenu != null) {
                    MainMenuPart.this.fill(mainMenu.getChildren(), parentIdToElement, "org.eclipse.ui.main.menu");
                }
                ExpressionContext eContext = new ExpressionContext(MainMenuPart.this.eclipseContext.getParent());
                for (Object c2 : MainMenuPart.this.application.getMenuContributions()) {
                    if (!ContributionsAnalyzer.isVisible((MMenuContribution)c2, (ExpressionContext)eContext)) continue;
                    MainMenuPart.this.fill(c2.getChildren(), parentIdToElement, c2.getParentId());
                }
                MainMenuPart.this.setParentChildRelation(parentIdToElement);
                for (IContributionItem iContributionItem : MainMenuPart.this.getOrCreateMapElement(parentIdToElement, "org.eclipse.ui.main.toolbar")) {
                    System.err.println(iContributionItem);
                }
                c2 = MainMenuPart.this.getOrCreateMapElement(parentIdToElement, "org.eclipse.ui.main.menu");
                E4ImageReplacer imageReplacer = E4ImageReplacer.getInstance();
                if (SwtUtilities.isDpiScalingEnabled()) {
                    Iterator iterator = c2.iterator();
                    while (iterator.hasNext()) {
                        IContributionItem contributionItem = (IContributionItem)iterator.next();
                        if (!(contributionItem instanceof IContributionManager)) continue;
                        imageReplacer.replaceImagesOfManager((IContributionManager)contributionItem);
                    }
                }
                return c2.toArray(new IContributionItem[parentIdToElement.size()]);
            }
        });
        part.getTransientData().put(MENU_COMPOSITE_KEY, menuCoolBarComposite);
    }

    private void fill(List<MMenuElement> elements, Map<String, Collection<IContributionItem>> parentIdToElement, String parentId) {
        MenuPartHelper helper = new MenuPartHelper(this.eclipseContext, this.modelService);
        for (MMenuElement e : elements) {
            String label = e.getLabel();
            String id = e.getElementId();
            if (e instanceof MMenu) {
                this.getOrCreateMapElement(parentIdToElement, parentId).add((IContributionItem)new MenuManager(label, id));
                continue;
            }
            if (e instanceof MHandledItem) {
                IContributionItem item = helper.createHandledContributionItem((MHandledItem)e);
                this.getOrCreateMapElement(parentIdToElement, parentId).add(item);
                continue;
            }
            if (!(e instanceof MMenuSeparator)) continue;
            Separator separator = new Separator();
            separator.setId(id);
            this.getOrCreateMapElement(parentIdToElement, parentId).add((IContributionItem)separator);
        }
    }

    private Collection<IContributionItem> getOrCreateMapElement(Map<String, Collection<IContributionItem>> parentIdToElement, String parentId) {
        Collection<IContributionItem> elements = parentIdToElement.get(parentId);
        if (elements == null) {
            elements = new ArrayList<IContributionItem>();
            parentIdToElement.put(parentId, elements);
        }
        return elements;
    }

    private void setParentChildRelation(Map<String, Collection<IContributionItem>> parentIdToElement) {
        for (Map.Entry<String, Collection<IContributionItem>> entry : new HashMap<String, Collection<IContributionItem>>(parentIdToElement).entrySet()) {
            for (IContributionItem e : entry.getValue()) {
                if (!(e instanceof IContributionManager)) continue;
                for (IContributionItem child : this.getOrCreateMapElement(parentIdToElement, e.getId())) {
                    ((IContributionManager)e).add(child);
                }
            }
        }
    }
}

