/*
 * Decompiled with CFR 0.152.
 */
package com.swtdesigner;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Display;

public class SWTResourceManager {
    private static HashMap<RGB, Color> m_ColorMap = new HashMap();
    private static HashMap<String, Image> m_ClassImageMap = new HashMap();
    private static HashMap<Image, HashMap<Image, Image>> m_ImageToDecoratorMap = new HashMap();
    public static final int TOP_LEFT = 1;
    public static final int TOP_RIGHT = 2;
    public static final int BOTTOM_LEFT = 3;
    public static final int BOTTOM_RIGHT = 4;
    private static HashMap<String, Font> m_FontMap = new HashMap();
    private static HashMap<Font, Font> m_FontToBoldFontMap = new HashMap();
    private static HashMap<Integer, Cursor> m_IdToCursorMap = new HashMap();

    public static void dispose() {
        SWTResourceManager.disposeColors();
        SWTResourceManager.disposeFonts();
        SWTResourceManager.disposeImages();
        SWTResourceManager.disposeCursors();
    }

    public static Color getColor(int systemColorID) {
        Display display = Display.getCurrent();
        return display.getSystemColor(systemColorID);
    }

    public static Color getColor(int r, int g, int b) {
        return SWTResourceManager.getColor(new RGB(r, g, b));
    }

    public static Color getColor(RGB rgb) {
        Color color = m_ColorMap.get(rgb);
        if (color == null) {
            Display display = Display.getCurrent();
            color = new Color((Device)display, rgb);
            m_ColorMap.put(rgb, color);
        }
        return color;
    }

    public static void disposeColors() {
        for (Color color : m_ColorMap.values()) {
            color.dispose();
        }
        m_ColorMap.clear();
    }

    public static void disposeImages() {
        for (Image image : m_ClassImageMap.values()) {
            image.dispose();
        }
        m_ClassImageMap.clear();
        for (HashMap hashMap : m_ImageToDecoratorMap.values()) {
            for (Image image : hashMap.values()) {
                image.dispose();
            }
        }
    }

    public static void disposeImages(String section) {
        Iterator<String> I = m_ClassImageMap.keySet().iterator();
        while (I.hasNext()) {
            String key = I.next();
            if (!key.startsWith(String.valueOf(section) + '|')) continue;
            Image image = m_ClassImageMap.get(key);
            image.dispose();
            I.remove();
        }
    }

    public static Font getFont(String name, int height, int style) {
        return SWTResourceManager.getFont(name, height, style, false, false);
    }

    public static Font getFont(String name, int size, int style, boolean strikeout, boolean underline) {
        String fontName = String.valueOf(name) + '|' + size + '|' + style + '|' + strikeout + '|' + underline;
        Font font = m_FontMap.get(fontName);
        if (font == null) {
            FontData fontData = new FontData(name, size, style);
            if (strikeout || underline) {
                try {
                    Class<?> logFontClass = Class.forName("org.eclipse.swt.internal.win32.LOGFONT");
                    Object logFont = FontData.class.getField("data").get(fontData);
                    if (logFont != null && logFontClass != null) {
                        if (strikeout) {
                            logFontClass.getField("lfStrikeOut").set(logFont, new Byte(1));
                        }
                        if (underline) {
                            logFontClass.getField("lfUnderline").set(logFont, new Byte(1));
                        }
                    }
                }
                catch (Throwable e) {
                    System.err.println("Unable to set underline or strikeout (probably on a non-Windows platform). " + e);
                }
            }
            font = new Font((Device)Display.getCurrent(), fontData);
            m_FontMap.put(fontName, font);
        }
        return font;
    }

    public static Font getBoldFont(Font baseFont) {
        Font font = m_FontToBoldFontMap.get(baseFont);
        if (font == null) {
            FontData[] fontDatas = baseFont.getFontData();
            FontData data = fontDatas[0];
            font = new Font((Device)Display.getCurrent(), data.getName(), data.getHeight(), 1);
            m_FontToBoldFontMap.put(baseFont, font);
        }
        return font;
    }

    public static void disposeFonts() {
        for (Font font : m_FontMap.values()) {
            font.dispose();
        }
        m_FontMap.clear();
        for (Font font : m_FontToBoldFontMap.values()) {
            font.dispose();
        }
        m_FontToBoldFontMap.clear();
    }

    public static void fixCoolBarSize(CoolBar bar) {
        CoolItem item;
        CoolItem[] items;
        CoolItem[] coolItemArray = items = bar.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            item = coolItemArray[n2];
            if (item.getControl() == null) {
                item.setControl((Control)new Canvas((Composite)bar, 0){

                    public Point computeSize(int wHint, int hHint, boolean changed) {
                        return new Point(20, 20);
                    }
                });
            }
            ++n2;
        }
        coolItemArray = items;
        n = items.length;
        n2 = 0;
        while (n2 < n) {
            item = coolItemArray[n2];
            Control control = item.getControl();
            control.pack();
            Point size = control.getSize();
            item.setSize(item.computeSize(size.x, size.y));
            ++n2;
        }
    }

    public static Cursor getCursor(int id) {
        Integer key = new Integer(id);
        Cursor cursor = m_IdToCursorMap.get(key);
        if (cursor == null) {
            cursor = new Cursor((Device)Display.getDefault(), id);
            m_IdToCursorMap.put(key, cursor);
        }
        return cursor;
    }

    public static void disposeCursors() {
        for (Cursor cursor : m_IdToCursorMap.values()) {
            cursor.dispose();
        }
        m_IdToCursorMap.clear();
    }
}

