/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.riena.beans.common.AbstractBean;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IProgressBarRidget;
import org.eclipse.riena.ui.ridgets.IScaleRidget;
import org.eclipse.riena.ui.ridgets.ISpinnerRidget;
import org.eclipse.riena.ui.ridgets.IStatusMeterRidget;
import org.eclipse.riena.ui.ridgets.ITraverseRidget;
import org.eclipse.swt.graphics.Color;

public class TraverseSubModuleController
extends SubModuleController {
    private static final int RANKINE_MAX = 582;
    private final Temperature temperature = new Temperature();
    private IStatusMeterRidget rankineStatusMeter;

    public TraverseSubModuleController() {
        this.temperature.setKelvin(273.15f);
    }

    public void configureRidgets() {
        super.configureRidgets();
        TemperatureListener listener = new TemperatureListener();
        ISpinnerRidget fahrenheitSpinner = (ISpinnerRidget)this.getRidget(ISpinnerRidget.class, "fahrenheitSpinner");
        fahrenheitSpinner.setIncrement(1);
        fahrenheitSpinner.setMaximum(122);
        fahrenheitSpinner.setMinimum(32);
        fahrenheitSpinner.bindToModel(BeansObservables.observeValue((Object)((Object)this.temperature), (String)"degreeFahrenheit"));
        fahrenheitSpinner.updateFromModel();
        fahrenheitSpinner.addListener((IActionListener)listener);
        ITraverseRidget celsiusScale = (ITraverseRidget)this.getRidget(IScaleRidget.class, "celsiusScale");
        celsiusScale.setIncrement(1);
        celsiusScale.setMaximum(50);
        celsiusScale.setMinimum(0);
        celsiusScale.bindToModel(BeansObservables.observeValue((Object)((Object)this.temperature), (String)"degreeCelsius"));
        celsiusScale.updateFromModel();
        celsiusScale.addListener((IActionListener)listener);
        ITraverseRidget kelvinProgressBar = (ITraverseRidget)this.getRidget(IProgressBarRidget.class, "kelvinProgressBar");
        kelvinProgressBar.setIncrement(1);
        kelvinProgressBar.setMaximum(323);
        kelvinProgressBar.setMinimum(273);
        kelvinProgressBar.bindToModel(BeansObservables.observeValue((Object)((Object)this.temperature), (String)"kelvin"));
        kelvinProgressBar.updateFromModel();
        this.rankineStatusMeter = (IStatusMeterRidget)this.getRidget(IStatusMeterRidget.class, "rankineStatusMeter");
        this.rankineStatusMeter.bindToModel(BeansObservables.observeValue((Object)((Object)this.temperature), (String)"rankine"));
        this.rankineStatusMeter.setMaximum(582);
        this.rankineStatusMeter.setMinimum(491);
        this.rankineStatusMeter.updateFromModel();
    }

    private class Temperature
    extends AbstractBean {
        static final String PROPERTY_DEGREE_CELSIUS = "degreeCelsius";
        static final String PROPERTY_DEGREE_FAHRENHEITN = "degreeFahrenheit";
        static final String PROPERTY_KELVIN = "kelvin";
        static final String PROPERTY_RANKINE = "rankine";
        private float kelvin;
        private int degreeCelsius;
        private int degreeFahrenheit;
        private int rankine;

        private Temperature() {
        }

        public void setDegreeCelsius(int degreeCelsius) {
            this.setDegreeCelsius(degreeCelsius, true);
        }

        private void setDegreeCelsius(int degreeCelsius, boolean updateKelvin) {
            int oldValue = this.degreeCelsius;
            this.degreeCelsius = degreeCelsius;
            if (updateKelvin) {
                float k = (float)degreeCelsius + 273.15f;
                this.setKelvin(k);
                this.updateFahrenheit();
                this.updateRankine();
            }
            this.firePropertyChanged(PROPERTY_DEGREE_CELSIUS, oldValue, degreeCelsius);
        }

        public int getDegreeCelsius() {
            return this.degreeCelsius;
        }

        public void setDegreeFahrenheit(int degreeFahrenheit) {
            this.setDegreeFahrenheit(degreeFahrenheit, true);
        }

        private void setDegreeFahrenheit(int degreeFahrenheit, boolean updateKelvin) {
            int oldValue = this.degreeFahrenheit;
            this.degreeFahrenheit = degreeFahrenheit;
            if (updateKelvin) {
                float c = (float)(degreeFahrenheit - 32) / 1.8f;
                float k = c + 273.15f;
                this.setKelvin(k);
                this.updateCelsius();
                this.updateRankine();
            }
            this.firePropertyChanged(PROPERTY_DEGREE_FAHRENHEITN, oldValue, degreeFahrenheit);
        }

        public int getDegreeFahrenheit() {
            return this.degreeFahrenheit;
        }

        public void setKelvin(float kelvin) {
            this.kelvin = kelvin;
            System.out.println("TraverseSubModuleController.Temperature.setKelvin() " + kelvin);
        }

        public float getKelvin() {
            return this.kelvin;
        }

        public void setRankine(int rankine) {
            this.rankine = rankine;
            if (rankine == 582) {
                TraverseSubModuleController.this.rankineStatusMeter.setGradientStartColor((Object)new Color(null, 0, 255, 0));
                TraverseSubModuleController.this.rankineStatusMeter.setGradientEndColor((Object)new Color(null, 0, 128, 0));
            } else {
                TraverseSubModuleController.this.rankineStatusMeter.setGradientStartColor((Object)new Color(null, 255, 255, 255));
                TraverseSubModuleController.this.rankineStatusMeter.setGradientEndColor((Object)new Color(null, 0, 0, 128));
            }
        }

        public int getRankine() {
            return this.rankine;
        }

        private void updateCelsius() {
            int c = Math.round(this.getKelvin() - 273.15f);
            this.setDegreeCelsius(c, false);
        }

        private void updateFahrenheit() {
            int c = Math.round(this.getKelvin() - 273.15f);
            int f = Math.round((float)c * 1.8f + 32.0f);
            this.setDegreeFahrenheit(f, false);
        }

        private void updateRankine() {
            int r = Math.round(this.getKelvin() * 9.0f / 5.0f);
            this.setRankine(r);
        }
    }

    private class TemperatureListener
    implements IActionListener {
        private TemperatureListener() {
        }

        public void callback() {
            TraverseSubModuleController.this.updateAllRidgetsFromModel();
        }
    }
}

