/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.ping.client.widgets;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class ProgressBarWidget
extends Canvas {
    private static final int HEIGHT = 18;
    private int selection = 0;
    private int minimum = 0;
    private int maximum = 100;

    public ProgressBarWidget(Composite parent) {
        super(parent, 2052);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ProgressBarWidget.this.paintControl(e);
            }
        });
    }

    public void dispose() {
        super.dispose();
    }

    public void paintControl(PaintEvent e) {
        GC gc = e.gc;
        Rectangle clientArea = this.getClientArea();
        gc.setBackground(this.getBackground());
        gc.fillRectangle(clientArea);
        gc.setBackground(this.getForeground());
        int width = (int)((double)clientArea.width * this.getPercentage());
        gc.fillRectangle(clientArea.x, clientArea.y, width, clientArea.height);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        if (size.y > 18) {
            size.y = 18;
        }
        return size;
    }

    public int getSelection() {
        return this.selection;
    }

    public void setSelection(int selection) {
        this.selection = selection;
        this.redraw();
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
        this.redraw();
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
        this.redraw();
    }

    protected double getPercentage() {
        return (double)this.getSelection() / (double)(this.getMaximum() - this.getMinimum());
    }
}

