/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.presentation.stack.common;

import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.listener.ISubModuleNodeListener;
import org.eclipse.riena.navigation.listener.NavigationTreeObserver;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.ui.controllers.SubApplicationController;
import org.eclipse.riena.navigation.ui.swt.ApplicationUtility;
import org.eclipse.riena.navigation.ui.swt.component.SubApplicationSwitcherWidget;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ModuleGroupRenderer;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.SubModuleViewRenderer;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewProvider;
import org.eclipse.riena.navigation.ui.swt.presentation.stack.TitlelessStackPresentation;
import org.eclipse.riena.navigation.ui.swt.presentation.stack.common.StackPresentationControlFilter;
import org.eclipse.riena.ui.swt.EmbeddedTitleBar;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.StackDropResult;
import org.eclipse.ui.presentations.StackPresentation;

public class TitlelessStackPresentation3xRAP
extends StackPresentation {
    private static boolean navigationVisible;
    private final Set<IPresentablePart> knownParts = new HashSet<IPresentablePart>();
    private IPresentablePart current;
    private IPresentablePart navigation;
    private final Composite parent;
    private Composite placeHolder;
    private SubModuleViewRenderer renderer;
    private boolean hasListener;

    public TitlelessStackPresentation3xRAP(Composite parent, IStackPresentationSite stackSite) {
        super(stackSite);
        this.parent = new Composite(parent, 0x20000000);
        this.createPlaceHolder(parent);
        this.createSubModuleViewArea();
        if (TitlelessStackPresentation3xRAP.isNavigationFastViewEnabled()) {
            CloseNavigationMouseListener closeNavigationMouseListener = new CloseNavigationMouseListener();
            parent.getDisplay().addFilter(3, (Listener)closeNavigationMouseListener);
        }
    }

    private void createPlaceHolder(Composite parent) {
        this.placeHolder = new Composite(parent, 0);
        this.placeHolder.setLayout((Layout)new FormLayout());
        this.placeHolder.setBounds(0, 0, 0, 0);
        this.placeHolder.setBackground(LnfManager.getLnf().getColor("SubModule.background"));
    }

    public void addPart(IPresentablePart newPart, Object cookie) {
        this.initializeSubModuleChangeListener();
        if (this.isNavigation(newPart)) {
            this.navigation = newPart;
        }
        this.knownParts.add(newPart);
    }

    private void observeNavigation() {
        NavigationTreeObserver observer = new NavigationTreeObserver();
        observer.addListener((ISubModuleNodeListener)new StackPresentationSubModuleListener());
        observer.addListenerTo(this.getSubApplicationNode());
    }

    private void hideComposite(Control control) {
        if (control == null || control.isDisposed()) {
            return;
        }
        control.setBounds(new Rectangle(0, 0, 0, 0));
        control.setVisible(false);
    }

    private Rectangle calcPlaceHolderBounds() {
        Rectangle tmp = this.calcSubModuleInnerBounds();
        Rectangle placeHolderBounds = null;
        EmbeddedTitleBar tb = (EmbeddedTitleBar)this.locateControl(this.current.getControl(), StackPresentationControlFilter.TITLE_BAR_FILTER);
        placeHolderBounds = tb != null ? new Rectangle(tmp.x, tmp.y + tb.getBounds().height, tmp.width, tmp.height) : new Rectangle(tmp.x, tmp.y + 10, tmp.width, tmp.height);
        return placeHolderBounds;
    }

    private Control locateControl(Control ctrl, StackPresentationControlFilter filter) {
        if (ctrl == null) {
            return null;
        }
        if (filter.accept(ctrl)) {
            return ctrl;
        }
        if (ctrl instanceof Composite) {
            Control[] children;
            Control[] controlArray = children = ((Composite)ctrl).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                Control result = this.locateControl(child, filter);
                if (result != null) {
                    return result;
                }
                ++n2;
            }
        }
        return null;
    }

    public ISubApplicationNode getSubApplicationNode() {
        if (this.navigation == null) {
            return null;
        }
        return (ISubApplicationNode)this.findDataObject(this.navigation.getControl(), "subapplication.node");
    }

    private Object findDataObject(Control control, String dataKey) {
        Object data = control.getData(dataKey);
        if (data != null) {
            return data;
        }
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] children = composite.getChildren();
            int childCount = children.length;
            int i = 0;
            while (i < childCount && data == null) {
                data = this.findDataObject(children[i], dataKey);
                ++i;
            }
        }
        return data;
    }

    public void selectPart(IPresentablePart toSelect) {
        if (this.current == toSelect) {
            return;
        }
        if (this.isNavigation(toSelect)) {
            this.selectNavigation(toSelect);
        } else if (toSelect != null) {
            this.current = toSelect;
        }
    }

    private void selectNavigation(IPresentablePart toSelect) {
        this.observeNavigation();
        Rectangle navi = TitlelessStackPresentation3xRAP.calcNavigationBounds(this.parent);
        toSelect.setBounds(navi);
        this.redrawSubModuleTitle();
        if (!TitlelessStackPresentation3xRAP.isNavigationFastViewEnabled()) {
            toSelect.setVisible(true);
        }
    }

    public void setBounds(Rectangle bounds) {
        this.parent.setBounds(bounds);
        if (this.navigation != null) {
            Rectangle navi = TitlelessStackPresentation3xRAP.calcNavigationBounds(this.parent);
            this.navigation.setBounds(navi);
        }
        if (this.current != null) {
            Rectangle innerBounds = this.calcSubModuleInnerBounds();
            for (IPresentablePart part : this.knownParts) {
                if (part == this.current || this.isNavigation(part)) continue;
                part.setBounds(new Rectangle(0, 0, 0, 0));
            }
            this.current.setBounds(innerBounds);
        }
        this.parent.setVisible(true);
    }

    public void removePart(IPresentablePart oldPart) {
        if (this.isNavigation(oldPart)) {
            this.navigation = null;
        } else if (oldPart == this.current) {
            this.current = null;
        }
        this.knownParts.remove(oldPart);
    }

    public void dispose() {
        if (this.getRenderer() != null) {
            this.getRenderer().dispose();
        }
    }

    public StackDropResult dragOver(Control currentControl, Point location) {
        return null;
    }

    public Control getControl() {
        return this.parent;
    }

    public Control[] getTabList(IPresentablePart part) {
        if (this.current != null) {
            return new Control[]{this.current.getControl()};
        }
        return new Control[0];
    }

    public void setActive(int newState) {
    }

    public void setState(int state) {
    }

    public void setVisible(boolean isVisible) {
        this.parent.setVisible(isVisible);
    }

    public void showPaneMenu() {
    }

    public void showSystemMenu() {
    }

    private Rectangle calcSubModuleInnerBounds() {
        return this.getSubModuleViewRenderer().computeInnerBounds(this.calcSubModuleOuterBounds());
    }

    private Rectangle calcSubModuleOuterBounds() {
        Rectangle naviBounds = TitlelessStackPresentation3xRAP.calcNavigationBounds(this.parent);
        int x = TitlelessStackPresentation3xRAP.isNavigationFastViewEnabled() ? TitlelessStackPresentation3xRAP.getShellSubModuleGap() : naviBounds.x + naviBounds.width + this.getNavigationSubModuleGap();
        int y = naviBounds.y;
        int width = this.parent.getBounds().width - x - TitlelessStackPresentation3xRAP.getShellSubModuleGap();
        int height = naviBounds.height;
        Rectangle outerBounds = new Rectangle(x, y, width, height);
        return outerBounds;
    }

    public static Rectangle calcNavigationBounds(Composite parent) {
        GC gc = new GC((Drawable)parent);
        try {
            Point size = TitlelessStackPresentation3xRAP.getModuleGroupRenderer().computeSize(gc, -1, -1);
            int x = TitlelessStackPresentation3xRAP.getShellNavigationGap();
            int width = size.x + (TitlelessStackPresentation3xRAP.isNavigationFastViewEnabled() ? 6 : 0);
            Integer statuslineHeight = LnfManager.getLnf().getIntegerSetting("statusline.height");
            statuslineHeight = SwtUtilities.convertYToDpi((int)statuslineHeight);
            int height = parent.getBounds().height - TitlelessStackPresentation.PADDING_BOTTOM - statuslineHeight;
            Rectangle rectangle = new Rectangle(x, 0, width, height);
            return rectangle;
        }
        finally {
            gc.dispose();
        }
    }

    private static boolean isNavigationFastViewEnabled() {
        return new ApplicationUtility().isNavigationFastViewEnabled();
    }

    private void createSubModuleViewArea() {
        this.parent.setBackground(LnfManager.getLnf().getColor("SubModule.background"));
        SWTFacade.getDefault().addPaintListener((Control)this.parent, (EventListener)new PaintListener(){

            public void paintControl(PaintEvent e) {
                SubModuleViewRenderer viewRenderer;
                if (TitlelessStackPresentation3xRAP.this.current != null && (viewRenderer = TitlelessStackPresentation3xRAP.this.getRenderer()) != null) {
                    Rectangle bounds = TitlelessStackPresentation3xRAP.this.calcSubModuleOuterBounds();
                    viewRenderer.setBounds(bounds);
                    viewRenderer.paint(e.gc, null);
                }
            }
        });
    }

    private IWorkbenchPage getActivePage() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    private SubModuleViewRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = (SubModuleViewRenderer)LnfManager.getLnf().getRenderer("SubModuleView.renderer");
        }
        return this.renderer;
    }

    private static ModuleGroupRenderer getModuleGroupRenderer() {
        return (ModuleGroupRenderer)LnfManager.getLnf().getRenderer("ModuleGroup.renderer");
    }

    private SubModuleViewRenderer getSubModuleViewRenderer() {
        return (SubModuleViewRenderer)LnfManager.getLnf().getRenderer("SubModuleView.renderer");
    }

    private synchronized void initializeSubModuleChangeListener() {
        if (this.hasListener) {
            return;
        }
        SubApplicationController controller = this.getSubApplicationController();
        if (controller != null) {
            NavigationTreeObserver navigationTreeObserver = new NavigationTreeObserver();
            navigationTreeObserver.addListener((ISubModuleNodeListener)new SubModuleNodeListener(){

                public void activated(ISubModuleNode source) {
                    TitlelessStackPresentation3xRAP.this.redrawSubModuleTitle();
                }
            });
            navigationTreeObserver.addListenerTo((ISubApplicationNode)controller.getNavigationNode());
            this.hasListener = true;
        }
    }

    private SubApplicationController getSubApplicationController() {
        SubApplicationController result = null;
        IWorkbenchPage page = this.getActivePage();
        if (page != null) {
            String id = page.getPerspective().getId();
            ISubApplicationNode subApplication = (ISubApplicationNode)SwtViewProvider.getInstance().getNavigationNode(id, ISubApplicationNode.class);
            result = (SubApplicationController)subApplication.getNavigationNodeController();
        }
        return result;
    }

    private boolean isNavigation(IPresentablePart part) {
        return part.getPartProperty("navigation") != null;
    }

    private void redrawSubModuleTitle() {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.redraw();
        }
    }

    private int getNavigationSubModuleGap() {
        RienaDefaultLnf lnf = LnfManager.getLnf();
        return lnf.getIntegerSetting("NavigationSubModule.gap", Integer.valueOf(4));
    }

    private static int getShellNavigationGap() {
        RienaDefaultLnf lnf = LnfManager.getLnf();
        return lnf.getIntegerSetting("TitlelessShellNavigationHorizontal.gap", Integer.valueOf(2));
    }

    private static int getShellSubModuleGap() {
        RienaDefaultLnf lnf = LnfManager.getLnf();
        return lnf.getIntegerSetting("TitlelessShellSubModuleHorizontal.gap", Integer.valueOf(2));
    }

    public void setNavigationVisible(boolean visible) {
        if (TitlelessStackPresentation3xRAP.isNavigationFastViewEnabled()) {
            this.navigation.setVisible(visible);
        }
    }

    public boolean isNavigationVisible() {
        if (TitlelessStackPresentation3xRAP.isNavigationFastViewEnabled()) {
            return this.navigation.getControl().isVisible();
        }
        return true;
    }

    private final class CloseNavigationMouseListener
    implements Listener {
        private CloseNavigationMouseListener() {
        }

        public void handleEvent(Event event) {
            if (event.button == 1 && TitlelessStackPresentation3xRAP.this.navigation != null && TitlelessStackPresentation3xRAP.this.isNavigationVisible() && this.isSelectedWidgetAllowedToCloseNavigation(event.widget)) {
                Point widgetLocationOnDisplay = ((Control)event.widget).toDisplay(new Point(0, 0));
                Rectangle mouseLocation = event.getBounds();
                Control navigationControl = TitlelessStackPresentation3xRAP.this.navigation.getControl();
                Rectangle navigationBounds = navigationControl.getBounds();
                Point navigationLocationOnDisplay = navigationControl.toDisplay(0, 0);
                Point mousePositionOnDisplay = new Point(mouseLocation.x + widgetLocationOnDisplay.x, mouseLocation.y + widgetLocationOnDisplay.y);
                if (mousePositionOnDisplay.x > navigationLocationOnDisplay.x + navigationBounds.width || mousePositionOnDisplay.y > navigationLocationOnDisplay.y + navigationBounds.height || mousePositionOnDisplay.y < navigationLocationOnDisplay.y) {
                    TitlelessStackPresentation3xRAP.this.setNavigationVisible(false);
                }
            }
        }

        private boolean isSelectedWidgetAllowedToCloseNavigation(Widget widget) {
            return widget instanceof Control && !(widget instanceof ToolBar) && !(widget instanceof SubApplicationSwitcherWidget);
        }
    }

    private class StackPresentationSubModuleListener
    extends SubModuleNodeListener {
        private StackPresentationSubModuleListener() {
        }

        public void beforeActivated(ISubModuleNode source) {
            if (TitlelessStackPresentation3xRAP.this.current != null) {
                TitlelessStackPresentation3xRAP.this.placeHolder.setBounds(TitlelessStackPresentation3xRAP.this.calcPlaceHolderBounds());
                TitlelessStackPresentation3xRAP.this.placeHolder.setVisible(true);
                TitlelessStackPresentation3xRAP.this.placeHolder.moveAbove(null);
                TitlelessStackPresentation3xRAP.this.placeHolder.update();
                TitlelessStackPresentation3xRAP.this.current.getControl().update();
            }
        }

        public void afterActivated(ISubModuleNode source) {
            TitlelessStackPresentation3xRAP.this.current.setBounds(TitlelessStackPresentation3xRAP.this.calcSubModuleInnerBounds());
            TitlelessStackPresentation3xRAP.this.current.setVisible(true);
            if (new ApplicationUtility().isNavigationFastViewEnabled()) {
                TitlelessStackPresentation3xRAP.this.setNavigationVisible(navigationVisible);
            }
            TitlelessStackPresentation3xRAP.this.hideComposite((Control)TitlelessStackPresentation3xRAP.this.placeHolder);
            TitlelessStackPresentation3xRAP.this.redrawSubModuleTitle();
            TitlelessStackPresentation3xRAP.this.current.getControl().moveAbove(null);
            TitlelessStackPresentation3xRAP.this.current.getControl().update();
        }

        public void afterDeactivated(ISubModuleNode source) {
            super.afterDeactivated((INavigationNode)source);
            if (new ApplicationUtility().isNavigationFastViewEnabled()) {
                navigationVisible = TitlelessStackPresentation3xRAP.this.isNavigationVisible();
            }
        }
    }
}

