/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.cache;

import org.eclipse.riena.core.cache.GenericObjectCache;
import org.eclipse.riena.core.cache.IGenericObjectCache;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.ManualTestCase;
import org.eclipse.riena.core.util.Nop;

@ManualTestCase
public class GenericObjectCacheTest
extends RienaTestCase {
    private IGenericObjectCache<String, Integer> genericCache;
    private IGenericObjectCache<Integer, TestRunner> genericCache2;
    private IGenericObjectCache<String, StringBuffer> genericCache3;

    public void setUp() throws Exception {
        super.setUp();
        this.genericCache = new GenericObjectCache();
    }

    public void tearDown() throws Exception {
        this.genericCache = null;
        super.tearDown();
        this.genericCache = null;
    }

    public void testInstantiate() {
        this.genericCache.put((Object)"test", (Object)2);
        GenericObjectCacheTest.assertNotNull((String)"did not find put object in cache", (Object)this.genericCache.get((Object)"test"));
        GenericObjectCacheTest.assertTrue((String)"object in cache has incorrect value", (boolean)((Integer)this.genericCache.get((Object)"test")).equals(2));
        this.genericCache.clear();
    }

    public void testTimeout() throws Exception {
        this.genericCache.put((Object)"test", (Object)3);
        this.genericCache.setTimeout(300);
        Thread.sleep(100L);
        GenericObjectCacheTest.assertNotNull((String)"did not find put object in cache", (Object)this.genericCache.get((Object)"test"));
        Thread.sleep(600L);
        GenericObjectCacheTest.assertNull((String)"must not find object in cache after timeout", (Object)this.genericCache.get((Object)"test"));
        this.genericCache.clear();
    }

    public void testPutMultiple() throws Exception {
        GenericObjectCache genericCacheLocal = new GenericObjectCache();
        int i = 0;
        while (i < 30) {
            genericCacheLocal.put((Object)i, (Object)"testvalue");
            ++i;
        }
        i = 0;
        while (i < 30) {
            GenericObjectCacheTest.assertNotNull((String)"object not found in cache", (Object)genericCacheLocal.get((Object)i));
            ++i;
        }
        genericCacheLocal.clear();
    }

    public void testMultiThread() throws Exception {
        this.genericCache2 = new GenericObjectCache();
        Thread[] runner = new Thread[10];
        int i = 0;
        while (i < 10) {
            runner[i] = new TestRunner(i * 20, i * 20 + 19, 10);
            ++i;
        }
        this.runAndCheckThreads(runner);
        this.genericCache.clear();
    }

    public void testMultiThreadSameRange() throws Exception {
        this.genericCache2 = new GenericObjectCache();
        Thread[] runner = new Thread[10];
        int i = 0;
        while (i < 10) {
            runner[i] = new TestRunner(0, 20, 10);
            ++i;
        }
        this.runAndCheckThreads(runner);
        this.genericCache.clear();
    }

    public void testMultiThreadLargeNoOfThreadsSameRange() throws Exception {
        this.genericCache2 = new GenericObjectCache();
        Thread[] runner = new Thread[100];
        int i = 0;
        while (i < 100) {
            runner[i] = new TestRunner(0, 20, 100);
            ++i;
        }
        this.runAndCheckThreads(runner);
        this.genericCache.clear();
    }

    public void testMultiThreadLargeNoOfThreads() throws Exception {
        this.genericCache2 = new GenericObjectCache();
        Thread[] runner = new Thread[100];
        int i = 0;
        while (i < 100) {
            runner[i] = new TestRunner(i * 20, i * 20 + 19, 100);
            ++i;
        }
        this.runAndCheckThreads(runner);
        this.genericCache.clear();
    }

    public void testTryOverloadCache() throws Exception {
        this.genericCache3 = new GenericObjectCache();
        int x = 1;
        int i = 0;
        while (i < 5000) {
            this.genericCache3.put((Object)Integer.valueOf(i).toString(), (Object)new StringBuffer(20000));
            if (++x > 100) {
                x = 0;
            }
            ++i;
        }
        this.genericCache3.clear();
        this.genericCache3 = null;
    }

    private void runAndCheckThreads(Thread[] runner) {
        Status status = new Status();
        Thread[] threadArray = runner;
        int n = runner.length;
        int n2 = 0;
        while (n2 < n) {
            Thread element = threadArray[n2];
            ((TestRunner)element).setStatus(status);
            element.start();
            ++n2;
        }
        int count = 0;
        boolean first = true;
        Thread.yield();
        while (count != 0 || first) {
            count = 0;
            Thread[] threadArray2 = runner;
            int n3 = runner.length;
            int n4 = 0;
            while (n4 < n3) {
                Thread element = threadArray2[n4];
                if (element.isAlive()) {
                    ++count;
                }
                ++n4;
            }
            GenericObjectCacheTest.assertNull((String)"one of the threads created an error", (Object)status.getLastException());
            first = false;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                Nop.reason((String)"no action");
            }
        }
    }

    static class Status {
        private Exception lastException;

        Status() {
        }

        public void setLastException(Exception lastException) {
            this.lastException = lastException;
        }

        public Exception getLastException() {
            return this.lastException;
        }
    }

    class TestRunner
    extends Thread {
        private final int lowRange;
        private final int highRange;
        private final int runs;
        private Status status;

        TestRunner(int lowRange, int highRange, int runs) {
            this.lowRange = lowRange;
            this.highRange = highRange;
            this.runs = runs;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        @Override
        public void run() {
            try {
                int i = 0;
                while (i < this.runs) {
                    int k = this.lowRange;
                    while (k <= this.highRange) {
                        GenericObjectCacheTest.this.genericCache2.put((Object)k, (Object)this);
                        ++k;
                    }
                    k = this.lowRange;
                    while (k <= this.highRange) {
                        GenericObjectCacheTest.assertNotNull((String)"object not found in cache", (Object)GenericObjectCacheTest.this.genericCache2.get((Object)k));
                        ++k;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                this.status.setLastException(e);
            }
        }
    }
}

