/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.net.URL;
import java.util.Collection;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.SerializationException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.navigation.ui.swt.views.ImageReplacer;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.ILocalWorkingSetManager;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.ISaveableFilter;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementReference;
import org.eclipse.ui.commands.IWorkbenchCommandSupport;
import org.eclipse.ui.contexts.IWorkbenchContextSupport;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.operations.IWorkbenchOperationSupport;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.themes.IThemeManager;
import org.eclipse.ui.views.IViewRegistry;
import org.eclipse.ui.wizards.IWizardRegistry;

@UITestCase
public class ImageReplacerTest
extends TestCase {
    public void testGetImageName() throws Exception {
        ImageReplacer replacer = ImageReplacer.getInstance();
        String imageName = (String)ReflectionUtils.invokeHidden((Object)replacer, (String)"getImageName", (Object[])new Object[]{""});
        ImageReplacerTest.assertEquals((String)"", (String)imageName);
        imageName = (String)ReflectionUtils.invokeHidden((Object)replacer, (String)"getImageName", (Object[])new Object[]{"abc"});
        ImageReplacerTest.assertEquals((String)"abc", (String)imageName);
        imageName = (String)ReflectionUtils.invokeHidden((Object)replacer, (String)"getImageName", (Object[])new Object[]{"def.txt"});
        ImageReplacerTest.assertEquals((String)"def", (String)imageName);
        imageName = (String)ReflectionUtils.invokeHidden((Object)replacer, (String)"getImageName", (Object[])new Object[]{"ghi00.txt"});
        ImageReplacerTest.assertEquals((String)"ghi00", (String)imageName);
        RienaDefaultLnf originalLnf = LnfManager.getLnf();
        LnfManager.setLnf((RienaDefaultLnf)new MyLnf());
        imageName = (String)ReflectionUtils.invokeHidden((Object)replacer, (String)"getImageName", (Object[])new Object[]{"ghi00.txt"});
        ImageReplacerTest.assertEquals((String)"ghi", (String)imageName);
        imageName = (String)ReflectionUtils.invokeHidden((Object)replacer, (String)"getImageName", (Object[])new Object[]{"/folder00/jkl00_d_.txt"});
        ImageReplacerTest.assertEquals((String)"jkl00_d_", (String)imageName);
        imageName = (String)ReflectionUtils.invokeHidden((Object)replacer, (String)"getImageName", (Object[])new Object[]{"/folderXY/MNO00.png"});
        ImageReplacerTest.assertEquals((String)"MNO", (String)imageName);
        LnfManager.setLnf((RienaDefaultLnf)originalLnf);
    }

    public void testGetScaledImage() throws Exception {
        RienaDefaultLnf originalLnf = LnfManager.getLnf();
        LnfManager.setLnf((RienaDefaultLnf)new MyLnf());
        ImageReplacer replacer = ImageReplacer.getInstance();
        ImageDescriptor fileImageDescriptor = ImageDescriptor.createFromFile(null, (String)"/icons/testimagea00.png");
        ImageDescriptor imageDescriptor = (ImageDescriptor)ReflectionUtils.invokeHidden((Object)replacer, (String)"getScaledImage", (Object[])new Object[]{fileImageDescriptor});
        ImageReplacerTest.assertNotNull((Object)imageDescriptor);
        ImageReplacerTest.assertEquals((int)16, (int)imageDescriptor.getImageData().width);
        ImageReplacerTest.assertEquals((int)16, (int)imageDescriptor.getImageData().height);
        Point dpi = SwtUtilities.getDpi();
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpi", (Object)new Point(144, 144));
        fileImageDescriptor = ImageDescriptor.createFromFile(null, (String)"/icons/testimagea00.png");
        imageDescriptor = (ImageDescriptor)ReflectionUtils.invokeHidden((Object)replacer, (String)"getScaledImage", (Object[])new Object[]{fileImageDescriptor});
        ImageReplacerTest.assertNotNull((Object)imageDescriptor);
        ImageReplacerTest.assertEquals((int)24, (int)imageDescriptor.getImageData().width);
        ImageReplacerTest.assertEquals((int)24, (int)imageDescriptor.getImageData().height);
        URL url = ((Object)((Object)this)).getClass().getResource("/icons/testimagea00.png");
        ImageDescriptor urlimageDescriptor = ImageDescriptor.createFromURL((URL)url);
        imageDescriptor = (ImageDescriptor)ReflectionUtils.invokeHidden((Object)replacer, (String)"getScaledImage", (Object[])new Object[]{urlimageDescriptor});
        ImageReplacerTest.assertNotNull((Object)imageDescriptor);
        ImageReplacerTest.assertEquals((int)24, (int)imageDescriptor.getImageData().width);
        ImageReplacerTest.assertEquals((int)24, (int)imageDescriptor.getImageData().height);
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpi", (Object)dpi);
        LnfManager.setLnf((RienaDefaultLnf)originalLnf);
    }

    public void testIsImageDescriptorSupported() throws Exception {
        ImageReplacer replacer = ImageReplacer.getInstance();
        ImageDescriptor fileImageDescriptor = ImageDescriptor.createFromFile(null, (String)"/icons/testimagea00.png");
        boolean isSupported = (Boolean)ReflectionUtils.invokeHidden((Object)replacer, (String)"isImageDescriptorSupported", (Object[])new Object[]{fileImageDescriptor});
        ImageReplacerTest.assertTrue((boolean)isSupported);
        URL url = ((Object)((Object)this)).getClass().getResource("/icons/testimagea00.png");
        ImageDescriptor urlimageDescriptor = ImageDescriptor.createFromURL((URL)url);
        isSupported = (Boolean)ReflectionUtils.invokeHidden((Object)replacer, (String)"isImageDescriptorSupported", (Object[])new Object[]{urlimageDescriptor});
        ImageReplacerTest.assertTrue((boolean)isSupported);
    }

    public void testGetInstance() throws Exception {
        ImageReplacer replacer = ImageReplacer.getInstance();
        ImageReplacerTest.assertNotNull((Object)replacer);
        ImageReplacerTest.assertSame((Object)replacer, (Object)ImageReplacer.getInstance());
    }

    public void testReplaceImagesCommandContributionItem() throws Exception {
        ImageReplacer replacer = ImageReplacer.getInstance();
        RienaDefaultLnf originalLnf = LnfManager.getLnf();
        LnfManager.setLnf((RienaDefaultLnf)new MyLnf());
        CommandContributionItem item = new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)new MyServiceLocator(), "id", "cmdId", 8));
        URL url = ((Object)((Object)this)).getClass().getResource("/icons/testimagea00.png");
        ImageDescriptor urlImageDescriptor = ImageDescriptor.createFromURL((URL)url);
        ReflectionUtils.setHidden((Object)item, (String)"contributedIcon", (Object)urlImageDescriptor);
        ReflectionUtils.setHidden((Object)item, (String)"icon", (Object)urlImageDescriptor);
        ReflectionUtils.invokeHidden((Object)replacer, (String)"replaceImages", (Object[])new Object[]{item});
        ImageDescriptor iconDescriptor = (ImageDescriptor)ReflectionUtils.getHidden((Object)item, (String)"icon");
        ImageReplacerTest.assertNotSame((Object)urlImageDescriptor, (Object)iconDescriptor);
        ImageReplacerTest.assertEquals((int)16, (int)iconDescriptor.getImageData().width);
        ImageReplacerTest.assertEquals((int)16, (int)iconDescriptor.getImageData().height);
        Point dpi = SwtUtilities.getDpi();
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpi", (Object)new Point(144, 144));
        ReflectionUtils.setHidden((Object)item, (String)"contributedIcon", (Object)urlImageDescriptor);
        ReflectionUtils.setHidden((Object)item, (String)"icon", (Object)urlImageDescriptor);
        ReflectionUtils.invokeHidden((Object)replacer, (String)"replaceImages", (Object[])new Object[]{item});
        iconDescriptor = (ImageDescriptor)ReflectionUtils.getHidden((Object)item, (String)"icon");
        ImageReplacerTest.assertNotSame((Object)urlImageDescriptor, (Object)iconDescriptor);
        ImageReplacerTest.assertEquals((int)24, (int)iconDescriptor.getImageData().width);
        ImageReplacerTest.assertEquals((int)24, (int)iconDescriptor.getImageData().height);
        ReflectionUtils.setHidden((Object)item, (String)"contributedDisabledIcon", (Object)urlImageDescriptor);
        ReflectionUtils.setHidden((Object)item, (String)"disabledIcon", (Object)urlImageDescriptor);
        ReflectionUtils.invokeHidden((Object)replacer, (String)"replaceImages", (Object[])new Object[]{item});
        iconDescriptor = (ImageDescriptor)ReflectionUtils.getHidden((Object)item, (String)"disabledIcon");
        ImageReplacerTest.assertNotSame((Object)urlImageDescriptor, (Object)iconDescriptor);
        ImageReplacerTest.assertEquals((int)24, (int)iconDescriptor.getImageData().width);
        ImageReplacerTest.assertEquals((int)24, (int)iconDescriptor.getImageData().height);
        ReflectionUtils.setHidden((Object)item, (String)"contributedHoverIcon", (Object)urlImageDescriptor);
        ReflectionUtils.setHidden((Object)item, (String)"hoverIcon", (Object)urlImageDescriptor);
        ReflectionUtils.invokeHidden((Object)replacer, (String)"replaceImages", (Object[])new Object[]{item});
        iconDescriptor = (ImageDescriptor)ReflectionUtils.getHidden((Object)item, (String)"hoverIcon");
        ImageReplacerTest.assertNotSame((Object)urlImageDescriptor, (Object)iconDescriptor);
        ImageReplacerTest.assertEquals((int)24, (int)iconDescriptor.getImageData().width);
        ImageReplacerTest.assertEquals((int)24, (int)iconDescriptor.getImageData().height);
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpi", (Object)dpi);
        LnfManager.setLnf((RienaDefaultLnf)originalLnf);
    }

    private static class MyLnf
    extends RienaDefaultLnf {
        private MyLnf() {
        }

        public String getIconScaleSuffix(Point dpi) {
            if (dpi == null) {
                return "00";
            }
            if (dpi.x <= 96) {
                return "00";
            }
            return "03";
        }
    }

    private class MyServiceLocator
    implements IServiceLocator {
        private MyServiceLocator() {
        }

        public Object getService(Class api) {
            if (api.equals(IWorkbenchLocationService.class)) {
                return new IWorkbenchLocationService(){

                    public String getServiceScope() {
                        return null;
                    }

                    public int getServiceLevel() {
                        return 0;
                    }

                    public IWorkbench getWorkbench() {
                        return new IWorkbench(){

                            public boolean hasService(Class api) {
                                return false;
                            }

                            public Object getService(Class api) {
                                return null;
                            }

                            public Object getAdapter(Class adapter) {
                                return null;
                            }

                            public IWorkbenchPage showPerspective(String perspectiveId, IWorkbenchWindow window, IAdaptable input) throws WorkbenchException {
                                return null;
                            }

                            public IWorkbenchPage showPerspective(String perspectiveId, IWorkbenchWindow window) throws WorkbenchException {
                                return null;
                            }

                            public boolean saveAllEditors(boolean confirm) {
                                return false;
                            }

                            public boolean saveAll(IShellProvider shellProvider, IRunnableContext runnableContext, ISaveableFilter filter, boolean confirm) {
                                return false;
                            }

                            public boolean restart() {
                                return false;
                            }

                            public void removeWorkbenchListener(IWorkbenchListener listener) {
                            }

                            public void removeWindowListener(IWindowListener listener) {
                            }

                            public IWorkbenchWindow openWorkbenchWindow(String perspectiveId, IAdaptable input) throws WorkbenchException {
                                return null;
                            }

                            public IWorkbenchWindow openWorkbenchWindow(IAdaptable input) throws WorkbenchException {
                                return null;
                            }

                            public boolean isStarting() {
                                return false;
                            }

                            public boolean isClosing() {
                                return false;
                            }

                            public IWorkingSetManager getWorkingSetManager() {
                                return null;
                            }

                            public IWorkbenchWindow[] getWorkbenchWindows() {
                                return null;
                            }

                            public int getWorkbenchWindowCount() {
                                return 0;
                            }

                            public IViewRegistry getViewRegistry() {
                                return null;
                            }

                            public IThemeManager getThemeManager() {
                                return null;
                            }

                            public ISharedImages getSharedImages() {
                                return null;
                            }

                            public IProgressService getProgressService() {
                                return null;
                            }

                            public IPreferenceStore getPreferenceStore() {
                                return null;
                            }

                            public PreferenceManager getPreferenceManager() {
                                return null;
                            }

                            public IPerspectiveRegistry getPerspectiveRegistry() {
                                return null;
                            }

                            public IWorkbenchOperationSupport getOperationSupport() {
                                return null;
                            }

                            public IWizardRegistry getNewWizardRegistry() {
                                return null;
                            }

                            public IShellProvider getModalDialogShellProvider() {
                                return null;
                            }

                            public IIntroManager getIntroManager() {
                                return null;
                            }

                            public IWizardRegistry getImportWizardRegistry() {
                                return null;
                            }

                            public IWorkbenchHelpSystem getHelpSystem() {
                                return null;
                            }

                            public IExtensionTracker getExtensionTracker() {
                                return null;
                            }

                            public IWizardRegistry getExportWizardRegistry() {
                                return null;
                            }

                            public IElementFactory getElementFactory(String factoryId) {
                                return null;
                            }

                            public IEditorRegistry getEditorRegistry() {
                                return null;
                            }

                            public Display getDisplay() {
                                return null;
                            }

                            public IDecoratorManager getDecoratorManager() {
                                return null;
                            }

                            public IWorkbenchContextSupport getContextSupport() {
                                return null;
                            }

                            public IWorkbenchCommandSupport getCommandSupport() {
                                return null;
                            }

                            public IWorkbenchBrowserSupport getBrowserSupport() {
                                return null;
                            }

                            public IWorkbenchActivitySupport getActivitySupport() {
                                return null;
                            }

                            public IWorkbenchWindow getActiveWorkbenchWindow() {
                                return null;
                            }

                            public ILocalWorkingSetManager createLocalWorkingSetManager() {
                                return null;
                            }

                            public boolean close() {
                                return false;
                            }

                            public void addWorkbenchListener(IWorkbenchListener listener) {
                            }

                            public void addWindowListener(IWindowListener listener) {
                            }

                            public boolean restart(boolean useCurrentWorkspace) {
                                return false;
                            }
                        };
                    }

                    public IWorkbenchWindow getWorkbenchWindow() {
                        return null;
                    }

                    public IWorkbenchPartSite getPartSite() {
                        return null;
                    }

                    public IEditorSite getMultiPageEditorSite() {
                        return null;
                    }

                    public IPageSite getPageSite() {
                        return null;
                    }
                };
            }
            if (api.equals(ICommandService.class)) {
                return new ICommandService(){

                    public void dispose() {
                    }

                    public void unregisterElement(IElementReference elementReference) {
                    }

                    public void setHelpContextId(IHandler handler, String helpContextId) {
                    }

                    public void removeExecutionListener(IExecutionListener listener) {
                    }

                    public IElementReference registerElementForCommand(ParameterizedCommand command, UIElement element) throws NotDefinedException {
                        return null;
                    }

                    public void registerElement(IElementReference elementReference) {
                    }

                    public void refreshElements(String commandId, Map filter) {
                    }

                    public void readRegistry() {
                    }

                    public ParameterType getParameterType(String parameterTypeId) {
                        return null;
                    }

                    public String getHelpContextId(String commandId) throws NotDefinedException {
                        return null;
                    }

                    public String getHelpContextId(Command command) throws NotDefinedException {
                        return null;
                    }

                    public ParameterType[] getDefinedParameterTypes() {
                        return null;
                    }

                    public Collection getDefinedParameterTypeIds() {
                        return null;
                    }

                    public Command[] getDefinedCommands() {
                        return null;
                    }

                    public Collection getDefinedCommandIds() {
                        return null;
                    }

                    public Collection getDefinedCategoryIds() {
                        return null;
                    }

                    public Category[] getDefinedCategories() {
                        return null;
                    }

                    public Command getCommand(String commandId) {
                        return (Command)ReflectionUtils.newInstanceHidden(Command.class, (Object[])new Object[]{""});
                    }

                    public Category getCategory(String categoryId) {
                        return null;
                    }

                    public ParameterizedCommand deserialize(String serializedParameterizedCommand) throws NotDefinedException, SerializationException {
                        return null;
                    }

                    public void defineUncategorizedCategory(String name, String description) {
                    }

                    public void addExecutionListener(IExecutionListener listener) {
                    }
                };
            }
            return null;
        }

        public boolean hasService(Class api) {
            return false;
        }
    }
}

