/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.ui.swt.ImageButton;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class ImageButtonTest
extends RienaTestCase {
    private Shell shell;
    private ImageButton button;

    protected void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
        this.button = new ImageButton((Composite)this.shell, 0);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        SwtUtilities.dispose((Widget)this.button);
        SwtUtilities.dispose((Widget)this.shell);
    }

    public void testAddListeners() {
        ImageButtonTest.assertEquals((int)1, (int)this.button.getListeners(9).length);
        ImageButtonTest.assertEquals((int)1, (int)this.button.getListeners(3).length);
        ImageButtonTest.assertEquals((int)1, (int)this.button.getListeners(6).length);
        ImageButtonTest.assertEquals((int)1, (int)this.button.getListeners(5).length);
        ImageButtonTest.assertEquals((int)1, (int)this.button.getListeners(15).length);
        ImageButtonTest.assertEquals((int)1, (int)this.button.getListeners(2).length);
        ImageButtonTest.assertEquals((int)1, (int)this.button.getListeners(31).length);
        ImageButtonTest.assertEquals((int)1, (int)this.button.getListeners(12).length);
        this.button = new ImageButton((Composite)this.shell, 32);
        Button hoverButton = (Button)ReflectionUtils.getHidden((Object)this.button, (String)"hoverButton");
        ImageButtonTest.assertEquals((int)1, (int)hoverButton.getListeners(3).length);
        ImageButtonTest.assertEquals((int)1, (int)hoverButton.getListeners(6).length);
        ImageButtonTest.assertEquals((int)1, (int)hoverButton.getListeners(5).length);
    }

    public void testRemoveListeners() {
        ReflectionUtils.invokeHidden((Object)this.button, (String)"removeListeners", (Object[])new Object[0]);
        ImageButtonTest.assertEquals((int)0, (int)this.button.getListeners(9).length);
        ImageButtonTest.assertEquals((int)0, (int)this.button.getListeners(3).length);
        ImageButtonTest.assertEquals((int)0, (int)this.button.getListeners(6).length);
        ImageButtonTest.assertEquals((int)0, (int)this.button.getListeners(5).length);
        ImageButtonTest.assertEquals((int)0, (int)this.button.getListeners(15).length);
        ImageButtonTest.assertEquals((int)0, (int)this.button.getListeners(2).length);
        ImageButtonTest.assertEquals((int)0, (int)this.button.getListeners(31).length);
        ImageButtonTest.assertEquals((int)0, (int)this.button.getListeners(12).length);
        this.button = new ImageButton((Composite)this.shell, 32);
        ReflectionUtils.invokeHidden((Object)this.button, (String)"removeListeners", (Object[])new Object[0]);
        Button hoverButton = (Button)ReflectionUtils.getHidden((Object)this.button, (String)"hoverButton");
        ImageButtonTest.assertEquals((int)0, (int)hoverButton.getListeners(3).length);
        ImageButtonTest.assertEquals((int)0, (int)hoverButton.getListeners(6).length);
        ImageButtonTest.assertEquals((int)0, (int)hoverButton.getListeners(5).length);
    }

    public void testGetImageToDraw() {
        Image retImage = (Image)ReflectionUtils.invokeHidden((Object)this.button, (String)"getImageToDraw", (Object[])new Object[0]);
        ImageButtonTest.assertNull((Object)retImage);
        Image image = ImageStore.getInstance().getImage("imagebutton.png");
        this.button.setImage(image);
        retImage = (Image)ReflectionUtils.invokeHidden((Object)this.button, (String)"getImageToDraw", (Object[])new Object[0]);
        ImageButtonTest.assertSame((Object)image, (Object)retImage);
        Image focusedImage = ImageStore.getInstance().getImage("spirit.png");
        this.button.setFocusedImage(focusedImage);
        Image hoverFocusedImage = ImageStore.getInstance().getImage("spirit_h_.png");
        this.button.setHoverFocusedImage(hoverFocusedImage);
        Image hoverImage = ImageStore.getInstance().getImage("imagebutton_h_.png");
        this.button.setHoverImage(hoverImage);
        Image pressedImage = ImageStore.getInstance().getImage("imagebutton_p_.png");
        this.button.setPressedImage(pressedImage);
        Image disabledImage = ImageStore.getInstance().getImage("eclipse.gif");
        this.button.setDisabledImage(disabledImage);
        ReflectionUtils.invokeHidden((Object)this.button, (String)"setFocused", (Object[])new Object[]{true});
        retImage = (Image)ReflectionUtils.invokeHidden((Object)this.button, (String)"getImageToDraw", (Object[])new Object[0]);
        ImageButtonTest.assertSame((Object)focusedImage, (Object)retImage);
        ReflectionUtils.invokeHidden((Object)this.button, (String)"setHover", (Object[])new Object[]{true});
        retImage = (Image)ReflectionUtils.invokeHidden((Object)this.button, (String)"getImageToDraw", (Object[])new Object[0]);
        ImageButtonTest.assertSame((Object)hoverFocusedImage, (Object)retImage);
        ReflectionUtils.invokeHidden((Object)this.button, (String)"setPressed", (Object[])new Object[]{true});
        retImage = (Image)ReflectionUtils.invokeHidden((Object)this.button, (String)"getImageToDraw", (Object[])new Object[0]);
        ImageButtonTest.assertSame((Object)pressedImage, (Object)retImage);
        this.button.setEnabled(false);
        retImage = (Image)ReflectionUtils.invokeHidden((Object)this.button, (String)"getImageToDraw", (Object[])new Object[0]);
        ImageButtonTest.assertSame((Object)disabledImage, (Object)retImage);
        SwtUtilities.dispose((Resource)image);
        SwtUtilities.dispose((Resource)focusedImage);
        SwtUtilities.dispose((Resource)hoverFocusedImage);
        SwtUtilities.dispose((Resource)hoverImage);
        SwtUtilities.dispose((Resource)pressedImage);
        SwtUtilities.dispose((Resource)disabledImage);
    }

    public void testComputeSize() {
        Point size = this.button.computeSize(-1, -1, false);
        ImageButtonTest.assertEquals((Object)new Point(0, 0), (Object)size);
        Image image = ImageStore.getInstance().getImage("eclipse.gif");
        this.button.setImage(image);
        size = this.button.computeSize(-1, -1, false);
        ImageButtonTest.assertEquals((Object)new Point(16, 16), (Object)size);
        Image focusedImage = new Image((Device)this.shell.getDisplay(), 20, 21);
        this.button.setFocusedImage(focusedImage);
        size = this.button.computeSize(-1, -1, false);
        ImageButtonTest.assertEquals((Object)new Point(20, 21), (Object)size);
        size = this.button.computeSize(11, 12, false);
        ImageButtonTest.assertEquals((Object)new Point(11, 12), (Object)size);
        Image miniImage = new Image((Device)this.shell.getDisplay(), 1, 1);
        this.button.setImage(miniImage);
        this.button.setFocusedImage(miniImage);
        size = this.button.computeSize(-1, -1, false);
        ImageButtonTest.assertEquals((Object)new Point(1, 1), (Object)size);
        this.button.setUseIdealHeight(true);
        size = this.button.computeSize(-1, -1, false);
        ImageButtonTest.assertTrue((size.y > 1 ? 1 : 0) != 0);
        ImageButtonTest.assertEquals((int)1, (int)size.x);
        SwtUtilities.dispose((Resource)image);
        SwtUtilities.dispose((Resource)focusedImage);
        SwtUtilities.dispose((Resource)miniImage);
    }

    public void testComputeImagePos() {
        Event e = new Event();
        e.widget = this.button;
        PaintEvent event = new PaintEvent(e);
        event.width = 20;
        event.height = 40;
        Image image = new Image((Device)this.shell.getDisplay(), 10, 16);
        Point retPos = (Point)ReflectionUtils.invokeHidden((Object)this.button, (String)"computeImagePos", (Object[])new Object[]{event, image});
        ImageButtonTest.assertEquals((Object)new Point(5, 12), (Object)retPos);
        Image bigImage = new Image((Device)this.shell.getDisplay(), 50, 60);
        retPos = (Point)ReflectionUtils.invokeHidden((Object)this.button, (String)"computeImagePos", (Object[])new Object[]{event, bigImage});
        ImageButtonTest.assertEquals((Object)new Point(0, 0), (Object)retPos);
        SwtUtilities.dispose((Resource)image);
        SwtUtilities.dispose((Resource)bigImage);
    }

    public void testUpdateHoverButton() {
        this.shell.setVisible(true);
        this.button = new ImageButton((Composite)this.shell, 32);
        Button hoverButton = (Button)ReflectionUtils.getHidden((Object)this.button, (String)"hoverButton");
        ImageButtonTest.assertFalse((boolean)hoverButton.isVisible());
        ReflectionUtils.invokeHidden((Object)this.button, (String)"setPressed", (Object[])new Object[]{true});
        ReflectionUtils.invokeHidden((Object)this.button, (String)"updateHoverButton", (Object[])new Object[0]);
        ImageButtonTest.assertTrue((boolean)hoverButton.isVisible());
        ReflectionUtils.invokeHidden((Object)this.button, (String)"setPressed", (Object[])new Object[]{false});
        ReflectionUtils.invokeHidden((Object)this.button, (String)"updateHoverButton", (Object[])new Object[0]);
        ImageButtonTest.assertFalse((boolean)hoverButton.isVisible());
        ReflectionUtils.invokeHidden((Object)this.button, (String)"setHover", (Object[])new Object[]{true});
        ReflectionUtils.invokeHidden((Object)this.button, (String)"updateHoverButton", (Object[])new Object[0]);
        ImageButtonTest.assertTrue((boolean)hoverButton.isVisible());
        ReflectionUtils.invokeHidden((Object)this.button, (String)"setPressed", (Object[])new Object[]{true});
        ReflectionUtils.invokeHidden((Object)this.button, (String)"updateHoverButton", (Object[])new Object[0]);
        ImageButtonTest.assertTrue((boolean)hoverButton.isVisible());
        this.shell.setVisible(false);
    }
}

