/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.utils;

import com.kitfox.svg.SVGCache;
import com.kitfox.svg.SVGDiagram;
import java.net.URI;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.tests.Activator;
import org.eclipse.riena.ui.core.resource.IconSize;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.IImagePathExtension;
import org.eclipse.riena.ui.swt.utils.ImageFileExtension;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.osgi.framework.Bundle;

@UITestCase
public class ImageStoreTest
extends RienaTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        LnfManager.setLnf((RienaDefaultLnf)new RienaDefaultLnf());
        Point defaultDpi = SwtUtilities.getDefaultDpi();
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpi", (Object)defaultDpi);
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpiFactors", (Object)new float[]{0.0f, 0.0f});
    }

    public void testGetFullName() {
        ImageStore store = ImageStore.getInstance();
        String fullName = (String)ReflectionUtils.invokeHidden((Object)store, (String)"getFullName", (Object[])new Object[]{"abc", ImageFileExtension.JPG});
        ImageStoreTest.assertEquals((String)"abc.jpg", (String)fullName);
    }

    public void testGetImage() {
        ImageStore store = ImageStore.getInstance();
        store.update(new IImagePathExtension[0]);
        Image image = store.getImage("spirit");
        ImageStoreTest.assertNull((Object)image);
        IImagePathExtension extension = new IImagePathExtension(){

            public Bundle getContributingBundle() {
                return Activator.getDefault().getBundle();
            }

            public String getPath() {
                return "icons";
            }
        };
        store.update(new IImagePathExtension[]{extension});
        image = store.getImage("spirit");
        ImageStoreTest.assertNotNull((Object)image);
    }

    public void testGetImageIconSize() {
        ImageStore store = ImageStore.getInstance();
        Point dpi = SwtUtilities.getDpi();
        RienaDefaultLnf originalLnf = LnfManager.getLnf();
        try {
            LnfManager.setLnf((RienaDefaultLnf)new ScaleLnf());
            Image image = store.getImage("cloud.png", IconSize.A16);
            ImageStoreTest.assertEquals((int)32, (int)image.getBounds().width);
            image = store.getImage("cloud", IconSize.A16);
            ImageStoreTest.assertEquals((int)32, (int)image.getBounds().width);
            image = store.getImage("spirit", IconSize.A16);
            ImageStoreTest.assertEquals((int)16, (int)image.getBounds().width);
            image = store.getImage("testimagea", IconSize.A16);
            ImageStoreTest.assertEquals((int)16, (int)image.getBounds().width);
            ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpi", (Object)new Point(144, 144));
            image = store.getImage("testimagea", IconSize.A16);
            ImageStoreTest.assertEquals((int)24, (int)image.getBounds().width);
            ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpi", (Object)new Point(200, 200));
            image = store.getImage("testimagea", IconSize.A16);
            ImageStoreTest.assertEquals((int)16, (int)image.getBounds().width);
            ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpiFactors", (Object)new float[]{0.0f, 0.0f});
            Point defaultDpi = SwtUtilities.getDefaultDpi();
            ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpi", (Object)defaultDpi);
            image = store.getImage("cloud_p_", IconSize.A16);
            ImageStoreTest.assertEquals((int)16, (int)image.getBounds().width);
            image = store.getImage("cloud_p_", IconSize.B22);
            ImageStoreTest.assertEquals((int)22, (int)image.getBounds().width);
            image = store.getImage("cloud_d_", IconSize.B22);
            ImageStoreTest.assertNull((Object)image);
            image = store.getImage("cloud_p_a", IconSize.A16);
            ImageStoreTest.assertEquals((int)16, (int)image.getBounds().width);
            image = store.getImage("cloud_p_b", IconSize.B22);
            ImageStoreTest.assertEquals((int)22, (int)image.getBounds().width);
            image = store.getImage("cloud_p_c", IconSize.B22);
            ImageStoreTest.assertNull((Object)image);
        }
        finally {
            LnfManager.setLnf((RienaDefaultLnf)originalLnf);
            ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpi", (Object)dpi);
        }
    }

    public void testGetImageImageFileExtension() {
        ImageStore store = ImageStore.getInstance();
        IImagePathExtension extension = new IImagePathExtension(){

            public Bundle getContributingBundle() {
                return Activator.getDefault().getBundle();
            }

            public String getPath() {
                return "icons";
            }
        };
        store.update(new IImagePathExtension[]{extension});
        Image image = store.getImage("spirit", ImageFileExtension.PNG);
        ImageStoreTest.assertNotNull((Object)image);
        image = store.getImage("spirit", ImageFileExtension.GIF);
        ImageStoreTest.assertNull((Object)image);
        image = store.getImage("spirit", ImageFileExtension.JPG);
        ImageStoreTest.assertNull((Object)image);
        image = store.getImage("eclipse", ImageFileExtension.PNG);
        ImageStoreTest.assertNull((Object)image);
        image = store.getImage("eclipse", ImageFileExtension.GIF);
        ImageStoreTest.assertNotNull((Object)image);
        image = store.getImage("eclipse", ImageFileExtension.JPG);
        ImageStoreTest.assertNull((Object)image);
    }

    public void testAddImageScaleSuffix() throws Exception {
        ImageStore store = ImageStore.getInstance();
        IImagePathExtension extension = new IImagePathExtension(){

            public Bundle getContributingBundle() {
                return Activator.getDefault().getBundle();
            }

            public String getPath() {
                return "icons";
            }
        };
        store.update(new IImagePathExtension[]{extension});
        RienaDefaultLnf originalLnf = LnfManager.getLnf();
        try {
            LnfManager.setLnf((RienaDefaultLnf)new MyLnf());
            String name = store.addImageScaleSuffix("imagebutton", ImageFileExtension.PNG);
            ImageStoreTest.assertEquals((String)"imagebutton_p_", (String)name);
            name = store.addImageScaleSuffix("dontexits", ImageFileExtension.PNG);
            ImageStoreTest.assertEquals((String)"dontexits", (String)name);
        }
        finally {
            LnfManager.setLnf((RienaDefaultLnf)originalLnf);
        }
    }

    public void testGetFullScaledName() throws Exception {
        ImageStore store = ImageStore.getInstance();
        IImagePathExtension extension = new IImagePathExtension(){

            public Bundle getContributingBundle() {
                return Activator.getDefault().getBundle();
            }

            public String getPath() {
                return "icons";
            }
        };
        store.update(new IImagePathExtension[]{extension});
        RienaDefaultLnf originalLnf = LnfManager.getLnf();
        try {
            LnfManager.setLnf((RienaDefaultLnf)new MyLnf());
            Point dpi = SwtUtilities.getDpi();
            String name = (String)ReflectionUtils.invokeHidden((Object)store, (String)"getFullScaledName", (Object[])new Object[]{"abc.jpg", ImageFileExtension.JPG, dpi});
            ImageStoreTest.assertNull((Object)name);
            name = (String)ReflectionUtils.invokeHidden((Object)store, (String)"getFullScaledName", (Object[])new Object[]{"", ImageFileExtension.PNG, dpi});
            ImageStoreTest.assertNull((Object)name);
            name = (String)ReflectionUtils.invokeHidden((Object)store, (String)"getFullScaledName", (Object[])new Object[]{"imagebutton", null, dpi});
            ImageStoreTest.assertNull((Object)name);
            name = (String)ReflectionUtils.invokeHidden((Object)store, (String)"getFullScaledName", (Object[])new Object[]{"imagebutton", ImageFileExtension.PNG, dpi});
            ImageStoreTest.assertEquals((String)"imagebutton_p_.png", (String)name);
            name = (String)ReflectionUtils.invokeHidden((Object)store, (String)"getFullScaledName", (Object[])new Object[]{"dontexits", ImageFileExtension.PNG, dpi});
            ImageStoreTest.assertEquals((String)"dontexits.png", (String)name);
            name = (String)ReflectionUtils.invokeHidden((Object)store, (String)"getFullScaledName", (Object[])new Object[]{"imagebutton", ImageFileExtension.JPG, dpi});
            ImageStoreTest.assertEquals((String)"imagebutton.jpg", (String)name);
            name = (String)ReflectionUtils.invokeHidden((Object)store, (String)"getFullScaledName", (Object[])new Object[]{"dontexits", ImageFileExtension.JPG, dpi});
            ImageStoreTest.assertEquals((String)"dontexits.jpg", (String)name);
        }
        finally {
            LnfManager.setLnf((RienaDefaultLnf)originalLnf);
        }
    }

    public void testGetFullSvgName() throws Exception {
        ImageStore store = ImageStore.getInstance();
        String name = null;
        IconSize size = null;
        String fullName = (String)ReflectionUtils.invokeHidden((Object)store, (String)"getFullSvgName", (Object[])new Object[]{name, size});
        ImageStoreTest.assertNull((Object)fullName);
        name = "";
        fullName = (String)ReflectionUtils.invokeHidden((Object)store, (String)"getFullSvgName", (Object[])new Object[]{name, size});
        ImageStoreTest.assertNull((Object)fullName);
        name = "hello.png";
        fullName = (String)ReflectionUtils.invokeHidden((Object)store, (String)"getFullSvgName", (Object[])new Object[]{name, size});
        ImageStoreTest.assertNull((Object)fullName);
        name = "hello.svg";
        fullName = (String)ReflectionUtils.invokeHidden((Object)store, (String)"getFullSvgName", (Object[])new Object[]{name, size});
        ImageStoreTest.assertEquals((String)name, (String)fullName);
        name = "hello";
        fullName = (String)ReflectionUtils.invokeHidden((Object)store, (String)"getFullSvgName", (Object[])new Object[]{name, size});
        ImageStoreTest.assertEquals((String)"hello.svg", (String)fullName);
        name = "hello";
        size = IconSize.NONE;
        fullName = (String)ReflectionUtils.invokeHidden((Object)store, (String)"getFullSvgName", (Object[])new Object[]{name, size});
        ImageStoreTest.assertEquals((String)"hello.svg", (String)fullName);
        name = "hello";
        size = IconSize.A16;
        fullName = (String)ReflectionUtils.invokeHidden((Object)store, (String)"getFullSvgName", (Object[])new Object[]{name, size});
        ImageStoreTest.assertEquals((String)"hello.svg", (String)fullName);
        name = "icona";
        fullName = (String)ReflectionUtils.invokeHidden((Object)store, (String)"getFullSvgName", (Object[])new Object[]{name, size});
        ImageStoreTest.assertEquals((String)"icon.svg", (String)fullName);
        name = "icona";
        size = IconSize.B22;
        fullName = (String)ReflectionUtils.invokeHidden((Object)store, (String)"getFullSvgName", (Object[])new Object[]{name, size});
        ImageStoreTest.assertEquals((String)"icona.svg", (String)fullName);
        name = "iconaa";
        size = IconSize.A16;
        fullName = (String)ReflectionUtils.invokeHidden((Object)store, (String)"getFullSvgName", (Object[])new Object[]{name, size});
        ImageStoreTest.assertEquals((String)"icona.svg", (String)fullName);
        name = "imageb";
        size = IconSize.B22;
        fullName = (String)ReflectionUtils.invokeHidden((Object)store, (String)"getFullSvgName", (Object[])new Object[]{name, size});
        ImageStoreTest.assertEquals((String)"image.svg", (String)fullName);
    }

    public void testCreateSvgImage() throws Exception {
        RGB rgb;
        int pixelValue;
        ImageStore store = ImageStore.getInstance();
        String name = null;
        IconSize size = null;
        Image image = (Image)ReflectionUtils.invokeHidden((Object)store, (String)"createSvgImage", (Object[])new Object[]{name, size});
        ImageStoreTest.assertNull((Object)image);
        name = "blaBla";
        size = IconSize.A16;
        image = (Image)ReflectionUtils.invokeHidden((Object)store, (String)"createSvgImage", (Object[])new Object[]{name, size});
        ImageStoreTest.assertNull((Object)image);
        name = "cloud";
        size = IconSize.A16;
        name = (String)ReflectionUtils.invokeHidden((Object)store, (String)"getFullSvgName", (Object[])new Object[]{name, size});
        image = (Image)ReflectionUtils.invokeHidden((Object)store, (String)"createSvgImage", (Object[])new Object[]{name, size});
        ImageStoreTest.assertNotNull((Object)image);
        int w = SwtUtilities.convertXToDpi((int)size.getWidth());
        int h = SwtUtilities.convertYToDpi((int)size.getHeight());
        ImageStoreTest.assertEquals((int)w, (int)image.getImageData().width);
        ImageStoreTest.assertEquals((int)h, (int)image.getImageData().height);
        if (!SwtUtilities.isDpiScalingEnabled()) {
            pixelValue = image.getImageData().getPixel(0, 6);
            rgb = image.getImageData().palette.getRGB(pixelValue);
            ImageStoreTest.assertEquals((Object)new RGB(30, 30, 27), (Object)rgb);
        }
        name = "cloud";
        size = IconSize.C32;
        name = (String)ReflectionUtils.invokeHidden((Object)store, (String)"getFullSvgName", (Object[])new Object[]{name, size});
        image = (Image)ReflectionUtils.invokeHidden((Object)store, (String)"createSvgImage", (Object[])new Object[]{name, size});
        ImageStoreTest.assertNotNull((Object)image);
        w = SwtUtilities.convertXToDpi((int)size.getWidth());
        h = SwtUtilities.convertYToDpi((int)size.getHeight());
        ImageStoreTest.assertEquals((int)w, (int)image.getImageData().width);
        ImageStoreTest.assertEquals((int)h, (int)image.getImageData().height);
        if (!SwtUtilities.isDpiScalingEnabled()) {
            pixelValue = image.getImageData().getPixel(0, 15);
            rgb = image.getImageData().palette.getRGB(pixelValue);
            ImageStoreTest.assertEquals((Object)new RGB(29, 29, 26), (Object)rgb);
        }
    }

    public void testGetImageBounds() throws Exception {
        ImageStore store = ImageStore.getInstance();
        SVGDiagram svgDiagram = null;
        IconSize size = null;
        Rectangle bounds = (Rectangle)ReflectionUtils.invokeHidden((Object)store, (String)"getImageBounds", (Object[])new Object[]{svgDiagram, size});
        ImageStoreTest.assertEquals((Object)new Rectangle(0, 0, 0, 0), (Object)bounds);
        size = IconSize.NONE;
        bounds = (Rectangle)ReflectionUtils.invokeHidden((Object)store, (String)"getImageBounds", (Object[])new Object[]{svgDiagram, size});
        ImageStoreTest.assertEquals((Object)new Rectangle(0, 0, 0, 0), (Object)bounds);
        size = IconSize.A16;
        bounds = (Rectangle)ReflectionUtils.invokeHidden((Object)store, (String)"getImageBounds", (Object[])new Object[]{svgDiagram, size});
        int wh = SwtUtilities.convertPixelToDpi((int)16);
        ImageStoreTest.assertEquals((Object)new Rectangle(0, 0, wh, wh), (Object)bounds);
        size = IconSize.F128;
        bounds = (Rectangle)ReflectionUtils.invokeHidden((Object)store, (String)"getImageBounds", (Object[])new Object[]{svgDiagram, size});
        wh = SwtUtilities.convertPixelToDpi((int)128);
        ImageStoreTest.assertEquals((Object)new Rectangle(0, 0, wh, wh), (Object)bounds);
        URI imageUri = store.getImageUri("cloud", ImageFileExtension.SVG);
        svgDiagram = SVGCache.getSVGUniverse().getDiagram(imageUri);
        size = IconSize.NONE;
        bounds = (Rectangle)ReflectionUtils.invokeHidden((Object)store, (String)"getImageBounds", (Object[])new Object[]{svgDiagram, size});
        wh = SwtUtilities.convertPixelToDpi((int)512);
        ImageStoreTest.assertEquals((Object)new Rectangle(0, 0, wh, wh), (Object)bounds);
        size = IconSize.D48;
        bounds = (Rectangle)ReflectionUtils.invokeHidden((Object)store, (String)"getImageBounds", (Object[])new Object[]{svgDiagram, size});
        wh = SwtUtilities.convertPixelToDpi((int)48);
        ImageStoreTest.assertEquals((Object)new Rectangle(0, 0, wh, wh), (Object)bounds);
        SVGCache.getSVGUniverse().clear();
    }

    public void testGetImageUri() throws Exception {
        ImageStore store = ImageStore.getInstance();
        Point dpi = SwtUtilities.getDpi();
        RienaDefaultLnf originalLnf = LnfManager.getLnf();
        try {
            LnfManager.setLnf((RienaDefaultLnf)new ScaleLnf());
            URI imageUri = store.getImageUri("abc", ImageFileExtension.PNG);
            ImageStoreTest.assertNull((Object)imageUri);
            imageUri = store.getImageUri("closed_16", ImageFileExtension.GIF);
            ImageStoreTest.assertNotNull((Object)imageUri);
            ImageStoreTest.assertEquals((String)"/icons/closed_16.gif", (String)imageUri.getPath());
            imageUri = store.getImageUri("closed_16.gif", ImageFileExtension.PNG);
            ImageStoreTest.assertNotNull((Object)imageUri);
            ImageStoreTest.assertEquals((String)"/icons/closed_16.gif", (String)imageUri.getPath());
            imageUri = store.getImageUri("closed_16.gif", null);
            ImageStoreTest.assertNotNull((Object)imageUri);
            ImageStoreTest.assertEquals((String)"/icons/closed_16.gif", (String)imageUri.getPath());
            imageUri = store.getImageUri("closed_16", ImageFileExtension.JPG);
            ImageStoreTest.assertNull((Object)imageUri);
            imageUri = store.getImageUri("spirit", ImageFileExtension.PNG);
            ImageStoreTest.assertNotNull((Object)imageUri);
            ImageStoreTest.assertEquals((String)"/icons/spirit.png", (String)imageUri.getPath());
            imageUri = store.getImageUri("spirit.png", ImageFileExtension.JPG);
            ImageStoreTest.assertNotNull((Object)imageUri);
            ImageStoreTest.assertEquals((String)"/icons/spirit.png", (String)imageUri.getPath());
            imageUri = store.getImageUri("spirit.png", null);
            ImageStoreTest.assertNotNull((Object)imageUri);
            ImageStoreTest.assertEquals((String)"/icons/spirit.png", (String)imageUri.getPath());
            imageUri = store.getImageUri("spirit", ImageFileExtension.GIF);
            ImageStoreTest.assertNull((Object)imageUri);
            ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpi", (Object)new Point(144, 144));
            ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpi", (Object)new Point(96, 96));
            imageUri = store.getImageUri("testimagea", ImageFileExtension.PNG);
            ImageStoreTest.assertEquals((String)"/icons/testimagea00.png", (String)imageUri.getPath());
            ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpi", (Object)new Point(144, 144));
            imageUri = store.getImageUri("testimagea", ImageFileExtension.PNG);
            ImageStoreTest.assertEquals((String)"/icons/testimagea03.png", (String)imageUri.getPath());
            ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpi", (Object)new Point(200, 200));
            imageUri = store.getImageUri("testimagea", ImageFileExtension.PNG);
            ImageStoreTest.assertEquals((String)"/icons/testimagea00.png", (String)imageUri.getPath());
            ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpi", (Object)new Point(96, 96));
            imageUri = store.getImageUri("testimagea", ImageFileExtension.GIF);
            ImageStoreTest.assertNull((Object)imageUri);
            ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpi", (Object)new Point(96, 96));
            imageUri = store.getImageUri("testimagea03.png", null);
            ImageStoreTest.assertEquals((String)"/icons/testimagea03.png", (String)imageUri.getPath());
        }
        finally {
            LnfManager.setLnf((RienaDefaultLnf)originalLnf);
            ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpi", (Object)dpi);
        }
    }

    private static class MyLnf
    extends RienaDefaultLnf {
        private MyLnf() {
        }

        public String getIconScaleSuffix(Point dpi) {
            if (dpi == null) {
                return "_h_";
            }
            if (dpi.x < 96) {
                return "_h_";
            }
            return "_p_";
        }
    }

    private static class ScaleLnf
    extends RienaDefaultLnf {
        private ScaleLnf() {
        }

        public String getIconScaleSuffix(Point dpi) {
            switch (dpi.x) {
                case 96: {
                    return "00";
                }
                case 120: {
                    return "01";
                }
                case 128: {
                    return "02";
                }
                case 144: {
                    return "03";
                }
            }
            return null;
        }
    }
}

