/*******************************************************************************
 * Copyright (c) 2007, 2014 compeople AG and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    compeople AG - initial API and implementation
 *******************************************************************************/
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Composite;

/**
 * Abstract implementation of the wrapper of a table or tree.
 */
public abstract class AbstractTableTreeWrapper implements ITableTreeWrapper {

	private final Composite control;

	/**
	 * Creates a new wrapper for the given control.
	 * 
	 * @param control
	 *            control that will be wrapped
	 */
	public AbstractTableTreeWrapper(final Composite control) {
		Assert.isNotNull(control);
		this.control = control;
	}

	public Composite getControl() {
		return control;
	}

}
