/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internalui.swt.rap;

import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.ContextUtil;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceContext;
import org.eclipse.rap.rwt.service.ServerPushSession;
import org.eclipse.rap.rwt.service.UISession;
import org.eclipse.rap.ui.internal.progress.JobManagerAdapter;
import org.eclipse.riena.ui.swt.AbstractRienaUIPlugin;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractRienaUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.riena.ui.swt.rap";
    private static Activator plugin;
    private UICallbackActivationListener uiCallbackListener;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.removeRAPJobChangeListener();
        this.registerJobChangeListener();
    }

    private void removeRAPJobChangeListener() {
        Job.getJobManager().removeJobChangeListener((IJobChangeListener)JobManagerAdapter.getInstance());
    }

    private void registerJobChangeListener() {
        this.uiCallbackListener = new UICallbackActivationListener();
        Job.getJobManager().addJobChangeListener((IJobChangeListener)this.uiCallbackListener);
    }

    public void stop(BundleContext context) throws Exception {
        this.deregisterJobChangeListener();
        plugin = null;
        super.stop(context);
    }

    private void deregisterJobChangeListener() {
        Job.getJobManager().removeJobChangeListener((IJobChangeListener)this.uiCallbackListener);
        this.uiCallbackListener = null;
    }

    public static Activator getDefault() {
        return plugin;
    }

    private static final class UICallbackActivationListener
    extends JobChangeAdapter {
        private static final String SERVICE_CONTEXT = "serviceContext";
        private static final String RAP = "context";
        private static final String THREAD = "currentThread";
        private static final String PUSH_SESSION = "serverPushSession";

        private UICallbackActivationListener() {
        }

        public void aboutToRun(IJobChangeEvent event) {
            Thread scheduler;
            ServiceContext context = (ServiceContext)event.getJob().getProperty(new QualifiedName(RAP, SERVICE_CONTEXT));
            if (context != null && (scheduler = (Thread)event.getJob().getProperty(new QualifiedName(RAP, THREAD))) != null && scheduler != Thread.currentThread()) {
                ContextProvider.setContext((ServiceContext)context);
            }
            event.getJob().setProperty(new QualifiedName(RAP, SERVICE_CONTEXT), null);
            event.getJob().setProperty(new QualifiedName(RAP, THREAD), null);
            LifeCycleUtil.getSessionDisplay();
        }

        public void scheduled(final IJobChangeEvent event) {
            Display display = UICallbackActivationListener.findDisplay(event.getJob());
            if (display != null && !display.isDisposed()) {
                ServiceContext context = ContextProvider.getContext();
                if (context != null) {
                    Display sessionDisplay = LifeCycleUtil.getSessionDisplay();
                    IDisplayAdapter adapter = (IDisplayAdapter)sessionDisplay.getAdapter(IDisplayAdapter.class);
                    UISession uiSession = adapter.getUISession();
                    ServiceContext fakeContext = ContextUtil.createFakeContext((UISession)uiSession);
                    event.getJob().setProperty(new QualifiedName(RAP, SERVICE_CONTEXT), (Object)fakeContext);
                    event.getJob().setProperty(new QualifiedName(RAP, THREAD), (Object)Thread.currentThread());
                }
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ServerPushSession serverPushSession = new ServerPushSession();
                        event.getJob().setProperty(new QualifiedName(UICallbackActivationListener.RAP, UICallbackActivationListener.PUSH_SESSION), (Object)serverPushSession);
                        serverPushSession.start();
                    }
                });
            }
        }

        public void done(IJobChangeEvent event) {
            Display display = LifeCycleUtil.getSessionDisplay();
            if (display != null && !display.isDisposed()) {
                try {
                    Object property = event.getJob().getProperty(new QualifiedName(RAP, PUSH_SESSION));
                    if (property instanceof ServerPushSession) {
                        ((ServerPushSession)property).stop();
                    }
                }
                finally {
                    ContextProvider.releaseContextHolder();
                }
            }
        }

        private static Display findDisplay(Job job) {
            UIJob uiJob;
            Display result = null;
            if (ContextProvider.hasContext()) {
                result = LifeCycleUtil.getSessionDisplay();
            } else if (job instanceof UIJob && (result = (uiJob = (UIJob)job).getDisplay()) == null) {
                String msg = "UIJob " + uiJob.getName() + " cannot be scheduled without an associated display.";
                throw new IllegalStateException(msg);
            }
            return result;
        }
    }
}

