/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.e4.launcher.rendering;

import org.eclipse.riena.navigation.ApplicationNodeManager;
import org.eclipse.riena.navigation.ui.controllers.ApplicationController;
import org.eclipse.riena.navigation.ui.swt.binding.InjectSwtViewBindingDelegate;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ShellRenderer;
import org.eclipse.riena.navigation.ui.swt.views.ShellPaintListener;
import org.eclipse.riena.ui.ridgets.controller.IController;
import org.eclipse.riena.ui.swt.InfoFlyout;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.riena.ui.swt.utils.ShellHelper;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.riena.ui.swt.utils.WidgetIdentificationSupport;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ApplicationView {
    private static final String SHELL_BINDING_ID = "applicationWindow";
    private static final String INFO_FLYOUT_BINDING_ID = "infoFlyout";
    private static final String PROPERTY_RIENA_APPLICATION_MINIMUM_WIDTH = "riena.application.minimum.width";
    private static final String PROPERTY_RIENA_APPLICATION_MINIMUM_HEIGHT = "riena.application.minimum.height";
    private static final String PROPERTY_RIENA_APPLICATION_WIDTH = "riena.application.width";
    private static final String PROPERTY_RIENA_APPLICATION_HEIGHT = "riena.application.height";
    private final InjectSwtViewBindingDelegate binding = new InjectSwtViewBindingDelegate();
    private Point applicationSizeMinimum;

    Rectangle initShell(Shell shell) {
        shell.setBackground(LnfManager.getLnf().getColor("TitlelessShell.background"));
        shell.addPaintListener((PaintListener)new ShellPaintListener());
        String iconName = ApplicationNodeManager.getApplicationNode().getIcon();
        shell.setImage(ImageStore.getInstance().getImage(iconName));
        Point minimum = this.getApplicationSizeMinimum();
        minimum = SwtUtilities.convertPointToDpi((Point)minimum);
        shell.setMinimumSize(minimum);
        this.addUIControl(shell, SHELL_BINDING_ID);
        if (this.getShellRenderer() != null) {
            this.getShellRenderer().setShell(shell);
        }
        WidgetIdentificationSupport.setIdentification((Shell)shell);
        return this.computeDesiredShellBounds(shell);
    }

    private Rectangle computeDesiredShellBounds(Shell shell) {
        Point windowSize = this.initApplicationSize();
        windowSize = SwtUtilities.convertPointToDpi((Point)windowSize);
        int width = windowSize.x;
        int height = windowSize.y;
        Rectangle maxBounds = ShellHelper.calcMaxBounds((Shell)shell);
        if (width > maxBounds.width) {
            width = maxBounds.width;
        }
        if (height > maxBounds.height) {
            height = maxBounds.height;
        }
        int x = (maxBounds.width - width) / 2;
        int y = (maxBounds.height - height) / 2;
        return new Rectangle(x, y, width, height);
    }

    private Point initApplicationSize() {
        int height;
        int width = Integer.getInteger(PROPERTY_RIENA_APPLICATION_WIDTH, this.getApplicationSizeMinimum().x);
        if (width < this.getApplicationSizeMinimum().x) {
            width = this.getApplicationSizeMinimum().x;
        }
        if ((height = Integer.getInteger(PROPERTY_RIENA_APPLICATION_HEIGHT, this.getApplicationSizeMinimum().y).intValue()) < this.getApplicationSizeMinimum().y) {
            height = this.getApplicationSizeMinimum().y;
        }
        return new Point(width, height);
    }

    void doInitialBinding() {
        ApplicationController controller = (ApplicationController)ApplicationNodeManager.getApplicationNode().getNavigationNodeController();
        this.binding.injectAndBind((IController)controller);
        controller.afterBind();
    }

    private Point getApplicationSizeMinimum() {
        if (this.applicationSizeMinimum == null) {
            this.initApplicationSizeMinimum();
        }
        return this.applicationSizeMinimum;
    }

    private void initApplicationSizeMinimum() {
        int widthMinimum = Integer.getInteger(PROPERTY_RIENA_APPLICATION_MINIMUM_WIDTH, this.getApplicationDefaultSizeMinimum().x);
        int heightMinimum = Integer.getInteger(PROPERTY_RIENA_APPLICATION_MINIMUM_HEIGHT, this.getApplicationDefaultSizeMinimum().y);
        this.applicationSizeMinimum = new Point(widthMinimum, heightMinimum);
    }

    private Point getApplicationDefaultSizeMinimum() {
        return (Point)LnfManager.getLnf().getSetting("riena.application.size.minimum");
    }

    private ShellRenderer getShellRenderer() {
        ShellRenderer shellRenderer = (ShellRenderer)LnfManager.getLnf().getRenderer("TitlelessShell.renderer");
        return shellRenderer;
    }

    public void addUIControl(Object uiElement, String propertyName) {
        this.binding.addUIControl(uiElement, propertyName);
    }

    public InfoFlyout createInfoFlyout(Composite parent) {
        InfoFlyout infoFlyout = UIControlsFactory.createInfoFlyout((Composite)parent);
        this.addUIControl(infoFlyout, INFO_FLYOUT_BINDING_ID);
        return infoFlyout;
    }
}

