/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import org.eclipse.riena.navigation.INavigationContext;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IMessageBoxRidget;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;

public class AllowsDisposeSubModuleController
extends SubModuleController {
    private boolean allowsDispose;
    private IMessageBoxRidget messageBoxRidget;
    private static final IMessageBoxRidget.MessageBoxOption NAVIGATE_TO_CONTROLLER = new IMessageBoxRidget.MessageBoxOption("Navigate");
    private static final IMessageBoxRidget.MessageBoxOption CLOSE_NEVERTHELESS = new IMessageBoxRidget.MessageBoxOption("Close");

    public void configureRidgets() {
        final IToggleButtonRidget checkBoxRidget = (IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "allowsDispose");
        checkBoxRidget.addListener(new IActionListener(){

            public void callback() {
                if (checkBoxRidget.isSelected()) {
                    AllowsDisposeSubModuleController.this.allowsDispose = true;
                } else {
                    AllowsDisposeSubModuleController.this.allowsDispose = false;
                }
            }
        });
        checkBoxRidget.setSelected(true);
        this.messageBoxRidget = (IMessageBoxRidget)this.getRidget(IMessageBoxRidget.class, "messageBox");
        this.messageBoxRidget.setText("The Controller \"" + ((ISubModuleNode)this.getNavigationNode()).getLabel() + "\" does not allow disposing.\n Do you want to close the application nevertheless or navigate to the controller?");
        IMessageBoxRidget.MessageBoxOption[] options = new IMessageBoxRidget.MessageBoxOption[]{CLOSE_NEVERTHELESS, NAVIGATE_TO_CONTROLLER};
        this.messageBoxRidget.setOptions(options);
    }

    public boolean allowsDispose(INavigationNode<?> node, INavigationContext context) {
        if (!this.allowsDispose) {
            IMessageBoxRidget.MessageBoxOption selectedOption = this.messageBoxRidget.show();
            if (selectedOption.equals(NAVIGATE_TO_CONTROLLER)) {
                ((ISubModuleNode)this.getNavigationNode()).navigate(new NavigationNodeId("org.eclipse.riena.example.client.subModule.allowsDispose"));
            } else if (selectedOption.equals(CLOSE_NEVERTHELESS)) {
                return true;
            }
        }
        return this.allowsDispose && super.allowsDispose(node, context);
    }
}

