/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.riena.core.service.Service;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.filter.IUIFilter;
import org.eclipse.riena.ui.filter.IUIFilterContainer;
import org.eclipse.riena.ui.filter.IUIFilterProvider;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;

public class FilterExternalDefinitionSubModuleController
extends SubModuleController {
    public void afterBind() {
        super.afterBind();
        this.initRidgets();
    }

    private void initRidgets() {
        IActionRidget removeFilters = (IActionRidget)this.getRidget("removeOffline");
        removeFilters.addListener(new IActionListener(){

            public void callback() {
                FilterExternalDefinitionSubModuleController.this.doRemoveFilters();
            }
        });
        IActionRidget addFilters = (IActionRidget)this.getRidget("addOffline");
        addFilters.addListener(new IActionListener(){

            public void callback() {
                FilterExternalDefinitionSubModuleController.this.doAddFilters();
            }
        });
    }

    private void doAddFilters() {
        IUIFilterContainer container = ((IUIFilterProvider)Service.get(IUIFilterProvider.class)).provideFilter("rienaExample.offline");
        IUIFilter filter = container.getFilter();
        Collection targetNodeIds = container.getFilterTargetNodeIds();
        List<INavigationNode<?>> nodes = this.findNodes(targetNodeIds);
        if (nodes != null && !nodes.isEmpty()) {
            for (INavigationNode<?> navigationNode : nodes) {
                navigationNode.addFilter(filter);
            }
        }
    }

    private void doRemoveFilters() {
        IUIFilterContainer container = ((IUIFilterProvider)Service.get(IUIFilterProvider.class)).provideFilter("rienaExample.offline");
        IUIFilter filter = container.getFilter();
        Collection targetNodeIds = container.getFilterTargetNodeIds();
        List<INavigationNode<?>> nodes = this.findNodes(targetNodeIds);
        for (INavigationNode<?> navigationNode : nodes) {
            navigationNode.removeFilter(filter.getFilterID());
        }
    }

    private List<INavigationNode<?>> findNodes(String id) {
        ArrayList nodes = new ArrayList();
        IApplicationNode applNode = (IApplicationNode)((ISubModuleNode)this.getNavigationNode()).getParentOfType(IApplicationNode.class);
        this.findNodes(id, (INavigationNode<?>)applNode, nodes);
        return nodes;
    }

    private void findNodes(String id, INavigationNode<?> node, List<INavigationNode<?>> nodes) {
        if (node.getNodeId() != null && StringUtils.equals((CharSequence)node.getNodeId().getTypeId(), (CharSequence)id)) {
            nodes.add(node);
        }
        List children = node.getChildren();
        for (Object child : children) {
            if (!(child instanceof INavigationNode)) continue;
            this.findNodes(id, (INavigationNode)child, nodes);
        }
    }

    private List<INavigationNode<?>> findNodes(Collection<String> ids) {
        ArrayList nodes = new ArrayList();
        for (String id : ids) {
            nodes.addAll(this.findNodes(id));
        }
        return nodes;
    }
}

