/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.riena.core.exception.MurphysLawFailure;
import org.eclipse.riena.core.util.IOUtils;
import org.eclipse.riena.example.client.views.SharedBrowserView;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISimpleNavigationNodeListener;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.SimpleNavigationNodeAdapter;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IBrowserRidget;
import org.eclipse.riena.ui.workarea.WorkareaManager;

public class SharedBrowserController
extends SubModuleController {
    private static final String TAB_ID = "webapp.target";
    private static final String SHARED_BROWSERS_MODEL = "sharedBrowsers.model";
    private static int personCounter;
    private IBrowserRidget browser;

    public SharedBrowserController() {
    }

    public SharedBrowserController(ISubModuleNode navigationNode) {
        super(navigationNode);
    }

    public void configureRidgets() {
        super.configureRidgets();
        this.browser = (IBrowserRidget)this.getRidget(IBrowserRidget.class, "browser");
        Model model = (Model)((IModuleGroupNode)((ISubModuleNode)this.getNavigationNode()).getParentOfType(IModuleGroupNode.class)).getContext(SHARED_BROWSERS_MODEL);
        if (model == null) {
            this.browser.setUrl(this.getHtmlPageURL("sharedbrowser_title.html"));
            this.browser.mapScriptFunction("jsCreateModuleGroup", new IBrowserRidget.IBrowserRidgetFunction(){

                public Object execute(Object[] jsParams) {
                    return SharedBrowserController.this.jsCreateModuleGroup(jsParams);
                }
            });
        } else {
            this.browser.bindToModel((Object)model, "browserURL");
            this.browser.updateFromModel();
            this.browser.mapScriptFunction("initSubModules", new IBrowserRidget.IBrowserRidgetFunction(){

                public Object execute(Object[] jsParams) {
                    return SharedBrowserController.this.initSubModules(jsParams);
                }
            });
            this.browser.mapScriptFunction("itemSelected", new IBrowserRidget.IBrowserRidgetFunction(){

                public Object execute(Object[] jsParams) {
                    return SharedBrowserController.this.itemSelected(jsParams);
                }
            });
        }
        ((ISubModuleNode)this.getNavigationNode()).addSimpleListener((ISimpleNavigationNodeListener)new SimpleNavigationNodeAdapter(){

            public void afterActivated(INavigationNode<?> source) {
                super.afterActivated(source);
                if (((IModuleGroupNode)((ISubModuleNode)SharedBrowserController.this.getNavigationNode()).getParentOfType(IModuleGroupNode.class)).getContext(SharedBrowserController.SHARED_BROWSERS_MODEL) != null) {
                    SharedBrowserController.this.browser.execute("showContent('" + ((ISubModuleNode)SharedBrowserController.this.getNavigationNode()).getContext(SharedBrowserController.TAB_ID) + "');");
                }
            }
        });
    }

    private Object itemSelected(Object[] args) {
        String selectedTabId = (String)args[0];
        if (selectedTabId == null) {
            return null;
        }
        for (Object child : ((ISubModuleNode)this.getNavigationNode()).getParent().getChildren()) {
            if (!(child instanceof ISubModuleNode) || !selectedTabId.equals(((ISubModuleNode)child).getContext(TAB_ID))) continue;
            ((ISubModuleNode)child).activate();
            break;
        }
        return null;
    }

    public Object initSubModules(Object[] args) {
        if (args.length != 2 || !(args[0] instanceof Object[]) || !(args[1] instanceof Object[])) {
            throw new IllegalArgumentException("Invalid JavaScript arguments.");
        }
        Object[] ids = (Object[])args[0];
        Object[] labels = (Object[])args[1];
        ((ISubModuleNode)this.getNavigationNode()).setLabel((String)labels[0]);
        ((ISubModuleNode)this.getNavigationNode()).setContext(TAB_ID, ids[0]);
        int i = 1;
        while (i < ids.length) {
            this.createSubModuleNode((IModuleNode)((ISubModuleNode)this.getNavigationNode()).getParentOfType(IModuleNode.class), (String)labels[i], (String)ids[i]);
            ++i;
        }
        return null;
    }

    public Object jsCreateModuleGroup(Object[] args) {
        String name = (String)args[0];
        ModuleGroupNode group = new ModuleGroupNode();
        group.setContext("shared.views.context", (Object)name);
        ModuleNode module = new ModuleNode("Shared Brower (" + name + ")");
        group.addChild((INavigationNode)module);
        Model model = new Model();
        model.setBrowserURL(this.getHtmlPageURL("sample-page.html"));
        group.setContext(SHARED_BROWSERS_MODEL, (Object)model);
        ((ISubApplicationNode)((ISubModuleNode)this.getNavigationNode()).getParentOfType(ISubApplicationNode.class)).addChild((INavigationNode)group);
        this.createSubModuleNode((IModuleNode)module, "Webapp", null);
        group.activate();
        return null;
    }

    private void createSubModuleNode(IModuleNode parent, String label, String tabId) {
        SubModuleNode node = new SubModuleNode(new NavigationNodeId("onePerson", Integer.toString(personCounter++)), label);
        node.setContext(TAB_ID, (Object)tabId);
        parent.addChild((INavigationNode)node);
        WorkareaManager.getInstance().registerDefinition((INavigationNode)node, ((Object)((Object)this)).getClass(), (Object)SharedBrowserView.class.getName(), true).setRequiredPreparation(true);
    }

    private String getHtmlPageURL(String name) {
        String string;
        InputStream is = null;
        FileOutputStream os = null;
        try {
            is = ((Object)((Object)this)).getClass().getResourceAsStream(name);
            File tempFile = File.createTempFile(name, ".html");
            os = new FileOutputStream(tempFile);
            IOUtils.copy((InputStream)is, (OutputStream)os);
            String result = tempFile.toURI().toURL().toString();
            if (result.startsWith("file:/") && !result.startsWith("file:///")) {
                result = "file:///" + result.substring("file:/".length());
            }
            string = result;
        }
        catch (IOException e) {
            try {
                throw new MurphysLawFailure("", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.close(is);
                IOUtils.close(os);
                throw throwable;
            }
        }
        IOUtils.close((Closeable)is);
        IOUtils.close((Closeable)os);
        return string;
    }

    protected static void go(String address, IBrowserRidget browser) {
        if (address == null) {
            browser.setUrl("about:blank");
            return;
        }
        if (address.startsWith("http://")) {
            browser.setUrl(address);
        } else {
            browser.setUrl("http://" + address);
        }
    }

    static class Model {
        private String browserURL;

        Model() {
        }

        public String getBrowserURL() {
            return this.browserURL;
        }

        public void setBrowserURL(String browserURL) {
            this.browserURL = browserURL;
        }
    }
}

