/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.lnf.renderer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.EmbeddedBorderRenderer;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ModuleGroupBorderRenderer;
import org.eclipse.riena.navigation.ui.swt.views.ModuleView;
import org.eclipse.riena.ui.swt.lnf.AbstractLnfRenderer;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public class ModuleGroupRenderer
extends AbstractLnfRenderer {
    private static final int MODULE_MODULE_GAP = 2;
    private static final int MODULE_GROUP_PADDING = 1;
    private boolean active;
    private List<ModuleView> items;
    private ModuleGroupNode navigationNode;

    public void paint(GC gc, Object value) {
        super.paint(gc, value);
        EmbeddedBorderRenderer borderRenderer = this.getLnfBorderRenderer();
        borderRenderer.setMarkers(this.getMarkers());
        borderRenderer.setBounds(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height);
        borderRenderer.setActive(this.isActive());
        borderRenderer.paint(gc, null);
    }

    public void dispose() {
        for (ModuleView item : this.getItems()) {
            item.dispose();
        }
    }

    public Point computeSize(GC gc, int wHint, int hHint) {
        EmbeddedBorderRenderer borderRenderer = this.getLnfBorderRenderer();
        int w = wHint;
        if (w == -1) {
            w = borderRenderer.computeOuterWidth(this.getItemWidth());
        }
        List<ModuleView> modules = this.getItems();
        int h = 0;
        if (modules.size() > 0) {
            Composite parent = modules.get(0).getParent();
            if (SwtUtilities.isDisposed((Widget)parent)) {
                return new Point(w, h);
            }
            h = this.getModuleGroupPadding();
            Collections.sort(modules, new ModuleComparator());
            for (ModuleView moduleView : modules) {
                if (moduleView.getNavigationNode() == null || moduleView.getNavigationNode().isDisposed()) break;
                moduleView.prepareUpdate();
            }
            parent.layout();
            Collections.sort(modules, new ModuleComparator());
            Iterator<ModuleView> iterator = modules.iterator();
            while (iterator.hasNext()) {
                ModuleView moduleView = iterator.next();
                if (moduleView.getNavigationNode() == null || moduleView.getNavigationNode().isDisposed()) break;
                h += moduleView.getBounds().height;
                if (iterator.hasNext()) {
                    h += this.getModuleModuleGap();
                    continue;
                }
                h += this.getModuleGroupPadding();
            }
            h = borderRenderer.computeOuterHeight(h);
        }
        return new Point(w, h);
    }

    private EmbeddedBorderRenderer getLnfBorderRenderer() {
        EmbeddedBorderRenderer renderer = (EmbeddedBorderRenderer)LnfManager.getLnf().getRenderer("ModuleGroup.borderRenderer");
        if (renderer == null) {
            renderer = new ModuleGroupBorderRenderer();
        }
        return renderer;
    }

    public List<ModuleView> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<ModuleView>();
        }
        return this.items;
    }

    public void setItems(List<ModuleView> items) {
        this.items = items;
    }

    public int getModuleModuleGap() {
        return 2;
    }

    public int getModuleGroupPadding() {
        return 1;
    }

    public int getItemWidth() {
        int width = LnfManager.getLnf().getIntegerSetting("navigation.width");
        width = SwtUtilities.convertXToDpi((int)width);
        return width -= 2 * this.getLnfBorderRenderer().getBorderWidth();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setNavigationNode(ModuleGroupNode navigationNode) {
        this.navigationNode = navigationNode;
    }

    private class ModuleComparator
    implements Comparator<ModuleView> {
        private ModuleComparator() {
        }

        @Override
        public int compare(ModuleView o1, ModuleView o2) {
            return ModuleGroupRenderer.this.navigationNode.getIndexOfChild((INavigationNode)o1.getNavigationNode()) < ModuleGroupRenderer.this.navigationNode.getIndexOfChild((INavigationNode)o2.getNavigationNode()) ? -1 : 1;
        }
    }
}

