/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.lnf.renderer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.navigation.ui.swt.component.SubApplicationItem;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.SubApplicationTabRenderer;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.swt.lnf.AbstractLnfRenderer;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

public class SubApplicationSwitcherRenderer
extends AbstractLnfRenderer {
    private Control control;
    private List<SubApplicationItem> items;

    public void paint(GC gc, Object value) {
        Point size;
        super.paint(gc, value);
        if (this.getBounds() == null) {
            return;
        }
        Assert.isNotNull((Object)gc);
        Assert.isNotNull((Object)value);
        Assert.isTrue((boolean)(value instanceof Control));
        this.control = (Control)value;
        RienaDefaultLnf lnf = LnfManager.getLnf();
        SubApplicationTabRenderer tabRenderer = this.getRenderer();
        int allTabWidth = 0;
        for (SubApplicationItem item : this.getVisibleItems()) {
            tabRenderer.setLabel(item.getLabel());
            tabRenderer.setActive(item.isActivated());
            Point size2 = tabRenderer.computeSize(gc, null);
            allTabWidth += size2.x;
        }
        Color bottomColor = lnf.getColor("SubApplicationSwitcher.borderBottomLeftColor");
        Color bottomSecondaryColor = lnf.getColor("SubApplicationSwitcher.borderBottomLeftSecondaryColor");
        gc.setForeground(bottomColor);
        int x = 0;
        int y = this.getBounds().height - 1;
        int x2 = this.getBounds().width;
        int y2 = y;
        gc.drawLine(x, y - 1, x2, y2 - 1);
        gc.setForeground(bottomSecondaryColor);
        gc.drawLine(x, y, x2, y2);
        int xPosition = 0;
        int position = lnf.getIntegerSetting("SubApplicationSwitcher.horizontalTabPosition");
        xPosition = position == 16384 ? 10 : (position == 131072 ? this.getBounds().width - 10 - allTabWidth : this.getBounds().width / 2 - allTabWidth / 2);
        x = xPosition;
        for (SubApplicationItem item : this.getVisibleItems()) {
            this.initItemRenderer(tabRenderer, item);
            size = tabRenderer.computeSize(gc, null);
            if (!item.isActivated()) {
                y = this.getBounds().height - size.y;
                tabRenderer.setBounds(x, y, size.x, size.y);
                tabRenderer.paint(gc, this.control);
                tabRenderer.setBounds(x, y, size.x, size.y);
                item.setBounds(tabRenderer.getBounds());
            }
            x += size.x;
        }
        x = xPosition;
        for (SubApplicationItem item : this.getVisibleItems()) {
            this.initItemRenderer(tabRenderer, item);
            size = tabRenderer.computeSize(gc, null);
            if (item.isActivated()) {
                y = this.getBounds().height - size.y;
                tabRenderer.setBounds(x, y, size.x, size.y);
                tabRenderer.paint(gc, this.control);
                tabRenderer.setBounds(x, y, size.x, size.y);
                item.setBounds(tabRenderer.getBounds());
            }
            x += size.x;
        }
    }

    private List<SubApplicationItem> getVisibleItems() {
        ArrayList<SubApplicationItem> visibleItems = new ArrayList<SubApplicationItem>();
        for (SubApplicationItem item : this.getItems()) {
            if (!item.getMarkersOfType(HiddenMarker.class).isEmpty()) continue;
            visibleItems.add(item);
        }
        return visibleItems;
    }

    private void initItemRenderer(SubApplicationTabRenderer tabRenderer, SubApplicationItem item) {
        tabRenderer.setLabel(item.getLabel());
        tabRenderer.setIcon(item.getIcon());
        tabRenderer.setActive(item.isActivated());
        tabRenderer.setMarkers(item.getMarkers());
    }

    public void dispose() {
        for (SubApplicationItem item : this.getItems()) {
            item.dispose();
        }
    }

    private List<SubApplicationItem> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<SubApplicationItem>();
        }
        return this.items;
    }

    public void setItems(List<SubApplicationItem> items) {
        this.items = items;
    }

    private SubApplicationTabRenderer getRenderer() {
        return (SubApplicationTabRenderer)LnfManager.getLnf().getRenderer("SubApplication.tabRenderer");
    }
}

