/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.RienaConfiguration;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.navigation.ui.swt.Activator;
import org.eclipse.riena.internal.ui.ridgets.swt.uiprocess.UIProcessRidget;
import org.eclipse.riena.internal.ui.swt.facades.WorkbenchFacade;
import org.eclipse.riena.navigation.ApplicationModelFailure;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.listener.INavigationNodeListener;
import org.eclipse.riena.navigation.listener.ISubModuleNodeListener;
import org.eclipse.riena.navigation.listener.NavigationTreeObserver;
import org.eclipse.riena.navigation.listener.SubApplicationNodeListener;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.model.SubApplicationNode;
import org.eclipse.riena.navigation.ui.controllers.SubApplicationController;
import org.eclipse.riena.navigation.ui.swt.binding.DelegatingRidgetMapper;
import org.eclipse.riena.navigation.ui.swt.binding.InjectSwtViewBindingDelegate;
import org.eclipse.riena.navigation.ui.swt.component.MenuCoolBarComposite;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewId;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewProvider;
import org.eclipse.riena.navigation.ui.swt.views.IComponentUpdateListener;
import org.eclipse.riena.navigation.ui.swt.views.INavigationNodeView;
import org.eclipse.riena.navigation.ui.swt.views.RienaMenuHelper;
import org.eclipse.riena.navigation.ui.swt.views.SubModuleView;
import org.eclipse.riena.ui.ridgets.SubModuleUtils;
import org.eclipse.riena.ui.ridgets.controller.IController;
import org.eclipse.riena.ui.ridgets.swt.uibinding.AbstractViewBindingDelegate;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.riena.ui.swt.uiprocess.UIProcessControl;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.workarea.WorkareaManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.ISourceProviderListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class SubApplicationView
implements INavigationNodeView<SubApplicationNode>,
IPerspectiveFactory {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), SubApplicationView.class);
    private final LinkedList<SwtViewId> subModuleViewStock = new LinkedList();
    private final AbstractViewBindingDelegate binding = this.createBinding();
    private final RienaMenuHelper menuBindHelper = new RienaMenuHelper();
    private final ISourceProviderListener menuSourceProviderListener = new MenuSourceProviderListener();
    private SubApplicationController subApplicationController;
    private SubApplicationListener subApplicationListener;
    private SubApplicationNode subApplicationNode;

    @Override
    public void addUpdateListener(IComponentUpdateListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void bind(SubApplicationNode node) {
        this.menuBindHelper.addSourceProviderListener(this.menuSourceProviderListener);
        if (this.getNavigationNode().getNavigationNodeController() instanceof IController) {
            IController controller = (IController)node.getNavigationNodeController();
            this.binding.injectRidgets(controller);
            this.binding.bind(controller);
            this.bindMenuAndToolItems(controller);
            controller.afterBind();
        }
        this.subApplicationListener = new SubApplicationListener();
        this.getNavigationNode().addListener((INavigationNodeListener)this.subApplicationListener);
    }

    public void createInitialLayout(IPageLayout layout) {
        this.addUIControls();
        this.subApplicationNode = (SubApplicationNode)this.locateSubApplication(layout);
        this.subApplicationController = this.createController((ISubApplicationNode)this.subApplicationNode);
        this.initializeListener(this.subApplicationController);
        this.bind(this.subApplicationNode);
        this.subApplicationController.afterBind();
        this.doBaseLayout(layout);
    }

    @Override
    public SubApplicationNode getNavigationNode() {
        return this.subApplicationNode;
    }

    @Override
    public void unbind() {
        if (this.getNavigationNode() != null) {
            this.getNavigationNode().removeListener((INavigationNodeListener)this.subApplicationListener);
            if (this.getNavigationNode().getNavigationNodeController() instanceof IController) {
                IController controller = (IController)this.getNavigationNode().getNavigationNodeController();
                this.binding.unbind(controller);
                this.menuBindHelper.unbind(controller);
            }
        }
        this.menuBindHelper.removeSourceProviderListener(this.menuSourceProviderListener);
    }

    protected AbstractViewBindingDelegate createBinding() {
        DelegatingRidgetMapper ridgetMapper = new DelegatingRidgetMapper(SwtControlRidgetMapper.getInstance());
        this.addMappings(ridgetMapper);
        return new InjectSwtViewBindingDelegate(ridgetMapper);
    }

    protected SubApplicationController createController(ISubApplicationNode subApplication) {
        return new SubApplicationController(subApplication);
    }

    protected void doBaseLayout(IPageLayout layout) {
        layout.setEditorAreaVisible(false);
        layout.setFixed(true);
    }

    private void addMappings(DelegatingRidgetMapper ridgetMapper) {
        ridgetMapper.addMapping(UIProcessControl.class, UIProcessRidget.class);
    }

    private void addUIControls() {
        this.initUIProcessRidget();
    }

    private void bindMenuAndToolItems(IController controller) {
        Shell shell = this.getShell();
        this.menuBindHelper.bindMenuAndToolItems(controller, (Composite)shell, (Composite)shell);
    }

    private Shell getShell() {
        Shell shell;
        Shell[] shells;
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        Shell[] shellArray = shells = Display.getDefault().getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            shell = shellArray[n2];
            String value = locator.locateBindingProperty((Object)shell);
            if (value != null && value.equals("applicationWindow")) {
                return shell;
            }
            ++n2;
        }
        shell = WorkbenchFacade.getInstance().getActiveWindowShell();
        if (shell == null) {
            shell = Display.getDefault().getActiveShell();
        }
        return shell;
    }

    private void initializeListener(SubApplicationController controller) {
        NavigationTreeObserver navigationTreeObserver = new NavigationTreeObserver();
        navigationTreeObserver.addListener((ISubModuleNodeListener)new MySubModuleNodeListener());
        navigationTreeObserver.addListenerTo((ISubApplicationNode)controller.getNavigationNode());
    }

    private void initUIProcessRidget() {
        UIProcessControl uiControl = new UIProcessControl(this.getShell());
        uiControl.setPropertyName("uiProcessRidget");
        this.binding.addUIControl((Object)uiControl);
    }

    protected ISubApplicationNode locateSubApplication(IPageLayout layout) {
        return SwtViewProvider.getInstance().getNavigationNode(layout.getDescriptor().getId(), ISubApplicationNode.class);
    }

    protected int getViewUserCount(SwtViewId id) {
        return SwtViewProvider.getInstance().getViewUsers(id).size();
    }

    private void updateMenuBar() {
        List<MenuCoolBarComposite> menuCoolBarComposites = this.menuBindHelper.getMenuCoolBarComposites((Composite)this.getShell());
        for (MenuCoolBarComposite menuBarComp : menuCoolBarComposites) {
            menuBarComp.updateMenuItems();
        }
        IController controller = (IController)this.getNavigationNode().getNavigationNodeController();
        this.bindMenuAndToolItems(controller);
    }

    protected SwtViewId getViewId(ISubModuleNode node) {
        return SwtViewProvider.getInstance().getSwtViewId((INavigationNode<?>)node);
    }

    private IWorkbenchPage getActivePage() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    private IPerspectiveDescriptor getActivePerspective() {
        IWorkbenchPage page = this.getActivePage();
        if (page != null) {
            return page.getPerspective();
        }
        return null;
    }

    private boolean hideView(String id, String secondary) {
        boolean successful = false;
        IViewReference viewRef = this.getActivePage().findViewReference(id, secondary);
        if (viewRef != null) {
            IViewPart view = viewRef.getView(false);
            if (view instanceof INavigationNodeView) {
                ((INavigationNodeView)view).unbind();
            }
            this.getActivePage().hideView(view);
            this.removeFromStock(new SwtViewId(id, secondary));
            successful = true;
        }
        return successful;
    }

    protected boolean hideView(SwtViewId id) {
        return this.hideView(id.getId(), id.getSecondary());
    }

    private void showView(SwtViewId id) {
        this.showView(id.getId(), id.getSecondary());
    }

    private void showView(String id, String secondary) {
        IWorkbenchPage page = this.getActivePage();
        IViewReference viewRef = page.findViewReference(id, secondary);
        if (viewRef != null) {
            WorkbenchFacade.getInstance().showView(page, viewRef);
            if (id != "org.eclipse.riena.navigation.ui.swt.views.navigationViewPart") {
                SwtViewId swtViewId = new SwtViewId(id, secondary);
                this.addToStock(swtViewId);
                this.hideUnusedView();
            }
        }
    }

    private void hideUnusedView() {
        SwtViewId firstView = this.getFirstOfStock();
        SwtViewId swtViewId = this.getLastOfStock();
        while (swtViewId != null && !firstView.equals(swtViewId)) {
            if (!this.hideView(swtViewId)) {
                this.addToStock(swtViewId);
            }
            swtViewId = this.getLastOfStock();
        }
    }

    private IViewReference prepareView(SwtViewId id, ISubModuleNode currentPrepared) {
        return this.prepareView(id.getId(), id.getSecondary(), currentPrepared);
    }

    private IPerspectiveDescriptor getPerspectiveOfSubApplication(ISubApplicationNode subApp) {
        IPerspectiveDescriptor[] perspectives;
        Object subAppIdObject = WorkareaManager.getInstance().getDefinition((Object)this.getNavigationNode()).getViewId();
        String subAppId = String.valueOf(subAppIdObject);
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = perspectives = PlatformUI.getWorkbench().getPerspectiveRegistry().getPerspectives();
        int n = perspectives.length;
        int n2 = 0;
        while (n2 < n) {
            IPerspectiveDescriptor perspective = iPerspectiveDescriptorArray[n2];
            if (StringUtils.equals((CharSequence)subAppId, (CharSequence)perspective.getId())) {
                return perspective;
            }
            ++n2;
        }
        return null;
    }

    private IViewReference prepareView(String id, String secondary, ISubModuleNode currentPrepared) {
        try {
            IWorkbenchPage page = this.getActivePage();
            SubModuleView viewPart = null;
            if (secondary != null && secondary.startsWith("shared")) {
                viewPart = SwtViewProvider.getInstance().getRegisteredView(id, secondary);
            }
            if (viewPart == null) {
                IPerspectiveDescriptor activePerspective = this.getActivePerspective();
                IPerspectiveDescriptor subAppPerspective = this.getPerspectiveOfSubApplication((ISubApplicationNode)this.getNavigationNode());
                if (subAppPerspective != null) {
                    page.setPerspective(subAppPerspective);
                } else {
                    LOGGER.log(2, "No perspective found for sub application: " + this.getNavigationNode());
                }
                viewPart = page.showView(id, secondary, 2);
                if (subAppPerspective != null) {
                    page.setPerspective(activePerspective);
                }
            }
            if (currentPrepared != null && currentPrepared.getNavigationNodeController() == null && viewPart instanceof SubModuleView) {
                viewPart.prepareNode(currentPrepared);
            }
            return page.findViewReference(id, secondary);
        }
        catch (PartInitException exc) {
            String msg = String.format("Failed to prepare/show view: %s, %s", id, secondary);
            LOGGER.log(0, msg, (Throwable)exc);
            return null;
        }
    }

    private void addToStock(SwtViewId viewId) {
        this.removeFromStock(viewId);
        this.subModuleViewStock.addFirst(viewId);
    }

    private SwtViewId getFirstOfStock() {
        return this.subModuleViewStock.getFirst();
    }

    private SwtViewId getLastOfStock() {
        if (this.getMaxStockedViews() <= 0) {
            return null;
        }
        if (this.getMaxStockedViews() >= this.subModuleViewStock.size()) {
            return null;
        }
        return this.subModuleViewStock.getLast();
    }

    private boolean removeFromStock(SwtViewId viewId) {
        return this.subModuleViewStock.remove(viewId);
    }

    private int getMaxStockedViews() {
        String value = RienaConfiguration.getInstance().getProperty("riena.maxStockedViews");
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private class MenuSourceProviderListener
    implements ISourceProviderListener {
        private MenuSourceProviderListener() {
        }

        private void update(int sourcePriority) {
            if ((sourcePriority & Integer.MIN_VALUE) == Integer.MIN_VALUE && SubApplicationView.this.getNavigationNode().isSelected()) {
                SubApplicationView.this.updateMenuBar();
            }
        }

        public void sourceChanged(int sourcePriority, Map sourceValuesByName) {
            this.update(sourcePriority);
        }

        public void sourceChanged(int sourcePriority, String sourceName, Object sourceValue) {
            this.update(sourcePriority);
        }
    }

    private class MySubModuleNodeListener
    extends SubModuleNodeListener {
        private boolean navigationUp = false;

        private MySubModuleNodeListener() {
        }

        public void prepared(ISubModuleNode source) {
            if (SubModuleUtils.isPrepareView()) {
                this.checkBaseStructure();
                SwtViewId id = SubApplicationView.this.getViewId(source);
                if (id == null) {
                    return;
                }
                SwtViewProvider viewProvider = SwtViewProvider.getInstance();
                viewProvider.setCurrentPrepared((INavigationNode<?>)source);
                SubApplicationView.this.prepareView(id, source);
                viewProvider.setCurrentPrepared(null);
            }
        }

        public void afterActivated(ISubModuleNode source) {
            SubApplicationView.this.updateMenuBar();
        }

        public void activated(ISubModuleNode source) {
            this.checkBaseStructure();
            if (source != null && !source.isSelectable()) {
                return;
            }
            SwtViewId id = SubApplicationView.this.getViewId(source);
            SubApplicationView.this.prepareView(id, null);
            SubApplicationView.this.showView(id);
        }

        public void disposed(ISubModuleNode source) {
            block3: {
                try {
                    SwtViewId id = SubApplicationView.this.getViewId(source);
                    if (id.getSecondary() == null || !id.getSecondary().startsWith("shared") || SubApplicationView.this.getViewUserCount(id) < 1) {
                        SubApplicationView.this.hideView(id);
                    }
                    SwtViewProvider viewProvider = SwtViewProvider.getInstance();
                    viewProvider.unregisterSwtViewId((INavigationNode<?>)source);
                }
                catch (ApplicationModelFailure amf) {
                    if (!source.isSelectable()) break block3;
                    LOGGER.log(1, "Error disposing node " + source + ": " + amf.getMessage());
                }
            }
        }

        protected String createNextId() {
            return String.valueOf(System.currentTimeMillis());
        }

        private void checkBaseStructure() {
            if (!this.navigationUp) {
                this.createNavigation();
                this.navigationUp = true;
            }
        }

        private void createNavigation() {
            String secId = this.createNextId();
            SubApplicationView.this.prepareView("org.eclipse.riena.navigation.ui.swt.views.navigationViewPart", secId, null);
            SubApplicationView.this.showView("org.eclipse.riena.navigation.ui.swt.views.navigationViewPart", secId);
        }
    }

    private class SubApplicationListener
    extends SubApplicationNodeListener {
        private SubApplicationListener() {
        }

        public void block(ISubApplicationNode source, boolean block) {
            super.block((INavigationNode)source, block);
            for (IModuleGroupNode group : source.getChildren()) {
                for (IModuleNode module : group.getChildren()) {
                    module.setBlocked(block);
                }
            }
        }

        public void disposed(ISubApplicationNode source) {
            SubApplicationView.this.unbind();
        }

        public void nodeIdChange(ISubApplicationNode source, NavigationNodeId oldId, NavigationNodeId newId) {
            if (source.equals(SubApplicationView.this.getNavigationNode())) {
                SwtViewProvider.getInstance().replaceNavigationNodeId((INavigationNode<?>)source, oldId, newId);
            }
        }
    }
}

