/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.riena.beans.common.BooleanBean;
import org.eclipse.riena.core.marker.AbstractMarker;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.FTActionListener;
import org.eclipse.riena.internal.ui.ridgets.swt.ToggleButtonRidget;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.IStatuslineRidget;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractRidgetController;
import org.eclipse.riena.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;

public class ToggleButtonRidgetTest
extends AbstractSWTRidgetTest {
    private static final String ICON_ECLIPSE = "eclipse.gif";
    private static final String LABEL = "testlabel";
    private static final String LABEL2 = "testlabel2";

    protected IToggleButtonRidget createRidget() {
        return new ToggleButtonRidget();
    }

    protected Button createWidget(Composite parent) {
        return new Button(parent, 32);
    }

    protected IToggleButtonRidget getRidget() {
        return (IToggleButtonRidget)super.getRidget();
    }

    protected Button getWidget() {
        return (Button)super.getWidget();
    }

    public void testEnableDisableModelSynchronization() throws Exception {
        BooleanBean model = new BooleanBean(false);
        IToggleButtonRidget r = this.getRidget();
        r.bindToModel((Object)model, "value");
        r.updateFromModel();
        Button w = this.getWidget();
        ToggleButtonRidgetTest.assertFalse((boolean)model.isValue());
        ToggleButtonRidgetTest.assertFalse((boolean)r.isSelected());
        ToggleButtonRidgetTest.assertFalse((boolean)w.getSelection());
        w.setSelection(true);
        this.fireSelection(w);
        ToggleButtonRidgetTest.assertTrue((boolean)model.isValue());
        ToggleButtonRidgetTest.assertTrue((boolean)r.isSelected());
        ToggleButtonRidgetTest.assertTrue((boolean)w.getSelection());
        r.setEnabled(false);
        model.setValue(false);
        r.updateFromModel();
        ToggleButtonRidgetTest.assertFalse((boolean)model.isValue());
        ToggleButtonRidgetTest.assertFalse((boolean)r.isSelected());
        ToggleButtonRidgetTest.assertFalse((boolean)r.isEnabled());
        ToggleButtonRidgetTest.assertFalse((boolean)w.getSelection());
        r.setEnabled(true);
        r.updateFromModel();
        ToggleButtonRidgetTest.assertFalse((boolean)model.isValue());
        ToggleButtonRidgetTest.assertFalse((boolean)r.isSelected());
        ToggleButtonRidgetTest.assertFalse((boolean)w.getSelection());
        w.setSelection(true);
        this.fireSelection(w);
        ToggleButtonRidgetTest.assertTrue((boolean)model.isValue());
        ToggleButtonRidgetTest.assertTrue((boolean)r.isSelected());
        ToggleButtonRidgetTest.assertTrue((boolean)w.getSelection());
    }

    public void testRidgetMapping() {
        Shell shell = this.getShell();
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        Button buttonToggle = new Button((Composite)shell, 2);
        ToggleButtonRidgetTest.assertSame(ToggleButtonRidget.class, (Object)mapper.getRidgetClass((Object)buttonToggle));
        Button buttonCheck = new Button((Composite)shell, 32);
        ToggleButtonRidgetTest.assertSame(ToggleButtonRidget.class, (Object)mapper.getRidgetClass((Object)buttonCheck));
        Button buttonPush = new Button((Composite)shell, 8);
        ToggleButtonRidgetTest.assertNotSame(ToggleButtonRidget.class, (Object)mapper.getRidgetClass((Object)buttonPush));
        Button aButton = new Button((Composite)shell, 0);
        ToggleButtonRidgetTest.assertNotSame(ToggleButtonRidget.class, (Object)mapper.getRidgetClass((Object)aButton));
    }

    public void testSetUIControl() throws Exception {
        IToggleButtonRidget ridget = this.getRidget();
        Button button = this.getWidget();
        ToggleButtonRidgetTest.assertSame((Object)button, (Object)ridget.getUIControl());
    }

    public void testSetSelected() throws Exception {
        IToggleButtonRidget ridget = this.getRidget();
        Button button = this.getWidget();
        BooleanTestPojo model = new BooleanTestPojo();
        IObservableValue modelOV = PojoObservables.observeValue((Object)model, (String)"selected");
        ridget.bindToModel(modelOV);
        ridget.setSelected(true);
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isSelected());
        ToggleButtonRidgetTest.assertTrue((boolean)button.getSelection());
        ridget.setSelected(false);
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isSelected());
        ToggleButtonRidgetTest.assertFalse((boolean)button.getSelection());
    }

    public void testIsSelected() throws Exception {
        IToggleButtonRidget ridget = this.getRidget();
        BooleanTestPojo model = new BooleanTestPojo();
        model.setSelected(true);
        IObservableValue modelOV = PojoObservables.observeValue((Object)model, (String)"selected");
        ridget.bindToModel(modelOV);
        ridget.updateFromModel();
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isSelected());
    }

    public void testBindToModelIObservableValue() throws Exception {
        IToggleButtonRidget ridget = this.getRidget();
        BooleanTestPojo model = new BooleanTestPojo();
        model.setSelected(true);
        IObservableValue modelOV = PojoObservables.observeValue((Object)model, (String)"selected");
        ridget.bindToModel(modelOV);
        ToggleButtonRidgetTest.assertNotNull((Object)BeansObservables.observeValue((Object)ridget, (String)"selected"));
        ToggleButtonRidgetTest.assertEquals(Boolean.TYPE, (Object)BeansObservables.observeValue((Object)ridget, (String)"selected").getValueType());
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isSelected());
        ridget.updateFromModel();
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isSelected());
    }

    public void testBindToModelPropertyName() throws Exception {
        IToggleButtonRidget ridget = this.getRidget();
        BooleanTestPojo model = new BooleanTestPojo();
        model.setSelected(true);
        ridget.bindToModel((Object)model, "selected");
        ToggleButtonRidgetTest.assertNotNull((Object)BeansObservables.observeValue((Object)ridget, (String)"selected"));
        ToggleButtonRidgetTest.assertEquals(Boolean.TYPE, (Object)BeansObservables.observeValue((Object)ridget, (String)"selected").getValueType());
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isSelected());
        ridget.updateFromModel();
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isSelected());
    }

    public void testUpdateFromModel() throws Exception {
        IToggleButtonRidget ridget = this.getRidget();
        Button button = this.getWidget();
        BooleanTestPojo model = new BooleanTestPojo();
        model.setSelected(true);
        ridget.bindToModel((Object)model, "selected");
        ridget.updateFromModel();
        ToggleButtonRidgetTest.assertTrue((boolean)button.getSelection());
        model.setSelected(false);
        ridget.updateFromModel();
        ToggleButtonRidgetTest.assertFalse((boolean)button.getSelection());
    }

    public void testActionListener() {
        IToggleButtonRidget ridget = this.getRidget();
        ridget.setSelected(false);
        FTActionListener listener = new FTActionListener();
        ridget.addListener((IActionListener)listener);
        ridget.setSelected(true);
        ToggleButtonRidgetTest.assertEquals((int)1, (int)listener.getCount());
        ridget.setSelected(true);
        ToggleButtonRidgetTest.assertEquals((int)1, (int)listener.getCount());
        ridget.setSelected(false);
        ToggleButtonRidgetTest.assertEquals((int)2, (int)listener.getCount());
        ridget.removeListener((IActionListener)listener);
        ridget.setSelected(true);
        ToggleButtonRidgetTest.assertEquals((int)2, (int)listener.getCount());
        try {
            ridget.addListener(null);
            ToggleButtonRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public final void testSetText() throws Exception {
        IToggleButtonRidget ridget = this.getRidget();
        Button button = this.getWidget();
        ridget.setText("");
        ToggleButtonRidgetTest.assertEquals((String)"", (String)ridget.getText());
        ToggleButtonRidgetTest.assertEquals((String)"", (String)button.getText());
        try {
            ridget.setText(null);
            ToggleButtonRidgetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
        ridget.setText(LABEL);
        ToggleButtonRidgetTest.assertEquals((String)LABEL, (String)ridget.getText());
        ToggleButtonRidgetTest.assertEquals((String)LABEL, (String)button.getText());
        ridget.setUIControl(null);
        ridget.setText(LABEL2);
        ToggleButtonRidgetTest.assertEquals((String)LABEL2, (String)ridget.getText());
        ToggleButtonRidgetTest.assertEquals((String)LABEL, (String)button.getText());
        ridget.setUIControl((Object)button);
        ToggleButtonRidgetTest.assertEquals((String)LABEL2, (String)ridget.getText());
        ToggleButtonRidgetTest.assertEquals((String)LABEL2, (String)button.getText());
    }

    public final void testSetIcon() {
        IToggleButtonRidget ridget = this.getRidget();
        Button control = this.getWidget();
        ridget.setIcon(ICON_ECLIPSE);
        ToggleButtonRidgetTest.assertEquals((String)ICON_ECLIPSE, (String)ridget.getIcon());
        ToggleButtonRidgetTest.assertNotNull((Object)control.getImage());
        ridget.setIcon(null);
        ToggleButtonRidgetTest.assertNull((Object)ridget.getIcon());
        ToggleButtonRidgetTest.assertNull((Object)control.getImage());
        ridget.setIcon("nonsense");
        Image missingImage = ImageStore.getInstance().getMissingImage();
        ToggleButtonRidgetTest.assertEquals((String)"nonsense", (String)ridget.getIcon());
        ToggleButtonRidgetTest.assertEquals((Object)missingImage, (Object)control.getImage());
        Button button = this.createWidget((Composite)this.getShell());
        Image buttonImage = button.getDisplay().getSystemImage(2);
        button.setImage(buttonImage);
        IToggleButtonRidget buttonRidget = this.createRidget();
        buttonRidget.setUIControl((Object)button);
        ToggleButtonRidgetTest.assertSame((Object)buttonImage, (Object)button.getImage());
        buttonRidget.setIcon(null);
        ToggleButtonRidgetTest.assertNull((Object)buttonRidget.getIcon());
        ToggleButtonRidgetTest.assertNull((Object)button.getImage());
        buttonRidget.setIcon(ICON_ECLIPSE);
        ToggleButtonRidgetTest.assertEquals((String)ICON_ECLIPSE, (String)buttonRidget.getIcon());
        ToggleButtonRidgetTest.assertNotNull((Object)button.getImage());
        ToggleButtonRidgetTest.assertNotSame((Object)buttonImage, (Object)button.getImage());
        button = this.createWidget((Composite)this.getShell());
        button.setImage(buttonImage);
        buttonRidget = this.createRidget();
        buttonRidget.setIcon(ICON_ECLIPSE);
        buttonRidget.setUIControl((Object)button);
        ToggleButtonRidgetTest.assertNotNull((Object)button.getImage());
        ToggleButtonRidgetTest.assertNotSame((Object)buttonImage, (Object)button.getImage());
    }

    public final void testInitText() {
        IToggleButtonRidget ridget = this.getRidget();
        Button control = this.getWidget();
        ReflectionUtils.setHidden((Object)ridget, (String)"textAlreadyInitialized", (Object)false);
        ReflectionUtils.setHidden((Object)ridget, (String)"text", null);
        control.setText("Hello!");
        ReflectionUtils.invokeHidden((Object)ridget, (String)"initText", (Object[])new Object[0]);
        ToggleButtonRidgetTest.assertEquals((String)"Hello!", (String)ridget.getText());
        ToggleButtonRidgetTest.assertEquals((String)"Hello!", (String)control.getText());
        ToggleButtonRidgetTest.assertTrue((boolean)((Boolean)ReflectionUtils.getHidden((Object)ridget, (String)"textAlreadyInitialized")));
        control.setText("World");
        ReflectionUtils.invokeHidden((Object)ridget, (String)"initText", (Object[])new Object[0]);
        ToggleButtonRidgetTest.assertEquals((String)"Hello!", (String)ridget.getText());
        ToggleButtonRidgetTest.assertEquals((String)"World", (String)control.getText());
    }

    public void testOutputRidgetNotVisible() {
        IToggleButtonRidget ridget = this.getRidget();
        Button control = this.getWidget();
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isOutputOnly());
        ToggleButtonRidgetTest.assertTrue((boolean)control.isVisible());
        ridget.setOutputOnly(true);
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isOutputOnly());
        ToggleButtonRidgetTest.assertTrue((boolean)control.isVisible());
        ridget.setOutputOnly(false);
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isOutputOnly());
        ToggleButtonRidgetTest.assertTrue((boolean)control.isVisible());
        ridget.setOutputOnly(true);
        ridget.setVisible(true);
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isOutputOnly());
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isVisible());
        ToggleButtonRidgetTest.assertTrue((boolean)control.isVisible());
        ridget.setVisible(false);
        ridget.setOutputOnly(false);
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isOutputOnly());
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isVisible());
        ToggleButtonRidgetTest.assertFalse((boolean)control.isVisible());
        ridget.setVisible(true);
        ridget.setOutputOnly(false);
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isOutputOnly());
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isVisible());
        ToggleButtonRidgetTest.assertTrue((boolean)control.isVisible());
        ridget.setVisible(false);
        ridget.setOutputOnly(true);
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isOutputOnly());
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isVisible());
        ToggleButtonRidgetTest.assertFalse((boolean)control.isVisible());
        ridget.setVisible(true);
        ridget.setOutputOnly(true);
        ridget.setVisible(false);
        ridget.setVisible(true);
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isOutputOnly());
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isVisible());
    }

    public void testDisabledRidgetDoesNotCheckControlOnRidgetSelection() {
        IToggleButtonRidget ridget = this.getRidget();
        Button control = this.getWidget();
        BooleanTestPojo model = new BooleanTestPojo();
        ridget.bindToModel((Object)model, "selected");
        ridget.setSelected(false);
        ridget.setEnabled(false);
        ToggleButtonRidgetTest.assertFalse((boolean)model.isSelected());
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isSelected());
        ToggleButtonRidgetTest.assertFalse((boolean)control.getSelection());
        ridget.setSelected(true);
        ToggleButtonRidgetTest.assertTrue((boolean)model.isSelected());
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isSelected());
        if (MarkerSupport.isHideDisabledRidgetContent()) {
            ToggleButtonRidgetTest.assertFalse((boolean)control.getSelection());
        } else {
            ToggleButtonRidgetTest.assertTrue((boolean)control.getSelection());
        }
        ridget.setEnabled(true);
        ToggleButtonRidgetTest.assertTrue((boolean)model.isSelected());
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isSelected());
        ToggleButtonRidgetTest.assertTrue((boolean)control.getSelection());
    }

    public void testDisabledRidgetDoesNotCheckControlOnModelSelection() {
        IToggleButtonRidget ridget = this.getRidget();
        Button control = this.getWidget();
        BooleanTestPojo model = new BooleanTestPojo();
        ridget.bindToModel((Object)model, "selected");
        ridget.setEnabled(false);
        model.setSelected(false);
        ridget.updateFromModel();
        ToggleButtonRidgetTest.assertFalse((boolean)model.isSelected());
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isSelected());
        ToggleButtonRidgetTest.assertFalse((boolean)control.getSelection());
        model.setSelected(true);
        ridget.updateFromModel();
        ToggleButtonRidgetTest.assertTrue((boolean)model.isSelected());
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isSelected());
        if (MarkerSupport.isHideDisabledRidgetContent()) {
            ToggleButtonRidgetTest.assertFalse((boolean)control.getSelection());
        } else {
            ToggleButtonRidgetTest.assertTrue((boolean)control.getSelection());
        }
        ridget.setEnabled(true);
        ToggleButtonRidgetTest.assertTrue((boolean)model.isSelected());
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isSelected());
        ToggleButtonRidgetTest.assertTrue((boolean)control.getSelection());
    }

    public void testDisableRidgetRemovesSelection() {
        IToggleButtonRidget ridget = this.getRidget();
        Button control = this.getWidget();
        ridget.setEnabled(true);
        ridget.setSelected(true);
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isEnabled());
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isSelected());
        ToggleButtonRidgetTest.assertTrue((boolean)control.isEnabled());
        ToggleButtonRidgetTest.assertTrue((boolean)control.getSelection());
        ridget.setEnabled(false);
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isEnabled());
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isSelected());
        ToggleButtonRidgetTest.assertFalse((boolean)control.isEnabled());
        if (MarkerSupport.isHideDisabledRidgetContent()) {
            ToggleButtonRidgetTest.assertFalse((boolean)control.getSelection());
        } else {
            ToggleButtonRidgetTest.assertTrue((boolean)control.getSelection());
        }
        ridget.setEnabled(true);
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isEnabled());
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isSelected());
        ToggleButtonRidgetTest.assertTrue((boolean)control.isEnabled());
        ToggleButtonRidgetTest.assertTrue((boolean)control.getSelection());
    }

    public void testDisabledDoesNotFireSelected() {
        IToggleButtonRidget ridget = this.getRidget();
        ridget.setEnabled(true);
        ridget.setSelected(true);
        ridget.addPropertyChangeListener("selected", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ToggleButtonRidgetTest.fail((String)("Unexpected property change event: " + evt));
            }
        });
        ridget.setEnabled(false);
        ridget.setEnabled(true);
    }

    public void testDisableAndClearOnBind() {
        IToggleButtonRidget ridget = this.getRidget();
        Button control = this.getWidget();
        ridget.setUIControl(null);
        ridget.setEnabled(false);
        ridget.setSelected(true);
        ridget.setUIControl((Object)control);
        ToggleButtonRidgetTest.assertFalse((boolean)control.isEnabled());
        if (MarkerSupport.isHideDisabledRidgetContent()) {
            ToggleButtonRidgetTest.assertFalse((boolean)control.getSelection());
        } else {
            ToggleButtonRidgetTest.assertTrue((boolean)control.getSelection());
        }
        ridget.setEnabled(true);
        ToggleButtonRidgetTest.assertTrue((boolean)control.isEnabled());
        ToggleButtonRidgetTest.assertTrue((boolean)control.getSelection());
    }

    public void testFireAction() {
        IToggleButtonRidget ridget = this.getRidget();
        FTActionListener listener1 = new FTActionListener();
        FTActionListener listener2 = new FTActionListener();
        ridget.addListener((IActionListener)listener1);
        ToggleButtonRidgetTest.assertEquals((int)0, (int)listener1.getCount());
        BooleanTestPojo model = new BooleanTestPojo();
        model.setSelected(true);
        ridget.bindToModel(PojoObservables.observeValue((Object)model, (String)"selected"));
        ridget.updateFromModel();
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isSelected());
        ToggleButtonRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        ridget.fireAction();
        ridget.fireAction();
        ToggleButtonRidgetTest.assertEquals((int)3, (int)listener1.getCount());
        ridget.addListener((IActionListener)listener2);
        ridget.fireAction();
        ToggleButtonRidgetTest.assertEquals((int)4, (int)listener1.getCount());
        ToggleButtonRidgetTest.assertEquals((int)1, (int)listener2.getCount());
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isSelected());
    }

    public void testOutputOnlyWidgetsAreDisabledWhenNotSelected() {
        IToggleButtonRidget ridget = this.getRidget();
        Button control = this.getWidget();
        this.setEnabledOutputSelected(ridget, false, false, false);
        ToggleButtonRidgetTest.assertEquals((boolean)false, (boolean)ridget.isEnabled());
        ToggleButtonRidgetTest.assertEquals((boolean)false, (boolean)control.isEnabled());
        this.setEnabledOutputSelected(ridget, false, false, true);
        ToggleButtonRidgetTest.assertEquals((boolean)false, (boolean)ridget.isEnabled());
        ToggleButtonRidgetTest.assertEquals((boolean)false, (boolean)control.isEnabled());
        this.setEnabledOutputSelected(ridget, false, false, false);
        ToggleButtonRidgetTest.assertEquals((boolean)false, (boolean)ridget.isEnabled());
        ToggleButtonRidgetTest.assertEquals((boolean)false, (boolean)control.isEnabled());
        this.setEnabledOutputSelected(ridget, false, false, true);
        ToggleButtonRidgetTest.assertEquals((boolean)false, (boolean)ridget.isEnabled());
        ToggleButtonRidgetTest.assertEquals((boolean)false, (boolean)control.isEnabled());
        this.setEnabledOutputSelected(ridget, true, true, false);
        ToggleButtonRidgetTest.assertEquals((boolean)false, (boolean)ridget.isEnabled());
        ToggleButtonRidgetTest.assertEquals((boolean)false, (boolean)control.isEnabled());
        this.setEnabledOutputSelected(ridget, true, true, true);
        ToggleButtonRidgetTest.assertEquals((boolean)true, (boolean)ridget.isEnabled());
        ToggleButtonRidgetTest.assertEquals((boolean)true, (boolean)control.isEnabled());
        this.setEnabledOutputSelected(ridget, true, false, false);
        ToggleButtonRidgetTest.assertEquals((boolean)true, (boolean)ridget.isEnabled());
        ToggleButtonRidgetTest.assertEquals((boolean)true, (boolean)control.isEnabled());
        this.setEnabledOutputSelected(ridget, true, false, true);
        ToggleButtonRidgetTest.assertEquals((boolean)true, (boolean)ridget.isEnabled());
        ToggleButtonRidgetTest.assertEquals((boolean)true, (boolean)control.isEnabled());
    }

    public void testClickOnOutputOnlyCheckboxDoesNotChangeState() {
        IToggleButtonRidget ridget = this.getRidget();
        Button control = this.getWidget();
        ridget.setEnabled(true);
        ridget.setOutputOnly(false);
        ridget.setSelected(true);
        ridget.setOutputOnly(true);
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isSelected());
        ToggleButtonRidgetTest.assertTrue((boolean)control.getSelection());
        control.setSelection(false);
        this.fireSelection(control);
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isSelected());
        ToggleButtonRidgetTest.assertTrue((boolean)control.getSelection());
        ridget.setOutputOnly(false);
        control.setSelection(false);
        this.fireSelection(control);
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isSelected());
        ToggleButtonRidgetTest.assertFalse((boolean)control.getSelection());
    }

    public void testSetSelectedOnOutputOnlyCheckboxChangesState() {
        IToggleButtonRidget ridget = this.getRidget();
        ridget.setOutputOnly(false);
        ridget.setSelected(false);
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isSelected());
        ridget.setOutputOnly(true);
        ridget.setSelected(true);
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isSelected());
    }

    public void testSetMandatory() {
        IToggleButtonRidget ridget = this.getRidget();
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isMandatory());
        ridget.setMandatory(true);
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isMandatory());
        ridget.setMandatory(false);
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isMandatory());
    }

    public void testIsDisableMandatoryMarker() {
        IToggleButtonRidget ridget = this.getRidget();
        ridget.setEnabled(true);
        ridget.setMandatory(true);
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isDisableMandatoryMarker());
        ridget.setSelected(true);
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isDisableMandatoryMarker());
        ridget.setSelected(false);
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isDisableMandatoryMarker());
    }

    public void testDisabledMarkerUpdatesWithTwoRidgetsViaSetSelected() {
        IToggleButtonRidget ridget1 = this.getRidget();
        Button check2 = new Button((Composite)this.getShell(), 32);
        ToggleButtonRidget ridget2 = new ToggleButtonRidget();
        ridget2.setUIControl((Object)check2);
        ridget1.setSelected(false);
        ridget1.setEnabled(true);
        ridget1.setMandatory(true);
        ridget2.setSelected(false);
        ridget2.setEnabled(true);
        ridget2.setMandatory(true);
        ToggleButtonRidgetTest.assertFalse((boolean)((MandatoryMarker)ridget1.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ToggleButtonRidgetTest.assertFalse((boolean)((MandatoryMarker)ridget2.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ridget1.setSelected(true);
        ToggleButtonRidgetTest.assertTrue((boolean)((MandatoryMarker)ridget1.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ToggleButtonRidgetTest.assertTrue((boolean)((MandatoryMarker)ridget2.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ridget1.setSelected(false);
        ToggleButtonRidgetTest.assertFalse((boolean)((MandatoryMarker)ridget1.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ToggleButtonRidgetTest.assertFalse((boolean)((MandatoryMarker)ridget2.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ridget2.setSelected(true);
        ToggleButtonRidgetTest.assertTrue((boolean)((MandatoryMarker)ridget1.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ToggleButtonRidgetTest.assertTrue((boolean)((MandatoryMarker)ridget2.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ridget2.setSelected(false);
        ToggleButtonRidgetTest.assertFalse((boolean)((MandatoryMarker)ridget1.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ToggleButtonRidgetTest.assertFalse((boolean)((MandatoryMarker)ridget2.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
    }

    public void testDisabledMarkerUpdatesWithTwoRidgetsViaUISelection() {
        IToggleButtonRidget ridget1 = this.getRidget();
        Button check1 = (Button)ridget1.getUIControl();
        Button check2 = new Button((Composite)this.getShell(), 32);
        ToggleButtonRidget ridget2 = new ToggleButtonRidget();
        ridget2.setUIControl((Object)check2);
        ridget1.setSelected(false);
        ridget1.setEnabled(true);
        ridget1.setMandatory(true);
        ridget2.setSelected(false);
        ridget2.setEnabled(true);
        ridget2.setMandatory(true);
        ToggleButtonRidgetTest.assertFalse((boolean)((MandatoryMarker)ridget1.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ToggleButtonRidgetTest.assertFalse((boolean)((MandatoryMarker)ridget2.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        check1.setSelection(true);
        this.fireSelection(check1);
        ToggleButtonRidgetTest.assertTrue((boolean)((MandatoryMarker)ridget1.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ToggleButtonRidgetTest.assertTrue((boolean)((MandatoryMarker)ridget2.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        check1.setSelection(false);
        this.fireSelection(check1);
        ToggleButtonRidgetTest.assertFalse((boolean)((MandatoryMarker)ridget1.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ToggleButtonRidgetTest.assertFalse((boolean)((MandatoryMarker)ridget2.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        check2.setSelection(true);
        this.fireSelection(check2);
        ToggleButtonRidgetTest.assertTrue((boolean)((MandatoryMarker)ridget1.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ToggleButtonRidgetTest.assertTrue((boolean)((MandatoryMarker)ridget2.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        check2.setSelection(false);
        this.fireSelection(check2);
        ToggleButtonRidgetTest.assertFalse((boolean)((MandatoryMarker)ridget1.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ToggleButtonRidgetTest.assertFalse((boolean)((MandatoryMarker)ridget2.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
    }

    public void testIsDisableMandatoryMarkerWithOtherCheckbox() {
        IToggleButtonRidget ridget = this.getRidget();
        Button check2 = new Button((Composite)this.getShell(), 32);
        ridget.setEnabled(true);
        ridget.setMandatory(true);
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isDisableMandatoryMarker());
        ToggleButtonRidgetTest.assertFalse((boolean)check2.getSelection());
        check2.setSelection(true);
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isDisableMandatoryMarker());
        check2.setSelection(false);
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isDisableMandatoryMarker());
        check2.setSelection(true);
        check2.setEnabled(false);
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isDisableMandatoryMarker());
    }

    public void testMandatoryMarkerWithTwoRidgetsOnBindingOnSharedView() {
        IToggleButtonRidget ridget1 = this.getRidget();
        Button check2 = new Button((Composite)this.getShell(), 32);
        ToggleButtonRidget ridget2 = new ToggleButtonRidget();
        ridget2.setUIControl((Object)check2);
        AbstractRidgetController controller1 = new AbstractRidgetController(){

            public void configureRidgets() {
            }
        };
        AbstractRidgetController controller2 = new AbstractRidgetController(){

            public void configureRidgets() {
            }
        };
        ridget1.setController((IRidgetContainer)controller1);
        ridget1.setSelected(false);
        ridget1.setEnabled(true);
        ridget1.setMandatory(true);
        ridget2.setController((IRidgetContainer)controller2);
        ridget2.setSelected(false);
        ridget2.setEnabled(true);
        ridget2.setMandatory(true);
        ToggleButtonRidgetTest.assertFalse((boolean)((MandatoryMarker)ridget1.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ToggleButtonRidgetTest.assertFalse((boolean)((MandatoryMarker)ridget2.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ridget1.setSelected(true);
        ridget1.updateMarkers();
        ToggleButtonRidgetTest.assertTrue((boolean)((MandatoryMarker)ridget1.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ToggleButtonRidgetTest.assertFalse((boolean)((MandatoryMarker)ridget2.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ridget1.setSelected(false);
        ridget1.updateMarkers();
        ToggleButtonRidgetTest.assertFalse((boolean)((MandatoryMarker)ridget1.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ToggleButtonRidgetTest.assertFalse((boolean)((MandatoryMarker)ridget2.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ridget2.setSelected(true);
        ridget2.updateMarkers();
        ToggleButtonRidgetTest.assertFalse((boolean)((MandatoryMarker)ridget1.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ToggleButtonRidgetTest.assertTrue((boolean)((MandatoryMarker)ridget2.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ridget2.setSelected(false);
        ridget2.updateMarkers();
        ToggleButtonRidgetTest.assertFalse((boolean)((MandatoryMarker)ridget1.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ToggleButtonRidgetTest.assertFalse((boolean)((MandatoryMarker)ridget2.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ridget1.setSelected(true);
        ridget2.setSelected(true);
        ridget1.updateMarkers();
        ridget2.updateMarkers();
        ToggleButtonRidgetTest.assertTrue((boolean)((MandatoryMarker)ridget1.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ToggleButtonRidgetTest.assertTrue((boolean)((MandatoryMarker)ridget2.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ridget1.setController((IRidgetContainer)controller2);
        ridget1.setSelected(true);
        ridget2.setSelected(false);
        ridget1.updateMarkers();
        ToggleButtonRidgetTest.assertTrue((boolean)((MandatoryMarker)ridget1.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ToggleButtonRidgetTest.assertTrue((boolean)((MandatoryMarker)ridget2.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ridget1.setSelected(false);
        ridget1.updateMarkers();
        ToggleButtonRidgetTest.assertFalse((boolean)((MandatoryMarker)ridget1.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
        ToggleButtonRidgetTest.assertFalse((boolean)((MandatoryMarker)ridget2.getMarkersOfType(MandatoryMarker.class).iterator().next()).isDisabled());
    }

    public void testIsDisableMandatoryMarkerWithOtherButtons() {
        IToggleButtonRidget ridget = this.getRidget();
        Button radio = new Button((Composite)this.getShell(), 16);
        Button toggle = new Button((Composite)this.getShell(), 2);
        ridget.setEnabled(true);
        ridget.setMandatory(true);
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isDisableMandatoryMarker());
        ToggleButtonRidgetTest.assertFalse((boolean)radio.getSelection());
        ToggleButtonRidgetTest.assertFalse((boolean)toggle.getSelection());
        radio.setSelection(true);
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isDisableMandatoryMarker());
        ToggleButtonRidgetTest.assertTrue((boolean)radio.getSelection());
        ToggleButtonRidgetTest.assertFalse((boolean)toggle.getSelection());
        toggle.setSelection(true);
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isDisableMandatoryMarker());
        ToggleButtonRidgetTest.assertTrue((boolean)radio.getSelection());
        ToggleButtonRidgetTest.assertTrue((boolean)toggle.getSelection());
    }

    public void testSetOutputOnly() {
        IToggleButtonRidget ridget = this.createRidget();
        Button control = this.createWidget((Composite)this.getShell());
        ridget.setOutputOnly(true);
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isOutputOnly());
        ToggleButtonRidgetTest.assertTrue((boolean)control.isEnabled());
        ridget.setUIControl((Object)control);
        ridget.addMarker((IMarker)new AbstractMarker(){});
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isOutputOnly());
        ToggleButtonRidgetTest.assertFalse((boolean)control.isEnabled());
    }

    public void testSingleChoiceRadioButtons() throws Exception {
        DummyContainer controller = new DummyContainer();
        Button button = new Button((Composite)this.getShell(), 16);
        ToggleButtonRidget ridget = new ToggleButtonRidget();
        ridget.setUIControl((Object)button);
        SWTBindingPropertyLocator.getInstance().setBindingProperty((Object)button, "radio1");
        ridget.setController((IRidgetContainer)controller);
        controller.addRidget("radio1", (IRidget)ridget);
        Button button2 = new Button((Composite)this.getShell(), 16);
        ToggleButtonRidget ridget2 = new ToggleButtonRidget();
        ridget2.setUIControl((Object)button2);
        SWTBindingPropertyLocator.getInstance().setBindingProperty((Object)button2, "radio2");
        ridget2.setController((IRidgetContainer)controller);
        controller.addRidget("radio2", (IRidget)ridget2);
        ridget2.setSelected(true);
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isSelected());
        ToggleButtonRidgetTest.assertTrue((boolean)ridget2.isSelected());
        ToggleButtonRidgetTest.assertFalse((boolean)button.getSelection());
        ToggleButtonRidgetTest.assertTrue((boolean)button2.getSelection());
        ridget.setSelected(true);
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isSelected());
        ToggleButtonRidgetTest.assertFalse((boolean)ridget2.isSelected());
        ToggleButtonRidgetTest.assertTrue((boolean)button.getSelection());
        ToggleButtonRidgetTest.assertFalse((boolean)button2.getSelection());
    }

    private void fireSelection(Button control) {
        Event event = new Event();
        event.type = 13;
        event.widget = control;
        event.display = control.getDisplay();
        control.notifyListeners(13, event);
    }

    private void setEnabledOutputSelected(IToggleButtonRidget ridget, boolean enabled, boolean output, boolean selected) {
        ridget.setEnabled(enabled);
        ridget.setOutputOnly(output);
        ridget.setSelected(selected);
    }

    private static class BooleanTestPojo {
        private boolean selected;

        private BooleanTestPojo() {
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }

    private static final class DummyContainer
    implements IRidgetContainer {
        private final Map<String, IRidget> ridgets = new HashMap<String, IRidget>();

        private DummyContainer() {
        }

        public void addRidget(String id, IRidget ridget) {
            this.ridgets.put(id, ridget);
        }

        public boolean removeRidget(String id) {
            return false;
        }

        public void configureRidgets() {
        }

        public <R extends IRidget> R getRidget(String id) {
            return (R)this.ridgets.get(id);
        }

        public <R extends IRidget> R getRidget(Class<R> ridgetClazz, String id) {
            return this.getRidget(id);
        }

        public Collection<? extends IRidget> getRidgets() {
            return this.ridgets.values();
        }

        public boolean isConfigured() {
            return false;
        }

        public void setConfigured(boolean configured) {
        }

        public void setStatuslineToShowMarkerMessages(IStatuslineRidget statuslineToShowMarkerMessages) {
        }
    }
}

