/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.controllers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.riena.core.annotationprocessor.AnnotatedOverriddenMethodsGuard;
import org.eclipse.riena.core.annotationprocessor.AnnotationProcessor;
import org.eclipse.riena.core.annotationprocessor.DisposerList;
import org.eclipse.riena.core.annotationprocessor.IAnnotatedMethodHandler;
import org.eclipse.riena.core.annotationprocessor.IDisposer;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.annotationprocessor.IAnnotatedMethodHandlerExtension;
import org.eclipse.riena.internal.ui.ridgets.swt.LabelRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.TextRidget;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.NavigationProcessor;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.core.marker.OutputMarker;
import org.eclipse.riena.ui.ridgets.AbstractCompositeRidget;
import org.eclipse.riena.ui.ridgets.ComplexRidgetResolver;
import org.eclipse.riena.ui.ridgets.IMenuItemRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.annotation.OnClick;
import org.eclipse.riena.ui.ridgets.listener.IFocusListener;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class NavigationNodeControllerTest
extends RienaTestCase {
    private MyNavigationNodeController controller;
    private SubModuleNode node;
    private SubModuleNode node2;
    private Shell shell;
    private NavigationProcessor navigationProcessor;
    private static final String SUBMODULE1_TYPE_ID = "subModule1TypeId";
    private static final String SUBMODULE2_TYPE_ID = "subModule2TypeId";

    protected void setUp() throws Exception {
        Display display = Display.getDefault();
        this.shell = new Shell(display);
        this.shell.pack();
        this.shell.setVisible(true);
        Realm realm = SWTObservables.getRealm((Display)display);
        NavigationNodeControllerTest.assertNotNull((Object)realm);
        ReflectionUtils.invokeHidden((Object)realm, (String)"setDefault", (Object[])new Object[]{realm});
        this.node = new SubModuleNode(new NavigationNodeId(SUBMODULE1_TYPE_ID));
        this.node2 = new SubModuleNode(new NavigationNodeId(SUBMODULE2_TYPE_ID));
        this.navigationProcessor = new NavigationProcessor();
        this.node.setNavigationProcessor((INavigationProcessor)this.navigationProcessor);
        this.node2.setNavigationProcessor((INavigationProcessor)this.navigationProcessor);
        this.controller = new MyNavigationNodeController((ISubModuleNode)this.node);
    }

    protected void tearDown() throws Exception {
        this.controller = null;
        this.node = null;
        this.node2 = null;
        Handler.counter = 0;
        SwtUtilities.dispose((Widget)this.shell);
    }

    public void testUpdateNavigationMarkersUniqueAndDisabled() throws Exception {
        NavigationNodeControllerTest.assertTrue((boolean)this.node.getMarkers().isEmpty());
        TextRidget r1 = new TextRidget();
        r1.setUIControl((Object)new Text((Composite)this.shell, 0));
        MandatoryMarker m1 = new MandatoryMarker(true);
        r1.addMarker((IMarker)m1);
        this.controller.addRidget("id1", (IRidget)r1);
        this.controller.updateNavigationNodeMarkers();
        NavigationNodeControllerTest.assertEquals((int)1, (int)this.node.getMarkers().size());
        NavigationNodeControllerTest.assertSame((Object)m1, this.node.getMarkersOfType(MandatoryMarker.class).iterator().next());
        TextRidget r2 = new TextRidget();
        r2.setUIControl((Object)new Text((Composite)this.shell, 0));
        MandatoryMarker m2 = new MandatoryMarker(true);
        r2.addMarker((IMarker)m2);
        this.controller.addRidget("id2", (IRidget)r2);
        this.controller.updateNavigationNodeMarkers();
        NavigationNodeControllerTest.assertEquals((int)1, (int)this.node.getMarkers().size());
        NavigationNodeControllerTest.assertSame((Object)m1, this.node.getMarkersOfType(MandatoryMarker.class).iterator().next());
        m1.setDisabled(true);
        NavigationNodeControllerTest.assertEquals((int)1, (int)this.node.getMarkers().size());
        NavigationNodeControllerTest.assertSame((Object)m2, this.node.getMarkersOfType(MandatoryMarker.class).iterator().next());
    }

    public void testAddRidget() {
        LabelRidget ridget = new LabelRidget();
        this.controller.addRidget("4711", (IRidget)ridget);
        NavigationNodeControllerTest.assertNotNull((Object)this.controller.getRidgets());
        NavigationNodeControllerTest.assertEquals((int)1, (int)this.controller.getRidgets().size());
        PropertyChangeSupport support = (PropertyChangeSupport)ReflectionUtils.getHidden((Object)ridget, (String)"propertyChangeSupport");
        NavigationNodeControllerTest.assertNotNull((Object)support.getPropertyChangeListeners());
        NavigationNodeControllerTest.assertEquals((int)4, (int)support.getPropertyChangeListeners().length);
    }

    public void testUpdateNavigationNodeMarkers() {
        TextRidget ridget = new TextRidget();
        ridget.setUIControl((Object)new Text((Composite)this.shell, 0));
        ridget.addMarker((IMarker)new ErrorMarker());
        this.controller.addRidget("4711", (IRidget)ridget);
        this.controller.updateNavigationNodeMarkers();
        NavigationNodeControllerTest.assertFalse((boolean)this.node.getMarkers().isEmpty());
        NavigationNodeControllerTest.assertFalse((boolean)this.node.getMarkersOfType(ErrorMarker.class).isEmpty());
        MandatoryMarker mandatory1 = new MandatoryMarker();
        ridget.addMarker((IMarker)mandatory1);
        this.controller.updateNavigationNodeMarkers();
        NavigationNodeControllerTest.assertFalse((boolean)this.node.getMarkers().isEmpty());
        NavigationNodeControllerTest.assertFalse((boolean)this.node.getMarkersOfType(ErrorMarker.class).isEmpty());
        NavigationNodeControllerTest.assertFalse((boolean)this.node.getMarkersOfType(MandatoryMarker.class).isEmpty());
        ridget.setText("testtext");
        this.controller.updateNavigationNodeMarkers();
        NavigationNodeControllerTest.assertFalse((boolean)this.node.getMarkers().isEmpty());
        NavigationNodeControllerTest.assertFalse((boolean)this.node.getMarkersOfType(ErrorMarker.class).isEmpty());
        NavigationNodeControllerTest.assertTrue((boolean)this.node.getMarkersOfType(MandatoryMarker.class).isEmpty());
        ridget.setText(null);
        ridget.addMarker((IMarker)mandatory1);
        this.controller.updateNavigationNodeMarkers();
        NavigationNodeControllerTest.assertFalse((boolean)this.node.getMarkersOfType(MandatoryMarker.class).isEmpty());
        mandatory1.setDisabled(true);
        MandatoryMarker mandatory2 = new MandatoryMarker();
        TextRidget ridget2 = new TextRidget();
        ridget2.setUIControl((Object)new Text((Composite)this.shell, 0));
        ridget2.addMarker((IMarker)mandatory2);
        this.controller.addRidget("554", (IRidget)ridget2);
        this.controller.updateNavigationNodeMarkers();
        NavigationNodeControllerTest.assertFalse((boolean)this.node.getMarkersOfType(MandatoryMarker.class).isEmpty());
    }

    public void testGetRidgetMarkers() {
        TextRidget ridget = new TextRidget();
        ridget.setUIControl((Object)new Text((Composite)this.shell, 0));
        this.controller.addRidget("4711", (IRidget)ridget);
        TextRidget ridget2 = new TextRidget();
        ridget2.setUIControl((Object)new Text((Composite)this.shell, 0));
        this.controller.addRidget("0815", (IRidget)ridget2);
        Collection markers = (Collection)ReflectionUtils.invokeHidden((Object)((Object)this.controller), (String)"getRidgetMarkers", null);
        NavigationNodeControllerTest.assertNotNull((Object)markers);
        ErrorMarker errorMarker = new ErrorMarker();
        ridget.addMarker((IMarker)errorMarker);
        OutputMarker outputMarker = new OutputMarker();
        ridget2.addMarker((IMarker)outputMarker);
        markers = (Collection)ReflectionUtils.invokeHidden((Object)((Object)this.controller), (String)"getRidgetMarkers", null);
        NavigationNodeControllerTest.assertNotNull((Object)markers);
        NavigationNodeControllerTest.assertEquals((int)2, (int)markers.size());
        NavigationNodeControllerTest.assertTrue((boolean)markers.contains(errorMarker));
        NavigationNodeControllerTest.assertTrue((boolean)markers.contains(outputMarker));
        CompositeRidget compositeRidget = new CompositeRidget();
        TextRidget ridget3 = new TextRidget();
        ridget3.setUIControl((Object)new Text((Composite)this.shell, 0));
        compositeRidget.addRidget("label3", (IRidget)ridget3);
        this.controller.addRidget("comp", (IRidget)compositeRidget);
        MandatoryMarker mandatoryMarker = new MandatoryMarker();
        ridget3.addMarker((IMarker)mandatoryMarker);
        markers = (Collection)ReflectionUtils.invokeHidden((Object)((Object)this.controller), (String)"getRidgetMarkers", null);
        NavigationNodeControllerTest.assertNotNull((Object)markers);
        NavigationNodeControllerTest.assertEquals((int)3, (int)markers.size());
        NavigationNodeControllerTest.assertTrue((boolean)markers.contains(mandatoryMarker));
    }

    public void testGetRidget() throws Exception {
        System.getProperties().put("riena.test", "true");
        IRidget ridget = this.controller.getRidget(MockRidget.class, "myMock");
        NavigationNodeControllerTest.assertEquals(MockRidget.class, ridget.getClass());
        try {
            try {
                ridget = this.controller.getRidget(IMockRidget.class, "myMockInterface");
                NavigationNodeControllerTest.fail((String)"BindingException expected");
            }
            catch (BindingException bindingException) {
                this.ok("BindingException expected");
                System.getProperties().put("riena.test", "false");
            }
        }
        finally {
            System.getProperties().put("riena.test", "false");
        }
    }

    public void testGetChildId() throws Exception {
        ComplexRidgetResolver ridgetResolver = (ComplexRidgetResolver)ReflectionUtils.getHidden((Object)((Object)this.controller), (String)"ridgetResolver");
        String childId = (String)ReflectionUtils.invokeHidden((Object)ridgetResolver, (String)"getChildId", (Object[])new Object[]{"aa.bbb.cccc"});
        NavigationNodeControllerTest.assertEquals((String)"cccc", (String)childId);
        childId = (String)ReflectionUtils.invokeHidden((Object)ridgetResolver, (String)"getChildId", (Object[])new Object[]{"def"});
        NavigationNodeControllerTest.assertEquals((String)"def", (String)childId);
    }

    public void testGetContainer() throws Exception {
        ComplexRidgetResolver ridgetResolver = (ComplexRidgetResolver)ReflectionUtils.getHidden((Object)((Object)this.controller), (String)"ridgetResolver");
        Map ridgets = (Map)ReflectionUtils.getHidden((Object)((Object)this.controller), (String)"ridgets");
        IRidgetContainer container = (IRidgetContainer)ReflectionUtils.invokeHidden((Object)ridgetResolver, (String)"getContainer", (Object[])new Object[]{"container.child", ridgets});
        NavigationNodeControllerTest.assertNull((Object)container);
        org.eclipse.riena.internal.ui.ridgets.swt.CompositeRidget composite = new org.eclipse.riena.internal.ui.ridgets.swt.CompositeRidget();
        this.controller.addRidget("container", (IRidget)composite);
        container = (IRidgetContainer)ReflectionUtils.invokeHidden((Object)ridgetResolver, (String)"getContainer", (Object[])new Object[]{"container.child", ridgets});
        NavigationNodeControllerTest.assertSame((Object)composite, (Object)container);
        container = (IRidgetContainer)ReflectionUtils.invokeHidden((Object)ridgetResolver, (String)"getContainer", (Object[])new Object[]{"container", ridgets});
        NavigationNodeControllerTest.assertNull((Object)container);
    }

    public void testHiddenAndDisabledMarkersBlockAllRidgetMarkers() throws Exception {
        TextRidget ridget = new TextRidget();
        ridget.setUIControl((Object)new Text((Composite)this.shell, 0));
        this.controller.addRidget("4711", (IRidget)ridget);
        TextRidget ridget2 = new TextRidget();
        ridget2.setUIControl((Object)new Text((Composite)this.shell, 0));
        this.controller.addRidget("0815", (IRidget)ridget2);
        ErrorMarker errorMarker = new ErrorMarker();
        MandatoryMarker mandatoryMarker = new MandatoryMarker();
        HiddenMarker hiddenMarker = new HiddenMarker();
        DisabledMarker disabledMarker = new DisabledMarker();
        ridget.addMarker((IMarker)errorMarker);
        ridget.addMarker((IMarker)mandatoryMarker);
        Collection markers = (Collection)ReflectionUtils.invokeHidden((Object)((Object)this.controller), (String)"getRidgetMarkers", null);
        NavigationNodeControllerTest.assertEquals((int)2, (int)markers.size());
        NavigationNodeControllerTest.assertTrue((boolean)markers.contains(errorMarker));
        NavigationNodeControllerTest.assertTrue((boolean)markers.contains(mandatoryMarker));
        ridget.addMarker((IMarker)hiddenMarker);
        markers = (Collection)ReflectionUtils.invokeHidden((Object)((Object)this.controller), (String)"getRidgetMarkers", null);
        NavigationNodeControllerTest.assertTrue((boolean)markers.isEmpty());
        ridget2.addMarker((IMarker)errorMarker);
        ridget2.addMarker((IMarker)mandatoryMarker);
        markers = (Collection)ReflectionUtils.invokeHidden((Object)((Object)this.controller), (String)"getRidgetMarkers", null);
        NavigationNodeControllerTest.assertEquals((int)2, (int)markers.size());
        NavigationNodeControllerTest.assertTrue((boolean)markers.contains(errorMarker));
        NavigationNodeControllerTest.assertTrue((boolean)markers.contains(mandatoryMarker));
        ridget2.addMarker((IMarker)disabledMarker);
        markers = (Collection)ReflectionUtils.invokeHidden((Object)((Object)this.controller), (String)"getRidgetMarkers", null);
        NavigationNodeControllerTest.assertTrue((boolean)markers.isEmpty());
        ridget.removeMarker((IMarker)hiddenMarker);
        markers = (Collection)ReflectionUtils.invokeHidden((Object)((Object)this.controller), (String)"getRidgetMarkers", null);
        NavigationNodeControllerTest.assertEquals((int)2, (int)markers.size());
        NavigationNodeControllerTest.assertTrue((boolean)markers.contains(errorMarker));
        NavigationNodeControllerTest.assertTrue((boolean)markers.contains(mandatoryMarker));
    }

    public void testNavigationArgumentChanged() throws Exception {
        ModuleNode module = new ModuleNode(new NavigationNodeId("myModuleNode"));
        module.setNavigationProcessor((INavigationProcessor)this.navigationProcessor);
        module.addChild((INavigationNode)this.node);
        SubModuleNode node2 = new SubModuleNode();
        module.addChild((INavigationNode)node2);
        node2.activate();
        NavigationArgument arg = new NavigationArgument(new Object());
        NavigationNodeControllerTest.assertNull((Object)this.controller.lastArgument);
        node2.navigate(new NavigationNodeId(SUBMODULE1_TYPE_ID), arg);
        NavigationNodeControllerTest.assertTrue((boolean)this.node.isActivated());
        NavigationNodeControllerTest.assertSame((Object)arg, (Object)this.controller.lastArgument);
    }

    public void testHideShowMarkerFiresEvent() {
        TextRidget ridget = new TextRidget();
        FTPropertyChangeListener listener = new FTPropertyChangeListener();
        ridget.addPropertyChangeListener("markerHiding", (PropertyChangeListener)listener);
        NavigationNodeControllerTest.assertEquals((int)0, (int)listener.count);
        ridget.hideMarkersOfType(new Class[]{ErrorMarker.class});
        NavigationNodeControllerTest.assertEquals((int)1, (int)listener.count);
        ridget.hideMarkersOfType(new Class[]{ErrorMarker.class});
        NavigationNodeControllerTest.assertEquals((int)1, (int)listener.count);
        ridget.showMarkersOfType(new Class[]{MandatoryMarker.class});
        NavigationNodeControllerTest.assertEquals((int)1, (int)listener.count);
        ridget.showMarkersOfType(new Class[]{ErrorMarker.class});
        NavigationNodeControllerTest.assertEquals((int)2, (int)listener.count);
        ridget.showMarkersOfType(new Class[]{ErrorMarker.class});
        NavigationNodeControllerTest.assertEquals((int)2, (int)listener.count);
    }

    public void testDisposeListenerDisposeAnnotations() {
        MyAnnotationNavigationNodeController myController = new MyAnnotationNavigationNodeController((ISubModuleNode)this.node);
        TextRidget ridget = new TextRidget();
        myController.addRidget("4711", (IRidget)ridget);
        TextRidget ridget2 = new TextRidget();
        myController.addRidget("0815", (IRidget)ridget2);
        Handler onClick = new Handler();
        AnnotationProcessor.getInstance().update(new IAnnotatedMethodHandlerExtension[]{this.create(OnClick.class, onClick)});
        IDisposer disposer = AnnotationProcessor.getInstance().processMethods((Object)myController);
        myController.addAnnotationDisposer(disposer);
        NavigationNodeControllerTest.assertEquals((int)1, (int)Handler.counter);
        this.node.dispose();
        NavigationNodeControllerTest.assertEquals((int)0, (int)Handler.counter);
    }

    public void testDisposeListenerDisposeAnnotationsWithChangingController() {
        MyAnnotationNavigationNodeController myController = new MyAnnotationNavigationNodeController((ISubModuleNode)this.node);
        MyAnnotationNavigationNodeController myController2 = new MyAnnotationNavigationNodeController((ISubModuleNode)this.node);
        TextRidget ridget = new TextRidget();
        myController.addRidget("4711", (IRidget)ridget);
        TextRidget ridget2 = new TextRidget();
        myController.addRidget("0815", (IRidget)ridget2);
        TextRidget ridget3 = new TextRidget();
        myController2.addRidget("0815", (IRidget)ridget3);
        Handler onClick = new Handler();
        AnnotationProcessor.getInstance().update(new IAnnotatedMethodHandlerExtension[]{this.create(OnClick.class, onClick)});
        IDisposer disposer = AnnotationProcessor.getInstance().processMethods((Object)myController);
        myController.addAnnotationDisposer(disposer);
        NavigationNodeControllerTest.assertEquals((int)1, (int)Handler.counter);
        disposer = AnnotationProcessor.getInstance().processMethods((Object)myController2);
        myController2.addAnnotationDisposer(disposer);
        NavigationNodeControllerTest.assertEquals((int)2, (int)Handler.counter);
        myController.setNavigationNode((ISubModuleNode)this.node2);
        this.node.dispose();
        NavigationNodeControllerTest.assertEquals((int)1, (int)Handler.counter);
    }

    public void testDisposeListenerDisposeAnnotationsWithMoreController() {
        MyAnnotationNavigationNodeController myController = new MyAnnotationNavigationNodeController((ISubModuleNode)this.node);
        MyAnnotationNavigationNodeController myController2 = new MyAnnotationNavigationNodeController((ISubModuleNode)this.node2);
        TextRidget ridget = new TextRidget();
        myController.addRidget("0815", (IRidget)ridget);
        TextRidget ridget2 = new TextRidget();
        myController2.addRidget("0815", (IRidget)ridget2);
        Handler onClick = new Handler();
        AnnotationProcessor.getInstance().update(new IAnnotatedMethodHandlerExtension[]{this.create(OnClick.class, onClick)});
        IDisposer disposer = AnnotationProcessor.getInstance().processMethods((Object)myController);
        myController.addAnnotationDisposer(disposer);
        NavigationNodeControllerTest.assertEquals((int)1, (int)Handler.counter);
        disposer = AnnotationProcessor.getInstance().processMethods((Object)myController2);
        myController2.addAnnotationDisposer(disposer);
        NavigationNodeControllerTest.assertEquals((int)2, (int)Handler.counter);
        this.node2.dispose();
        NavigationNodeControllerTest.assertEquals((int)1, (int)Handler.counter);
    }

    private IAnnotatedMethodHandlerExtension create(final Class<? extends Annotation> annotationClass, final IAnnotatedMethodHandler handler) {
        return new IAnnotatedMethodHandlerExtension(){

            public Class<? extends Annotation> getAnnotation() {
                return annotationClass;
            }

            public IAnnotatedMethodHandler createHandler() {
                return handler;
            }
        };
    }

    private static class CompositeRidget
    extends AbstractCompositeRidget {
        private CompositeRidget() {
        }
    }

    private static final class FTPropertyChangeListener
    implements PropertyChangeListener {
        private int count;

        private FTPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ++this.count;
        }
    }

    private static class Handler
    implements IAnnotatedMethodHandler {
        public static int counter = 0;

        private Handler() {
        }

        public void handleAnnotation(Annotation annotation, Object object, Method method, Map<?, ?> optionalArgs, AnnotatedOverriddenMethodsGuard guard, DisposerList disposers) {
            ++counter;
            disposers.add((Object)new IDisposer(){

                public void dispose() {
                    --counter;
                }
            });
        }
    }

    private static interface IMockRidget
    extends IRidget {
    }

    public static class MockRidget
    implements IMockRidget {
        public Object getUIControl() {
            return null;
        }

        public void setUIControl(Object uiControl) {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener propertyChangeListener) {
        }

        public boolean isVisible() {
            return false;
        }

        public void setVisible(boolean visible) {
        }

        public boolean isEnabled() {
            return false;
        }

        public void setEnabled(boolean enabled) {
        }

        public void addFocusListener(IFocusListener listener) {
        }

        public void removeFocusListener(IFocusListener listener) {
        }

        public void updateFromModel() {
        }

        public void requestFocus() {
        }

        public boolean hasFocus() {
            return false;
        }

        public boolean isFocusable() {
            return false;
        }

        public void setFocusable(boolean focusable) {
        }

        public String getToolTipText() {
            return null;
        }

        public void setToolTipText(String toolTipText) {
        }

        public boolean isBlocked() {
            return false;
        }

        public void setBlocked(boolean blocked) {
        }

        public String getID() {
            return null;
        }

        public IRidgetContainer getController() {
            return null;
        }

        public void setController(IRidgetContainer controller) {
        }

        public void setIgnoreBindingError(boolean ignore) {
        }

        public boolean isIgnoreBindingError() {
            return false;
        }

        public IMenuItemRidget addMenuItem(String menuItemText) {
            return null;
        }

        public IMenuItemRidget addMenuItem(String menuItemText, String iconName) {
            return null;
        }

        public void removeMenuItem(String menuItemText) {
        }

        public void removeMenuItem(IMenuItemRidget menuItemRidget) {
        }

        public IMenuItemRidget getMenuItem(int index) {
            return null;
        }

        public int getMenuItemCount() {
            return 0;
        }

        public void updateContextMenu() {
        }
    }

    private static class MyAnnotationNavigationNodeController
    extends MyNavigationNodeController {
        public MyAnnotationNavigationNodeController(ISubModuleNode navigationNode) {
            super(navigationNode);
        }

        @OnClick(ridgetId="0815")
        private void doNothing() {
            Nop.reason((String)"Empty");
        }
    }

    public static class MyNavigationNodeController
    extends SubModuleController {
        private NavigationArgument lastArgument = null;

        public MyNavigationNodeController(ISubModuleNode navigationNode) {
            super(navigationNode);
        }

        public void updateNavigationNodeMarkers() {
            super.updateNavigationNodeMarkers();
        }

        public void navigationArgumentChanged(NavigationArgument argument) {
            this.lastArgument = argument;
        }
    }
}

