/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.objecttransaction.context;

import junit.framework.TestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.objecttransaction.context.BasicContextHolder;
import org.eclipse.riena.objecttransaction.context.ContextProxy;
import org.eclipse.riena.objecttransaction.context.IContext;
import org.eclipse.riena.objecttransaction.context.IContextHolder;

@NonUITestCase
public class ContextProxyTest
extends TestCase {
    private IContext activatedContext;
    private IContext passivatedContext;

    public void testContextManagementOnNotContextCarrier() {
        BasicContextHolder contextCarrier = new BasicContextHolder(null);
        ContextProxyTestContext context1 = new ContextProxyTestContext();
        ContextProxyTestContext context2 = new ContextProxyTestContext();
        ContextProxyTest.assertFalse((boolean)context1.equals(context2));
        ContextProxyTestNonContextCarrier nonContextCarrier = new ContextProxyTestNonContextCarrier();
        IContextProxyTestInterface nonContextCarrierProxy = (IContextProxyTestInterface)ContextProxy.cover((Object)nonContextCarrier, (IContextHolder)contextCarrier);
        this.activatedContext = null;
        this.passivatedContext = null;
        ContextProxyTest.assertNull((Object)contextCarrier.getContext());
        contextCarrier.setContext((IContext)context1);
        ContextProxyTest.assertNull((Object)this.activatedContext);
        ContextProxyTest.assertNull((Object)this.passivatedContext);
        nonContextCarrierProxy.doSomething();
        ContextProxyTest.assertEquals((Object)context1, (Object)this.activatedContext);
        ContextProxyTest.assertEquals((Object)context1, (Object)this.passivatedContext);
        this.activatedContext = null;
        this.passivatedContext = null;
        contextCarrier.setContext((IContext)context2);
        ContextProxyTest.assertEquals((Object)context2, (Object)contextCarrier.getContext());
        ContextProxyTest.assertNull((Object)this.activatedContext);
        ContextProxyTest.assertNull((Object)this.passivatedContext);
        nonContextCarrierProxy.doSomething();
        ContextProxyTest.assertEquals((Object)context2, (Object)this.activatedContext);
        ContextProxyTest.assertEquals((Object)context2, (Object)this.passivatedContext);
        this.activatedContext = null;
        this.passivatedContext = null;
        contextCarrier.setContext((IContext)context1);
        nonContextCarrierProxy = (IContextProxyTestInterface)ContextProxy.cover((Object)nonContextCarrier, (IContextHolder)contextCarrier);
        ContextProxyTest.assertEquals((Object)context1, (Object)contextCarrier.getContext());
        ContextProxyTest.assertNull((Object)this.activatedContext);
        ContextProxyTest.assertNull((Object)this.passivatedContext);
        nonContextCarrierProxy.doSomething();
        ContextProxyTest.assertEquals((Object)context1, (Object)this.activatedContext);
        ContextProxyTest.assertEquals((Object)context1, (Object)this.passivatedContext);
    }

    public void testContextManagementOnContextCarrier() {
        ContextProxyTestContext context1 = new ContextProxyTestContext();
        ContextProxyTestContext context2 = new ContextProxyTestContext();
        ContextProxyTest.assertFalse((boolean)context1.equals(context2));
        ContextProxyTestContextHolder contextCarrier = new ContextProxyTestContextHolder();
        IContextProxyTestInterfaceHolder contextCarrierProxy = (IContextProxyTestInterfaceHolder)ContextProxy.cover((IContextHolder)contextCarrier);
        this.activatedContext = null;
        this.passivatedContext = null;
        ContextProxyTest.assertNull((Object)contextCarrierProxy.getContext());
        contextCarrierProxy.setContext(context1);
        ContextProxyTest.assertEquals((Object)context1, (Object)contextCarrierProxy.getContext());
        contextCarrierProxy.setContext(context2);
        ContextProxyTest.assertEquals((Object)context2, (Object)contextCarrierProxy.getContext());
        contextCarrierProxy.doSomething();
        ContextProxyTest.assertEquals((Object)context2, (Object)this.activatedContext);
        ContextProxyTest.assertEquals((Object)context2, (Object)this.passivatedContext);
        contextCarrierProxy.setContext(context1);
        contextCarrierProxy.doSomething();
        ContextProxyTest.assertEquals((Object)context1, (Object)this.activatedContext);
        ContextProxyTest.assertEquals((Object)context1, (Object)this.passivatedContext);
    }

    private class ContextProxyTestContext
    implements IContext {
        private ContextProxyTestContext() {
        }

        public void activate() {
            ContextProxyTest.this.activatedContext = this;
        }

        public boolean isActivated() {
            return this.equals(ContextProxyTest.this.activatedContext);
        }

        public void passivate() {
            ContextProxyTest.this.passivatedContext = this;
        }
    }

    private static class ContextProxyTestContextHolder
    implements IContextProxyTestInterfaceHolder {
        private IContext context;

        private ContextProxyTestContextHolder() {
        }

        @Override
        public void doSomething() {
        }

        public IContext getContext() {
            return this.context;
        }

        public void setContext(IContext pContext) {
            this.context = pContext;
        }
    }

    private static class ContextProxyTestNonContextCarrier
    implements IContextProxyTestInterface {
        private ContextProxyTestNonContextCarrier() {
        }

        @Override
        public void doSomething() {
        }
    }

    private static interface IContextProxyTestInterface {
        public void doSomething();
    }

    private static interface IContextProxyTestInterfaceHolder
    extends IContextHolder {
        public void doSomething();
    }
}

