/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.databinding;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.ui.ridgets.databinding.DateToStringConverter;
import org.eclipse.riena.ui.ridgets.databinding.StringToDateConverter;

@NonUITestCase
public class DateToStringConverterTest
extends TestCase {
    public void testConvertToString() {
        DateToStringConverter converter = new DateToStringConverter("MM/dd/yyyy");
        Object result = converter.convert(null);
        DateToStringConverterTest.assertEquals(null, (Object)result);
        result = converter.convert((Object)this.localize(0L));
        DateToStringConverterTest.assertEquals((Object)"01/01/1970", (Object)result);
        Date date = this.localize(1221011682194L);
        result = converter.convert((Object)date);
        DateToStringConverterTest.assertEquals((Object)"09/10/2008", (Object)result);
    }

    public void testConvertToDateNoTimezone() {
        StringToDateConverter converter = new StringToDateConverter("MM/dd/yyyy");
        Date result = (Date)converter.convert(null);
        DateToStringConverterTest.assertEquals(null, (Object)result);
        result = (Date)converter.convert((Object)"01/01/1970");
        int offset = result.getTimezoneOffset() * 60 * 1000;
        DateToStringConverterTest.assertEquals((long)(0 + offset), (long)result.getTime());
    }

    public void testConvertToDateGMT() {
        StringToDateConverter converter = new StringToDateConverter("MM/dd/yyyy zzz");
        Date result = (Date)converter.convert(null);
        DateToStringConverterTest.assertEquals(null, (Object)result);
        result = (Date)converter.convert((Object)"01/01/1970 GMT");
        DateToStringConverterTest.assertEquals((long)0L, (long)result.getTime());
    }

    public void testConvertToDateGMTPlusTwo() {
        StringToDateConverter converter = new StringToDateConverter("MM/dd/yyyy zzzzz");
        Date result = (Date)converter.convert(null);
        DateToStringConverterTest.assertEquals(null, (Object)result);
        result = (Date)converter.convert((Object)"01/01/1970 +0200");
        DateToStringConverterTest.assertEquals((long)-7200000L, (long)result.getTime());
    }

    public void testConvertToDateExact() {
        StringToDateConverter converter = new StringToDateConverter("MM/dd/yyyy HH:mm:ss:SSS zzz");
        Date result1 = (Date)converter.convert((Object)"07/10/1996 16:05:28:046 PDT");
        DateToStringConverterTest.assertEquals((long)837039928046L, (long)result1.getTime());
        Date result2 = (Date)converter.convert((Object)"01/01/1970 00:00:00:000 GMT");
        DateToStringConverterTest.assertEquals((long)0L, (long)result2.getTime());
    }

    public void testToStringAndBack() {
        DateToStringConverter toString = new DateToStringConverter("MM/dd/yyyy");
        StringToDateConverter toDate = new StringToDateConverter("MM/dd/yyyy");
        Date input = this.localize(0L);
        Date result = (Date)toDate.convert(toString.convert((Object)input));
        DateToStringConverterTest.assertEquals((long)input.getTime(), (long)result.getTime());
    }

    public void testToDateAndBack() {
        DateToStringConverter toString = new DateToStringConverter("MM/dd/yyyy");
        StringToDateConverter toDate = new StringToDateConverter("MM/dd/yyyy");
        String result = (String)toString.convert(toDate.convert((Object)"01/01/1970"));
        DateToStringConverterTest.assertEquals((String)"01/01/1970", (String)result);
    }

    public void testDateToStringLocal1() {
        Calendar calendarInstance = Calendar.getInstance();
        calendarInstance.set(2010, 10, 12, 0, 0, 0);
        calendarInstance.setTimeZone(TimeZone.getDefault());
        Date date = calendarInstance.getTime();
        DateToStringConverter dateToStringConverter = new DateToStringConverter("dd.MM.yyyy HH:mm:ss");
        String dateAsString = (String)dateToStringConverter.convert((Object)date);
        DateToStringConverterTest.assertEquals((String)"12.11.2010 00:00:00", (String)dateAsString);
    }

    public void testDateToStringLocal2() {
        Calendar calendarInstance = Calendar.getInstance();
        calendarInstance.set(2010, 10, 12, 0, 0, 0);
        calendarInstance.setTimeZone(TimeZone.getDefault());
        Date date = calendarInstance.getTime();
        DateToStringConverter dateToStringConverter = new DateToStringConverter("dd.MM.yyyy HH:mm:ss");
        String dateAsString = (String)dateToStringConverter.convert((Object)date);
        DateToStringConverterTest.assertEquals((String)"12.11.2010 00:00:00", (String)dateAsString);
    }

    private Date localize(long msSinceEpochUtc) {
        Date localDate = new Date(msSinceEpochUtc);
        return new Date(localDate.getTime() + (long)(60000 * localDate.getTimezoneOffset()));
    }
}

