/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds.model;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.ds.InstanceProcess;
import org.eclipse.equinox.internal.ds.Reference;
import org.eclipse.equinox.internal.ds.SCRManager;
import org.eclipse.equinox.internal.ds.impl.ComponentContextImpl;
import org.eclipse.equinox.internal.ds.impl.ComponentInstanceImpl;
import org.eclipse.equinox.internal.ds.model.ComponentReference;
import org.eclipse.equinox.internal.ds.model.ServiceComponent;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.ComponentInstance;

public class ServiceComponentProp
implements PrivilegedExceptionAction {
    public static final int DISPOSED = 0;
    public static final int DISPOSING = 1;
    public static final int SATISFIED = 2;
    public static final int BUILDING = 3;
    public static final int BUILT = 4;
    public ServiceRegistration registration;
    public String name;
    public ServiceComponent serviceComponent;
    public Hashtable properties;
    public Vector instances = new Vector(2);
    public BundleContext bc;
    public Vector references;
    protected boolean isComponentFactory = false;
    private int state = 2;
    protected Vector delayActivateSCPNames;
    private SCRManager mgr;
    private static long componentid = 0L;
    boolean locked = false;
    int waiting = 0;
    Bundle bundle;
    Object inst;

    public ServiceComponentProp(ServiceComponent serviceComponent, Dictionary configProperties, SCRManager mgr) {
        this.serviceComponent = serviceComponent;
        this.name = serviceComponent.name;
        this.bc = serviceComponent.bc;
        this.initProperties(configProperties);
        this.isComponentFactory = serviceComponent.factory != null;
        this.mgr = mgr;
    }

    public void dispose() {
        if (Activator.DEBUG) {
            Activator.log.debug(0, 10035, this.name, null, false);
        }
        this.setState(0);
        while (!this.instances.isEmpty()) {
            ComponentInstanceImpl current = (ComponentInstanceImpl)this.instances.firstElement();
            this.dispose(current);
            current.dispose();
        }
    }

    public Hashtable getProperties() {
        return this.properties != null ? this.properties : this.serviceComponent.properties;
    }

    public void activate(Bundle usingBundle, ComponentInstanceImpl componentInstance) throws Exception {
        if (Activator.DEBUG) {
            Activator.log.debug(0, 10036, this.name, null, false);
            Activator.log.debug(0, 10039, usingBundle != null ? usingBundle.getSymbolicName() : null, null, false);
            Activator.log.debug(0, 10037, componentInstance.toString(), null, false);
        }
        this.serviceComponent.activate(componentInstance.getInstance(), componentInstance.getComponentContext());
    }

    private void deactivate(ComponentInstanceImpl componentInstance) {
        if (Activator.DEBUG) {
            Activator.log.debug(0, 10038, this.name, null, false);
        }
        this.serviceComponent.deactivate(componentInstance.getInstance(), componentInstance.getComponentContext());
    }

    public void bind(ComponentInstance componentInstance) throws Exception {
        if (this.references != null) {
            int i = 0;
            while (i < this.references.size()) {
                Reference ref = (Reference)this.references.elementAt(i);
                this.bindReference(ref, componentInstance);
                if (ref.reference.bind == null && Activator.DEBUG) {
                    Activator.log.debug(0, 10040, ref.reference.name, null, false);
                }
                ++i;
            }
        }
    }

    public void unbind(ComponentInstance componentInstance) {
        if (this.references != null) {
            int i = this.references.size() - 1;
            while (i >= 0) {
                Reference ref = (Reference)this.references.elementAt(i);
                if (ref.reference.unbind != null) {
                    this.unbindReference(ref, componentInstance);
                }
                --i;
            }
        }
    }

    public Object createInstance() throws Exception {
        this.assertCreateSingleInstance();
        return this.serviceComponent.createInstance();
    }

    synchronized void lock(Bundle usingBundle, Object instance) {
        while (this.locked) {
            try {
                ++this.waiting;
                this.wait();
            }
            catch (Exception exception) {}
            --this.waiting;
        }
        this.locked = true;
        this.bundle = usingBundle;
        this.inst = instance;
    }

    synchronized void unlock() {
        this.locked = false;
        this.bundle = null;
        this.inst = null;
        if (this.waiting > 0) {
            this.notifyAll();
        }
    }

    public Object run() throws Exception {
        Bundle bundle = this.bundle;
        Object instance = this.inst;
        this.unlock();
        return this.build(bundle, instance, false);
    }

    public ComponentInstanceImpl build(Bundle usingBundle, Object instance, boolean security) throws Exception {
        if (this.getState() == 0) {
            if (Activator.DEBUG) {
                Activator.log.debug("Cannot build component, because it is already disposed: " + this, null);
            }
            return null;
        }
        if (security) {
            this.lock(usingBundle, instance);
            try {
                return (ComponentInstanceImpl)AccessController.doPrivileged(this);
            }
            catch (PrivilegedActionException privilegedActionException) {}
        }
        ComponentInstanceImpl componentInstance = null;
        if (instance == null) {
            if (!this.serviceComponent.serviceFactory) {
                if (this.instances.isEmpty()) {
                    instance = this.createInstance();
                } else {
                    componentInstance = (ComponentInstanceImpl)this.instances.firstElement();
                }
            } else {
                instance = this.createInstance();
            }
        }
        if (componentInstance == null) {
            componentInstance = new ComponentInstanceImpl(instance, this);
            componentInstance.setComponentContext(new ComponentContextImpl(this, usingBundle, componentInstance, this.mgr));
            this.instances.addElement(componentInstance);
            this.bind(componentInstance);
            try {
                this.activate(usingBundle, componentInstance);
            }
            catch (Exception e) {
                InstanceProcess.resolver.removeFromSatisfiedList(this);
                if (this.instances.removeElement(componentInstance)) {
                    this.unbind(componentInstance);
                }
                throw e;
            }
        }
        return componentInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeObj(Object obj) {
        ComponentInstanceImpl ci = null;
        Vector vector = this.instances;
        synchronized (vector) {
            int i = 0;
            while (i < this.instances.size()) {
                ci = (ComponentInstanceImpl)this.instances.elementAt(i);
                if (ci.getInstance() == obj) break;
                ci = null;
                ++i;
            }
        }
        if (ci != null) {
            this.dispose(ci);
            return;
        }
        throw new RuntimeException("The Object '" + obj + "' is not created by the component named " + this.name);
    }

    public void dispose(ComponentInstanceImpl componentInstance) {
        if (!this.instances.removeElement(componentInstance)) {
            return;
        }
        this.deactivate(componentInstance);
        this.unbind(componentInstance);
    }

    public void bindReference(Reference reference, ComponentInstance componentInstance) throws Exception {
        if (Activator.DEBUG) {
            Activator.log.debug(0, 10041, String.valueOf(this.serviceComponent.name) + " -> " + reference.reference, null, false);
        }
        ServiceReference[] serviceReferences = null;
        try {
            serviceReferences = this.bc.getServiceReferences(reference.reference.interfaceName, reference.reference.target);
        }
        catch (Exception e) {
            Activator.log.error("[SCR] Cannot get references for " + reference.reference.interfaceName, (Throwable)e);
            throw e;
        }
        if (serviceReferences != null && serviceReferences.length > 0) {
            if (reference.reference.bind != null) {
                switch (reference.reference.cardinality) {
                    case 0: 
                    case 2: {
                        reference.reference.bind(reference, componentInstance, serviceReferences[0]);
                        break;
                    }
                    case 1: 
                    case 3: {
                        int i = 0;
                        while (i < serviceReferences.length) {
                            reference.reference.bind(reference, componentInstance, serviceReferences[i]);
                            ++i;
                        }
                        break block1;
                    }
                }
            } else if (reference.reference.policy == 0) {
                reference.setBoundServiceReferences(serviceReferences);
            }
        } else if (Activator.DEBUG) {
            Activator.log.debug("ServiceComponentProp.bindReference(): The service is not yet registered, but it is already instantiated", null);
        }
    }

    public void unbindReference(Reference reference, ComponentInstance componentInstance) {
        if (reference.reference.unbind == null) {
            return;
        }
        if (Activator.DEBUG) {
            Activator.log.debug(0, 10042, String.valueOf(this.serviceComponent.name) + " <- " + reference.reference, null, false);
        }
        Enumeration serviceReferences = reference.reference.serviceReferences.keys();
        while (serviceReferences.hasMoreElements()) {
            reference.reference.unbind(reference, componentInstance, (ServiceReference)serviceReferences.nextElement());
        }
    }

    public void unbindDynamicReference(Reference ref, ComponentInstance instance, ServiceReference serviceReference) throws Exception {
        if (Activator.DEBUG) {
            Activator.log.debug("ServiceComponentProp.unbindDynamicReference(): component = " + this.name + ", reference = " + ref.reference.name, null);
        }
        switch (ref.reference.cardinality) {
            case 0: 
            case 2: {
                if (ref.reference.bind == null) break;
                this.bindReference(ref, instance);
            }
        }
        ref.reference.unbind(ref, instance, serviceReference);
    }

    private void initProperties(Dictionary configProperties) {
        Properties propertyDescriptions = this.serviceComponent.properties;
        if (propertyDescriptions != null && !propertyDescriptions.isEmpty()) {
            this.properties = (Hashtable)propertyDescriptions.clone();
        }
        if (this.properties == null) {
            this.properties = new Hashtable(7);
        }
        if (this.serviceComponent.references != null) {
            int i = 0;
            while (i < this.serviceComponent.references.size()) {
                ComponentReference ref = (ComponentReference)this.serviceComponent.references.elementAt(i);
                if (ref.target != null) {
                    this.properties.put(String.valueOf(ref.name) + ".target", ref.target);
                }
                ++i;
            }
        }
        if (configProperties != null && !configProperties.isEmpty()) {
            Enumeration keys = configProperties.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object val = configProperties.get(key);
                this.properties.put(key, val);
            }
        }
        Long nextId = new Long(ServiceComponentProp.getNewComponentID());
        this.properties.put("component.id", nextId);
        this.properties.put("component.name", this.serviceComponent.name);
        if (this.serviceComponent.provides != null) {
            String[] provides = new String[this.serviceComponent.provides.length];
            System.arraycopy(this.serviceComponent.provides, 0, provides, 0, provides.length);
            this.properties.put("objectClass", provides);
        }
    }

    private void assertCreateSingleInstance() {
        if (!this.serviceComponent.serviceFactory && !this.instances.isEmpty()) {
            throw new ComponentException("Instance of '" + this.name + "'is already created!");
        }
    }

    public String toString() {
        return this.name;
    }

    public void setRegistration(ServiceRegistration reg) {
        this.registration = reg;
    }

    public void setDelayActivateSCPName(String scpName) {
        if (Activator.DEBUG) {
            Activator.log.debug("Setting delay activate SCP: " + scpName, null);
        }
        if (this.delayActivateSCPNames == null) {
            this.delayActivateSCPNames = new Vector(1);
            this.delayActivateSCPNames.addElement(scpName);
        } else if (!this.delayActivateSCPNames.contains(scpName)) {
            this.delayActivateSCPNames.addElement(scpName);
        }
    }

    public Vector getDelayActivateSCPNames() {
        return this.delayActivateSCPNames;
    }

    public boolean isComponentFactory() {
        return this.isComponentFactory;
    }

    public void setComponentFactory(boolean isComponentFactory) {
        this.isComponentFactory = isComponentFactory;
    }

    static synchronized long getNewComponentID() {
        return componentid++;
    }

    public boolean isKindOfFactory() {
        return this.serviceComponent.serviceFactory;
    }

    public synchronized int getState() {
        return this.state;
    }

    public synchronized void setState(int state) {
        this.state = state;
    }
}

