/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.factory;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.communication.core.IRemoteServiceReference;
import org.eclipse.riena.communication.core.IRemoteServiceRegistration;
import org.eclipse.riena.communication.core.IRemoteServiceRegistry;
import org.eclipse.riena.communication.core.RemoteServiceDescription;
import org.eclipse.riena.communication.core.factory.IRemoteServiceFactory;
import org.eclipse.riena.communication.core.factory.IRemoteServiceFactoryProperties;
import org.eclipse.riena.core.RienaStatus;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.core.util.VariableManagerUtil;
import org.eclipse.riena.internal.communication.core.Activator;
import org.eclipse.riena.internal.communication.core.factory.CallHooksProxy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteServiceFactory {
    private static IRemoteServiceRegistry registry;
    private static final Logger LOGGER;
    private static HashMap<String, IRemoteServiceFactory> remoteServiceFactoryImplementations;

    static {
        LOGGER = Activator.getDefault().getLogger(RemoteServiceFactory.class);
        remoteServiceFactoryImplementations = null;
    }

    public RemoteServiceFactory() {
        if (registry == null) {
            Inject.service((String)IRemoteServiceRegistry.class.getName()).useRanking().into((Object)this).andStart(Activator.getDefault().getContext());
        }
        if (remoteServiceFactoryImplementations == null) {
            Inject.extension((String)"org.eclipse.riena.communication.core.remoteservicefactory").into((Object)this).andStart(Activator.getDefault().getContext());
        }
    }

    public void bind(IRemoteServiceRegistry registryParm) {
        registry = registryParm;
    }

    public void unbind(IRemoteServiceRegistry registryParm) {
        if (registry == registryParm) {
            registry = null;
        }
    }

    public void update(IRemoteServiceFactoryProperties[] factories) {
        remoteServiceFactoryImplementations = new HashMap();
        IRemoteServiceFactoryProperties[] iRemoteServiceFactoryPropertiesArray = factories;
        int n = factories.length;
        int n2 = 0;
        while (n2 < n) {
            IRemoteServiceFactoryProperties factory = iRemoteServiceFactoryPropertiesArray[n2];
            remoteServiceFactoryImplementations.put(factory.getProtocol(), factory.createRemoteServiceFactory());
            ++n2;
        }
    }

    public IRemoteServiceRegistration createAndRegisterProxy(Class<?> interfaceClass, String url, String protocol, BundleContext context) {
        RemoteServiceDescription rsd = this.createDescription(interfaceClass, url, protocol);
        return this.createAndRegisterProxy(rsd, context);
    }

    public IRemoteServiceRegistration createAndRegisterProxy(RemoteServiceDescription rsDesc, BundleContext context) {
        IRemoteServiceReference rsRef = this.createProxy(rsDesc);
        if (rsRef == null) {
            rsRef = this.createLazyProxy(rsDesc);
        }
        if (rsRef == null) {
            LOGGER.log(1, "could not create serviceInstance (neither serviceInstance nor lazy serviceInstance) for " + rsDesc);
            return null;
        }
        if (registry != null) {
            IRemoteServiceRegistration reg = registry.registerService(rsRef, context);
            return reg;
        }
        return null;
    }

    public IRemoteServiceReference createProxy(Class<?> interfaceClass, String url, String protocol) {
        RemoteServiceDescription rsd = this.createDescription(interfaceClass, url, protocol);
        return this.createProxy(rsd);
    }

    private RemoteServiceDescription createDescription(Class<?> interfaceClass, String url, String protocol) {
        RemoteServiceDescription rsd = new RemoteServiceDescription();
        rsd.setServiceInterfaceClass(interfaceClass);
        rsd.setServiceInterfaceClassName(interfaceClass.getName());
        rsd.setURL(url);
        rsd.setProtocol(protocol);
        return rsd;
    }

    public IRemoteServiceReference createProxy(RemoteServiceDescription rsd) {
        if (!RienaStatus.isActive()) {
            LOGGER.log(2, "riena.core is not started. This will probably not work.");
        }
        try {
            rsd.setURL(VariableManagerUtil.substitute((String)rsd.getURL()));
        }
        catch (CoreException e) {
            LOGGER.log(1, "Could not substitute url '" + rsd.getURL() + "'.", (Throwable)e);
            return null;
        }
        if (rsd.getProtocol() == null) {
            return null;
        }
        IRemoteServiceFactory factory = null;
        factory = remoteServiceFactoryImplementations.get(rsd.getProtocol());
        if (factory == null) {
            LOGGER.log(2, "no IRemoteServiceFactory extension available protocol [" + rsd.getProtocol() + "] id [" + rsd.getServiceInterfaceClassName() + "]");
            return null;
        }
        LOGGER.log(3, "found protocol [" + rsd.getProtocol() + "] " + factory);
        IRemoteServiceReference rsr = factory.createProxy(rsd);
        CallHooksProxy callHooksProxy = new CallHooksProxy(rsr.getServiceInstance());
        callHooksProxy.setRemoteServiceDescription(rsd);
        callHooksProxy.setMessageContextAccessor(factory.getMessageContextAccessor());
        rsr.setServiceInstance(Proxy.newProxyInstance(rsd.getServiceInterfaceClass().getClassLoader(), new Class[]{rsd.getServiceInterfaceClass()}, (InvocationHandler)callHooksProxy));
        return rsr;
    }

    private IRemoteServiceReference createLazyProxy(RemoteServiceDescription rsd) {
        try {
            LazyProxyHandler lazyProxyHandler = new LazyProxyHandler(rsd);
            Class<?> serviceClass = RemoteServiceFactory.class.getClassLoader().loadClass(rsd.getServiceInterfaceClassName());
            Object serviceInstance = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{serviceClass}, (InvocationHandler)lazyProxyHandler);
            LazyRemoteServiceReference ref = new LazyRemoteServiceReference(serviceInstance, rsd.getServiceInterfaceClassName(), rsd);
            LazyProxyBuilder proxyBuilder = new LazyProxyBuilder(rsd, ref, lazyProxyHandler);
            String filter = "(riena.protocol=" + rsd.getProtocol() + ")";
            Inject.service((String)IRemoteServiceFactory.class.getName()).useFilter(filter).into((Object)proxyBuilder).andStart(Activator.getDefault().getContext());
            return ref;
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(1, "Could not load service interface class '" + rsd.getServiceInterfaceClassName() + "'.", (Throwable)e);
            return null;
        }
    }

    public Class<?> loadClass(String interfaceClassName) throws ClassNotFoundException {
        return this.getClass().getClassLoader().loadClass(interfaceClassName);
    }

    public class LazyProxyBuilder {
        private RemoteServiceDescription rsd;
        private LazyRemoteServiceReference lazyRef;
        private LazyProxyHandler lazyProxyHandler;

        protected LazyProxyBuilder(RemoteServiceDescription rsd, LazyRemoteServiceReference ref, LazyProxyHandler lazyProxyHandler) {
            this.rsd = rsd;
            this.lazyRef = ref;
            this.lazyProxyHandler = lazyProxyHandler;
        }

        public void bind(IRemoteServiceFactory factory) {
            if (this.rsd != null) {
                IRemoteServiceReference ref = RemoteServiceFactory.this.createProxy(this.rsd);
                Object proxyInstance = ref.getServiceInstance();
                this.lazyProxyHandler.setDelegateHandler(Proxy.getInvocationHandler(proxyInstance));
                this.lazyRef.setDelegateRef(ref);
                this.rsd = null;
            }
        }

        public void unbind(IRemoteServiceFactory factory) {
        }
    }

    static class LazyProxyHandler
    implements InvocationHandler {
        private InvocationHandler delegateHandler;
        private RemoteServiceDescription rsd;

        protected LazyProxyHandler(RemoteServiceDescription rsd) {
            this.rsd = rsd;
        }

        public void setDelegateHandler(InvocationHandler delegateHandler) {
            this.delegateHandler = delegateHandler;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.delegateHandler == null) {
                throw new RuntimeException("LazyProxy: missing IRemoteServiceFactory to create proxy for protocol=" + this.rsd.getProtocol() + " url=" + this.rsd.getURL() + " interface=" + this.rsd.getServiceInterfaceClassName());
            }
            return this.delegateHandler.invoke(proxy, method, args);
        }
    }

    static class LazyRemoteServiceReference
    implements IRemoteServiceReference {
        private Object serviceInstance;
        private String serviceClass;
        private IRemoteServiceReference delegateReference;
        private BundleContext tempBundleContext;
        private RemoteServiceDescription rsd;
        private ServiceRegistration serviceRegistration;

        protected LazyRemoteServiceReference(Object serviceInstance, String serviceClass, RemoteServiceDescription rsd) {
            this.serviceInstance = serviceInstance;
            this.serviceClass = serviceClass;
            this.rsd = rsd;
        }

        public void setDelegateRef(IRemoteServiceReference delegateRef) {
            this.delegateReference = delegateRef;
            if (this.tempBundleContext != null) {
                delegateRef.setContext(this.tempBundleContext);
            }
        }

        public void dispose() {
            if (this.delegateReference != null) {
                this.delegateReference.dispose();
            }
        }

        public boolean equals(Object obj) {
            if (this.delegateReference != null) {
                return this.delegateReference.equals(obj);
            }
            return false;
        }

        public RemoteServiceDescription getDescription() {
            if (this.delegateReference == null) {
                return this.rsd;
            }
            return this.delegateReference.getDescription();
        }

        public BundleContext getContext() {
            if (this.delegateReference == null) {
                return this.tempBundleContext;
            }
            return this.delegateReference.getContext();
        }

        public Object getServiceInstance() {
            if (this.delegateReference == null) {
                return this.serviceInstance;
            }
            return this.delegateReference.getServiceInstance();
        }

        public String getServiceInterfaceClassName() {
            if (this.delegateReference == null) {
                return this.serviceClass;
            }
            return this.delegateReference.getServiceInterfaceClassName();
        }

        public ServiceRegistration getServiceRegistration() {
            return this.serviceRegistration;
        }

        public String getURL() {
            if (this.delegateReference != null) {
                return this.delegateReference.getURL();
            }
            return null;
        }

        public int hashCode() {
            if (this.delegateReference != null) {
                return this.delegateReference.hashCode();
            }
            return this.getClass().hashCode();
        }

        public void setContext(BundleContext context) {
            if (this.delegateReference == null) {
                this.tempBundleContext = context;
            } else {
                this.delegateReference.setContext(context);
            }
        }

        public void setServiceInstance(Object serviceInstance) {
            if (this.delegateReference == null) {
                throw new RuntimeException("trying to set serviceInstance for lazyRemoteServiceReference with no delegate");
            }
            this.delegateReference.setServiceInstance(serviceInstance);
        }

        public void setServiceRegistration(ServiceRegistration serviceRegistration) {
            this.serviceRegistration = serviceRegistration;
        }

        public String toString() {
            if (this.delegateReference != null) {
                return this.delegateReference.toString();
            }
            String symbolicName = "no context";
            if (this.tempBundleContext != null) {
                symbolicName = this.tempBundleContext.getBundle().getSymbolicName();
            }
            return "(lazyreference) context for bundle=" + symbolicName + ", end point=(" + this.getDescription() + ")";
        }
    }
}

