/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.beans.common;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.ui.common.IComboEntryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersonManager
implements IComboEntryFactory {
    public static final String PROPERTY_SELECTED_PERSON = "selectedPerson";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Collection<Person> persons;
    private Person selectedPerson;

    public PersonManager(Collection<Person> persons) {
        this.setPersons(persons);
    }

    public void addPropertyChangeListener(String p, PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(p, l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(String p, PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(p, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public Collection<Person> getPersons() {
        return this.persons;
    }

    public void setPersons(Collection<Person> persons) {
        this.persons = persons;
    }

    public Person createNewEntry(Object listEntryString) {
        if (listEntryString instanceof String) {
            Person person;
            StringTokenizer t = new StringTokenizer((String)listEntryString, ",");
            switch (t.countTokens()) {
                case 0: {
                    person = new Person("", "");
                    break;
                }
                case 1: {
                    person = new Person(t.nextToken().trim(), "");
                    break;
                }
                case 2: {
                    person = new Person(t.nextToken().trim(), t.nextToken().trim());
                    break;
                }
                default: {
                    person = new Person("", "");
                }
            }
            return person;
        }
        return null;
    }

    public Person getSelectedPerson() {
        return this.selectedPerson;
    }

    public void setSelectedPerson(Person newSelection) {
        Person oldSelection = this.selectedPerson;
        this.selectedPerson = newSelection;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_SELECTED_PERSON, oldSelection, newSelection);
    }
}

