/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.publisher.hessian;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.SerializerFactory;
import com.caucho.hessian.server.HessianSkeleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.communication.publisher.hessian.IAbstractSerializerFactory;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.communication.publisher.hessian.Activator;
import org.eclipse.riena.internal.communication.publisher.hessian.HessianRemoteServicePublisher;
import org.eclipse.riena.internal.communication.publisher.hessian.MessageContext;
import org.eclipse.riena.internal.communication.publisher.hessian.MessageContextAccessor;
import org.eclipse.riena.internal.core.exceptionmanager.ExceptionHandlerManagerAccessor;

public class RienaHessianDispatcherServlet
extends GenericServlet {
    private SerializerFactory serializerFactory = null;
    private static final Logger LOGGER = Activator.getDefault().getLogger(RienaHessianDispatcherServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.serializerFactory = new SerializerFactory();
        this.serializerFactory.setAllowNonSerializable(true);
        this.removeInputStreamSerializerDeserializer(this.serializerFactory);
        Inject.extension((String)"org.eclipse.riena.communication.hessian.AbstractSerializerFactory").into((Object)this).update("setFactory").andStart(Activator.getDefault().getContext());
        LOGGER.log(4, "initialized");
    }

    public void setFactory(IAbstractSerializerFactory[] factories) {
        IAbstractSerializerFactory[] iAbstractSerializerFactoryArray = factories;
        int n = factories.length;
        int n2 = 0;
        while (n2 < n) {
            IAbstractSerializerFactory factory = iAbstractSerializerFactoryArray[n2];
            this.serializerFactory.addFactory(factory.createImplementation());
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        block16: {
            httpReq = (HttpServletRequest)req;
            httpRes = (HttpServletResponse)res;
            MessageContextAccessor.setMessageContext(new MessageContext(httpReq, httpRes));
            publisher = this.getPublisher();
            if (publisher == null) {
                if (httpReq.getMethod().equals("GET")) {
                    if (httpReq.getRemoteHost().equals("127.0.0.1")) {
                        pw = new PrintWriter((OutputStream)res.getOutputStream());
                        pw.write("no webservices available");
                        pw.flush();
                        pw.close();
                        return;
                    }
                    httpRes.sendError(405, "Hessian requires POST");
                    return;
                }
                httpRes.sendError(404, "webservice not found");
                return;
            }
            requestURI = httpReq.getRequestURI();
            contextPath = httpReq.getContextPath();
            if (contextPath.length() > 1) {
                requestURI = requestURI.substring(contextPath.length());
            }
            rsd = publisher.findService(requestURI);
            this.log("call " + rsd);
            if (httpReq.getMethod().equals("GET")) {
                if (httpReq.getRemoteHost().equals("127.0.0.1")) {
                    pw = new PrintWriter((OutputStream)res.getOutputStream());
                    if (rsd == null) {
                        pw.write("call received from browser, no remote service registered with this URL");
                    } else {
                        pw.write("calls " + rsd);
                    }
                    pw.flush();
                    pw.close();
                    return;
                }
                httpRes.sendError(405, "Hessian requires POST");
                return;
            }
            if (rsd == null) {
                httpRes.sendError(404, "unknown url :" + httpReq.getRequestURI());
                return;
            }
            instance = rsd.getService();
            sk = new HessianSkeleton(instance, rsd.getServiceInterfaceClass());
            inp = new Hessian2Input((InputStream)httpReq.getInputStream());
            inp.setSerializerFactory(this.serializerFactory);
            code = inp.read();
            if (code != 99) {
                throw new IOException("expected 'c' in hessian input at " + code);
            }
            major = inp.read();
            inp.read();
            out /* !! */  = major >= 2 ? new Hessian2Output((OutputStream)httpRes.getOutputStream()) : new HessianOutput((OutputStream)httpRes.getOutputStream());
            out /* !! */ .setSerializerFactory(this.serializerFactory);
            try {
                try {
                    sk.invoke((AbstractHessianInput)inp, (AbstractHessianOutput)out /* !! */ );
                    break block16;
                }
                catch (Throwable t) {
                    t2 = t;
                    ** while (t2.getCause() != null)
                }
lbl-1000:
                // 1 sources

                {
                    t2 = t2.getCause();
                    continue;
                }
lbl59:
                // 1 sources

                RienaHessianDispatcherServlet.LOGGER.log(1, t.getMessage(), t2);
                ExceptionHandlerManagerAccessor.getExceptionHandlerManager().handleException(t2);
                throw new ServletException(t);
            }
            finally {
                out /* !! */ .close();
            }
        }
    }

    private void removeInputStreamSerializerDeserializer(SerializerFactory serializerFactory) {
        HashMap staticDeSerMap = (HashMap)ReflectionUtils.getHidden(serializerFactory.getClass(), (String)"_staticDeserializerMap");
        staticDeSerMap.remove(InputStream.class);
        HashMap staticSerMap = (HashMap)ReflectionUtils.getHidden(serializerFactory.getClass(), (String)"_staticSerializerMap");
        staticSerMap.remove(InputStream.class);
    }

    protected HessianRemoteServicePublisher getPublisher() {
        return Activator.getDefault().getPublisher();
    }
}

