/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log.internal;

import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.equinox.log.internal.EventAdminAdapter;
import org.eclipse.equinox.log.internal.ExtendedLogReaderServiceFactory;
import org.eclipse.equinox.log.internal.ExtendedLogServiceFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.LogService;

public class Activator
implements BundleActivator {
    private static final String EVENT_ADMIN_CLASS = "org.osgi.service.event.EventAdmin";
    private static final String[] LOGSERVICE_CLASSES = new String[]{LogService.class.getName(), ExtendedLogService.class.getName()};
    private static final String[] LOGREADERSERVICE_CLASSES = new String[]{LogReaderService.class.getName(), ExtendedLogReaderService.class.getName()};
    private ServiceRegistration logReaderServiceRegistration;
    private ServiceRegistration logServiceRegistration;
    private EventAdminAdapter eventAdminAdapter;

    public void start(BundleContext context) throws Exception {
        ExtendedLogReaderServiceFactory logReaderServiceFactory = new ExtendedLogReaderServiceFactory();
        if (Activator.checkEventAdmin()) {
            this.eventAdminAdapter = new EventAdminAdapter(context, logReaderServiceFactory);
            this.eventAdminAdapter.start();
        }
        ExtendedLogServiceFactory logServiceFactory = new ExtendedLogServiceFactory(logReaderServiceFactory);
        this.logReaderServiceRegistration = context.registerService(LOGREADERSERVICE_CLASSES, (Object)logReaderServiceFactory, null);
        this.logServiceRegistration = context.registerService(LOGSERVICE_CLASSES, (Object)logServiceFactory, null);
    }

    public void stop(BundleContext context) throws Exception {
        this.logServiceRegistration.unregister();
        this.logServiceRegistration = null;
        this.logReaderServiceRegistration.unregister();
        if (this.eventAdminAdapter != null) {
            this.eventAdminAdapter.stop();
            this.eventAdminAdapter = null;
        }
        this.logReaderServiceRegistration = null;
    }

    private static boolean checkEventAdmin() {
        try {
            Class.forName(EVENT_ADMIN_CLASS);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

