/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.service;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.riena.core.service.ServiceDescriptor;
import org.eclipse.riena.core.service.ServiceInjector;
import org.osgi.framework.ServiceReference;

public class RankingInjector
extends ServiceInjector {
    private ServiceReference trackedServiceRef = null;

    RankingInjector(ServiceDescriptor serviceId, Object target) {
        super(serviceId, target);
    }

    protected void doStart() {
        ServiceReference serviceRef = this.getCurrentHighest();
        this.registerServiceListener();
        this.doBind(serviceRef);
    }

    protected void doStop() {
        this.invokeUnbindMethod(this.trackedServiceRef);
        this.trackedServiceRef = null;
    }

    protected void doBind(ServiceReference serviceRef) {
        if (serviceRef == null) {
            return;
        }
        if (this.trackedServiceRef != null && serviceRef.compareTo((Object)this.trackedServiceRef) > 0) {
            return;
        }
        this.invokeUnbindMethod(this.trackedServiceRef);
        this.invokeBindMethod(serviceRef);
        this.trackedServiceRef = serviceRef;
    }

    protected void doUnbind(ServiceReference serviceRef) {
        if (serviceRef == null) {
            return;
        }
        if (serviceRef.compareTo((Object)this.trackedServiceRef) != 0) {
            return;
        }
        this.invokeUnbindMethod(serviceRef);
        ServiceReference highest = this.getCurrentHighest();
        if (highest == null) {
            this.trackedServiceRef = null;
            return;
        }
        this.invokeBindMethod(highest);
        this.trackedServiceRef = highest;
    }

    private ServiceReference getCurrentHighest() {
        ServiceReference[] serviceRefs = this.getServiceReferences();
        return RankingInjector.highestServiceRef(serviceRefs);
    }

    private static ServiceReference highestServiceRef(ServiceReference[] serviceRefs) {
        if (serviceRefs == null) {
            return null;
        }
        if (serviceRefs.length == 1) {
            return serviceRefs[0];
        }
        Arrays.sort(serviceRefs, new ObjectRankingComparator());
        return serviceRefs[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ObjectRankingComparator
    implements Comparator<ServiceReference> {
        private ObjectRankingComparator() {
        }

        @Override
        public int compare(ServiceReference sr1, ServiceReference sr2) {
            return sr1.compareTo((Object)sr2);
        }
    }
}

