/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonManager;
import org.eclipse.riena.beans.common.StringManager;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.ComboRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.tests.UITestHelper;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.swt.uibinding.DefaultSwtControlRidgetMapper;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboRidgetTest
extends AbstractSWTRidgetTest {
    private PersonManager manager;
    private Person selection1;
    private Person selection2;
    private Person selection3;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.manager = new PersonManager(this.createPersonList());
        Iterator it = this.manager.getPersons().iterator();
        this.selection1 = (Person)it.next();
        this.selection2 = (Person)it.next();
        this.selection3 = (Person)it.next();
    }

    protected Control createWidget(Composite parent) {
        return new Combo(parent, 8);
    }

    @Override
    protected IRidget createRidget() {
        return new ComboRidget();
    }

    protected Combo getWidget() {
        return (Combo)super.getWidget();
    }

    protected ComboRidget getRidget() {
        return (ComboRidget)super.getRidget();
    }

    public void testRidgetMapping() {
        DefaultSwtControlRidgetMapper mapper = new DefaultSwtControlRidgetMapper();
        ComboRidgetTest.assertSame(ComboRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testSetUIControl() {
        ComboRidget ridget = this.getRidget();
        ridget.setUIControl(null);
        ComboRidgetTest.assertNull((Object)ridget.getUIControl());
        ridget.setUIControl((Object)this.getWidget());
        ComboRidgetTest.assertSame((Object)this.getWidget(), (Object)ridget.getUIControl());
    }

    public void testSetUIControlInvalid() {
        ComboRidget ridget = this.getRidget();
        try {
            ridget.setUIControl((Object)this.getShell());
            ComboRidgetTest.fail();
        }
        catch (BindingException bindingException) {
            this.ok();
        }
        try {
            ridget.setUIControl((Object)new Combo((Composite)this.getShell(), 0));
            ComboRidgetTest.fail();
        }
        catch (BindingException bindingException) {
            this.ok();
        }
    }

    public void testGetEmptySelectionItem() {
        ComboRidget ridget = this.getRidget();
        Combo control = this.getWidget();
        StringManager aManager = new StringManager(new String[]{"A", "B", "C", "D", "E"});
        ridget.bindToModel((Object)aManager, "items", String.class, null, (Object)aManager, "selectedItem");
        ridget.updateFromModel();
        ComboRidgetTest.assertNull((Object)ridget.getEmptySelectionItem());
        String emptySelectionItem = "A";
        ridget.setEmptySelectionItem((Object)emptySelectionItem);
        ComboRidgetTest.assertSame((Object)emptySelectionItem, (Object)ridget.getEmptySelectionItem());
        ridget.setSelection((Object)"A");
        int controlSelectedItem = control.getSelectionIndex();
        ComboRidgetTest.assertEquals((int)-1, (int)ridget.getSelectionIndex());
        ComboRidgetTest.assertEquals((int)0, (int)controlSelectedItem);
        ComboRidgetTest.assertEquals(null, (Object)ridget.getSelection());
        ComboRidgetTest.assertEquals((String)"A", (String)control.getItem(controlSelectedItem));
    }

    public void testBindToModelWithDomainObjects() {
        this.manager.setSelectedPerson(this.selection1);
        ComboRidget ridget = this.getRidget();
        Combo control = this.getWidget();
        ComboRidgetTest.assertEquals(null, (String)this.getSelectedString(control));
        ComboRidgetTest.assertEquals((int)0, (int)control.getItemCount());
        ridget.bindToModel((Object)this.manager, "persons", String.class, null, (Object)this.manager, "selectedPerson");
        ComboRidgetTest.assertEquals(null, (String)this.getSelectedString(control));
        ComboRidgetTest.assertEquals((int)0, (int)control.getItemCount());
        ridget.updateFromModel();
        ComboRidgetTest.assertEquals((String)this.selection1.toString(), (String)this.getSelectedString(control));
        ComboRidgetTest.assertEquals((int)this.manager.getPersons().size(), (int)control.getItemCount());
        int i = 0;
        while (i < control.getItemCount()) {
            String item = control.getItem(i);
            if (!this.find(this.manager, item)) {
                ComboRidgetTest.fail();
            }
            ++i;
        }
        this.manager.setSelectedPerson(this.selection2);
        ComboRidgetTest.assertEquals((String)this.selection1.toString(), (String)this.getSelectedString(control));
        ridget.updateFromModel();
        ComboRidgetTest.assertEquals((String)this.selection2.toString(), (String)this.getSelectedString(control));
        control.select(2);
        ComboRidgetTest.assertEquals((String)this.selection3.toString(), (String)this.getSelectedString(control));
    }

    public void testBindToModelWithDomainObjectsUsingColumnPropertyName() {
        this.manager.setSelectedPerson(this.selection1);
        ComboRidget ridget = this.getRidget();
        Combo control = this.getWidget();
        ComboRidgetTest.assertEquals(null, (String)this.getSelectedString(control));
        ComboRidgetTest.assertEquals((int)0, (int)control.getItemCount());
        ridget.bindToModel((Object)this.manager, "persons", String.class, "getListEntry", (Object)this.manager, "selectedPerson");
        ComboRidgetTest.assertEquals(null, (String)this.getSelectedString(control));
        ComboRidgetTest.assertEquals((int)0, (int)control.getItemCount());
        ridget.updateFromModel();
        ComboRidgetTest.assertEquals((String)this.selection1.getListEntry(), (String)this.getSelectedString(control));
        ComboRidgetTest.assertEquals((String)this.selection1.getListEntry(), (String)control.getText());
        this.checkPersonList(this.manager);
        ComboRidgetTest.assertEquals((Object)this.selection1, (Object)this.manager.getSelectedPerson());
        this.manager.setSelectedPerson(this.selection2);
        ComboRidgetTest.assertEquals((String)this.selection1.getListEntry(), (String)this.getSelectedString(control));
        ComboRidgetTest.assertEquals((String)this.selection1.getListEntry(), (String)control.getText());
        ComboRidgetTest.assertEquals((Object)this.selection2, (Object)this.manager.getSelectedPerson());
        ridget.updateFromModel();
        ComboRidgetTest.assertEquals((Object)this.selection2, (Object)this.manager.getSelectedPerson());
        ComboRidgetTest.assertEquals((String)this.selection2.getListEntry(), (String)this.getSelectedString(control));
        ComboRidgetTest.assertEquals((String)this.selection2.getListEntry(), (String)control.getText());
        control.select(2);
        ComboRidgetTest.assertEquals((String)this.selection3.getListEntry(), (String)this.getSelectedString(control));
        ComboRidgetTest.assertEquals((String)this.selection3.getListEntry(), (String)control.getText());
        ComboRidgetTest.assertEquals((Object)this.selection3, (Object)this.manager.getSelectedPerson());
    }

    public void testBindToModelWithStrings() {
        StringManager aManager = new StringManager(new String[]{"A", "B", "C", "D", "E"});
        Iterator it = aManager.getItems().iterator();
        String aSelection1 = (String)it.next();
        String aSelection2 = (String)it.next();
        String aSelection3 = (String)it.next();
        aManager.setSelectedItem(aSelection1);
        ComboRidget ridget = this.getRidget();
        Combo control = this.getWidget();
        ComboRidgetTest.assertEquals((int)-1, (int)control.getSelectionIndex());
        ComboRidgetTest.assertEquals((int)0, (int)control.getItemCount());
        ridget.bindToModel((Object)aManager, "items", String.class, null, (Object)aManager, "selectedItem");
        ComboRidgetTest.assertEquals((int)-1, (int)control.getSelectionIndex());
        ComboRidgetTest.assertEquals((int)0, (int)control.getItemCount());
        ridget.updateFromModel();
        ComboRidgetTest.assertEquals((int)aManager.getItems().size(), (int)control.getItemCount());
        ComboRidgetTest.assertEquals((String)aSelection1, (String)this.getSelectedString(control));
        int i = 0;
        while (i < control.getItemCount()) {
            if (!aManager.getItems().contains(control.getItem(i))) {
                ComboRidgetTest.fail();
            }
            ++i;
        }
        aManager.setSelectedItem(aSelection2);
        ComboRidgetTest.assertEquals((String)aSelection1, (String)this.getSelectedString(control));
        ridget.updateFromModel();
        ComboRidgetTest.assertEquals((String)aSelection2, (String)this.getSelectedString(control));
        control.select(2);
        ComboRidgetTest.assertEquals((String)aSelection3, (String)this.getSelectedString(control));
        ComboRidgetTest.assertEquals((String)aSelection3, (String)control.getText());
        ComboRidgetTest.assertEquals((String)aSelection3, (String)aManager.getSelectedItem());
    }

    public void testBindToModelWithNoControl() {
        ComboRidget ridget = new ComboRidget();
        Combo control = new Combo((Composite)this.getShell(), 8);
        ridget.bindToModel((Object)this.manager, "persons", String.class, "getListEntry", (Object)this.manager, "selectedPerson");
        ridget.updateFromModel();
        ComboRidgetTest.assertEquals((int)0, (int)control.getItemCount());
        ridget.setUIControl((Object)control);
        ComboRidgetTest.assertEquals((int)this.manager.getPersons().size(), (int)control.getItemCount());
    }

    public void testFirePropertyChangeSelection() {
        this.manager.setSelectedPerson(this.selection1);
        ComboRidget ridget = this.getRidget();
        Combo control = this.getWidget();
        ComboRidgetTest.assertEquals(null, (String)this.getSelectedString(control));
        ComboRidgetTest.assertEquals((int)0, (int)control.getItemCount());
        ridget.bindToModel((Object)this.manager, "persons", String.class, "getListEntry", (Object)this.manager, "selectedPerson");
        ComboRidgetTest.assertEquals(null, (String)this.getSelectedString(control));
        ComboRidgetTest.assertEquals((int)0, (int)control.getItemCount());
        ridget.updateFromModel();
        this.expectPropertyChangeEvents(new SelectionPropertyChangeEvent(this.selection1, this.selection2));
        control.select(1);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        control.select(1);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new SelectionPropertyChangeEvent(this.selection2, this.selection3), new SelectionPropertyChangeEvent(this.selection3, this.selection1));
        control.select(2);
        control.select(0);
        this.verifyPropertyChangeEvents();
    }

    public void testUpdateSelection() {
        this.manager.setSelectedPerson(this.selection1);
        ComboRidget ridget = this.getRidget();
        Combo control = this.getWidget();
        ComboRidgetTest.assertEquals(null, (String)this.getSelectedString(control));
        ComboRidgetTest.assertEquals((int)0, (int)control.getItemCount());
        ridget.bindToModel((Object)this.manager, "persons", String.class, null, (Object)this.manager, "selectedPerson");
        ComboRidgetTest.assertEquals(null, (String)this.getSelectedString(control));
        ComboRidgetTest.assertEquals((int)0, (int)control.getItemCount());
        ridget.updateFromModel();
        ComboRidgetTest.assertEquals((String)this.selection1.toString(), (String)this.getSelectedString(control));
        control.select(2);
        this.manager.setSelectedPerson(this.selection2);
        ComboRidgetTest.assertEquals((String)this.selection3.toString(), (String)this.getSelectedString(control));
        ComboRidgetTest.assertEquals((Object)this.selection2, (Object)this.manager.getSelectedPerson());
        ridget.updateFromModel();
        ComboRidgetTest.assertEquals((String)this.selection2.toString(), (String)this.getSelectedString(control));
        ComboRidgetTest.assertEquals((Object)this.selection2, (Object)this.manager.getSelectedPerson());
    }

    public void testGetObservableListWithStrings() {
        StringManager aManager = new StringManager(new String[]{"A", "B", "C", "D", "E"});
        ComboRidget ridget = this.getRidget();
        ridget.bindToModel((Object)aManager, "items", String.class, null, (Object)aManager, "selectedItem");
        ComboRidgetTest.assertEquals((int)0, (int)ridget.getObservableList().size());
        ridget.updateFromModel();
        ComboRidgetTest.assertEquals((int)aManager.getItems().size(), (int)ridget.getObservableList().size());
        String[] stringArray = new String[]{"A", "B", "C", "D", "E"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            ComboRidgetTest.assertTrue((boolean)ridget.getObservableList().contains((Object)item));
            ++n2;
        }
    }

    public void testGetSelectionIndex() {
        StringManager aManager = new StringManager(new String[]{"A", "B", "C", "D", "E"});
        ComboRidget ridget = this.getRidget();
        ridget.bindToModel((Object)aManager, "items", String.class, null, (Object)aManager, "selectedItem");
        ridget.updateFromModel();
        ComboRidgetTest.assertEquals((int)-1, (int)this.getRidget().getSelectionIndex());
        this.getWidget().select(1);
        ComboRidgetTest.assertEquals((int)1, (int)this.getRidget().getSelectionIndex());
        ridget.setUIControl(null);
        ComboRidgetTest.assertEquals((int)1, (int)this.getRidget().getSelectionIndex());
    }

    public void testGetSelection() {
        ComboRidget ridget = this.getRidget();
        StringManager aManager = new StringManager(new String[]{"A", "B", "C", "D", "E"});
        ridget.bindToModel((Object)aManager, "items", String.class, null, (Object)aManager, "selectedItem");
        ridget.updateFromModel();
        ComboRidgetTest.assertEquals(null, (Object)this.getRidget().getSelection());
        this.getWidget().select(1);
        ComboRidgetTest.assertEquals((Object)"B", (Object)this.getRidget().getSelection());
        ridget.setUIControl(null);
        ComboRidgetTest.assertEquals((Object)"B", (Object)this.getRidget().getSelection());
    }

    public void testSetSelectionInt() {
        ComboRidget ridget = this.getRidget();
        Combo control = ridget.getUIControl();
        StringManager aManager = new StringManager(new String[]{"A", "B", "C", "D", "E"});
        ridget.bindToModel((Object)aManager, "items", String.class, null, (Object)aManager, "selectedItem");
        ridget.updateFromModel();
        ComboRidgetTest.assertEquals(null, (Object)ridget.getSelection());
        ridget.setSelection(0);
        ComboRidgetTest.assertEquals((Object)"A", (Object)ridget.getSelection());
        ComboRidgetTest.assertEquals((String)"A", (String)control.getItem(control.getSelectionIndex()));
        ridget.setSelection(1);
        ComboRidgetTest.assertEquals((Object)"B", (Object)ridget.getSelection());
        ComboRidgetTest.assertEquals((String)"B", (String)control.getItem(control.getSelectionIndex()));
        ridget.setUIControl(null);
        ridget.setSelection(2);
        ComboRidgetTest.assertEquals((Object)"C", (Object)ridget.getSelection());
        ComboRidgetTest.assertEquals((String)"B", (String)control.getItem(control.getSelectionIndex()));
        ridget.setUIControl((Object)control);
        ComboRidgetTest.assertEquals((Object)"C", (Object)ridget.getSelection());
        ComboRidgetTest.assertEquals((String)"C", (String)control.getItem(control.getSelectionIndex()));
        ridget.setSelection(-1);
        ComboRidgetTest.assertEquals(null, (Object)ridget.getSelection());
        ComboRidgetTest.assertEquals((int)-1, (int)control.getSelectionIndex());
        try {
            ridget.setSelection(999);
            ComboRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testSetSelectionString() {
        ComboRidget ridget = this.getRidget();
        Combo control = ridget.getUIControl();
        StringManager aManager = new StringManager(new String[]{"A", "B", "C", "D", "E"});
        ridget.bindToModel((Object)aManager, "items", String.class, null, (Object)aManager, "selectedItem");
        ridget.updateFromModel();
        ComboRidgetTest.assertEquals(null, (Object)ridget.getSelection());
        ridget.setSelection((Object)"A");
        ComboRidgetTest.assertEquals((Object)"A", (Object)ridget.getSelection());
        ComboRidgetTest.assertEquals((String)"A", (String)control.getItem(control.getSelectionIndex()));
        ridget.setSelection((Object)"B");
        ComboRidgetTest.assertEquals((Object)"B", (Object)ridget.getSelection());
        ComboRidgetTest.assertEquals((String)"B", (String)control.getItem(control.getSelectionIndex()));
        ridget.setUIControl(null);
        ridget.setSelection((Object)"C");
        ComboRidgetTest.assertEquals((Object)"C", (Object)ridget.getSelection());
        ComboRidgetTest.assertEquals((String)"B", (String)control.getItem(control.getSelectionIndex()));
        ridget.setUIControl((Object)control);
        ComboRidgetTest.assertEquals((Object)"C", (Object)ridget.getSelection());
        ComboRidgetTest.assertEquals((String)"C", (String)control.getItem(control.getSelectionIndex()));
        ridget.setSelection((Object)"X");
        ComboRidgetTest.assertEquals(null, (Object)ridget.getSelection());
        ComboRidgetTest.assertEquals((int)-1, (int)control.getSelectionIndex());
        ridget.setSelection((Object)"A");
        ridget.setSelection(null);
        ComboRidgetTest.assertEquals(null, (Object)ridget.getSelection());
        ComboRidgetTest.assertEquals((int)-1, (int)control.getSelectionIndex());
    }

    public void testSetSelectionWhenNotBoundToModel() {
        ComboRidget ridget = this.getRidget();
        try {
            ridget.setSelection(new Object());
            ComboRidgetTest.fail();
        }
        catch (BindingException bindingException) {
            this.ok();
        }
    }

    public void testOutputCannotBeChangedFromUI() {
        ComboRidget ridget = this.getRidget();
        Combo control = this.getWidget();
        StringManager aManager = new StringManager(new String[]{"A", "B", "C", "D", "E"});
        ridget.bindToModel((Object)aManager, "items", String.class, null, (Object)aManager, "selectedItem");
        ridget.updateFromModel();
        ComboRidgetTest.assertNull((Object)ridget.getSelection());
        ComboRidgetTest.assertEquals((int)-1, (int)control.getSelectionIndex());
        ridget.setOutputOnly(true);
        control.setFocus();
        UITestHelper.sendString(control.getDisplay(), "A");
        ComboRidgetTest.assertNull((Object)ridget.getSelection());
        ComboRidgetTest.assertEquals((int)-1, (int)control.getSelectionIndex());
        ridget.setOutputOnly(false);
        control.setFocus();
        UITestHelper.sendString(control.getDisplay(), "A");
        ComboRidgetTest.assertEquals((Object)"A", (Object)ridget.getSelection());
        ComboRidgetTest.assertEquals((int)0, (int)control.getSelectionIndex());
    }

    public void testDisabledComboIsEmptyFromRidget() {
        if (!MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT) {
            System.out.println("Skipping ComboRidgetTest.testDisabledComboIsEmptyFromRidget()");
            return;
        }
        ComboRidget ridget = this.getRidget();
        Combo control = this.getWidget();
        ridget.bindToModel((Object)this.manager, "persons", String.class, null, (Object)this.manager, "selectedPerson");
        ridget.updateFromModel();
        ridget.setSelection((Object)this.selection1);
        ComboRidgetTest.assertEquals((String)this.selection1.toString(), (String)control.getText());
        ComboRidgetTest.assertEquals((Object)this.selection1, (Object)ridget.getSelection());
        ComboRidgetTest.assertEquals((Object)this.selection1, (Object)this.manager.getSelectedPerson());
        ridget.setEnabled(false);
        ComboRidgetTest.assertEquals((String)"", (String)control.getText());
        ComboRidgetTest.assertEquals((Object)this.selection1, (Object)ridget.getSelection());
        ComboRidgetTest.assertEquals((Object)this.selection1, (Object)this.manager.getSelectedPerson());
        ridget.setSelection((Object)this.selection2);
        ComboRidgetTest.assertEquals((String)"", (String)control.getText());
        ComboRidgetTest.assertEquals((Object)this.selection2, (Object)ridget.getSelection());
        ComboRidgetTest.assertEquals((Object)this.selection2, (Object)this.manager.getSelectedPerson());
        ridget.setEnabled(true);
        ComboRidgetTest.assertEquals((String)this.selection2.toString(), (String)control.getText());
        ComboRidgetTest.assertEquals((Object)this.selection2, (Object)ridget.getSelection());
        ComboRidgetTest.assertEquals((Object)this.selection2, (Object)this.manager.getSelectedPerson());
    }

    public void testDisabledComboIsEmptyFromModel() {
        if (!MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT) {
            System.out.println("Skipping ComboRidgetTest.testDisabledComboIsEmptyFromModel()");
            return;
        }
        ComboRidget ridget = this.getRidget();
        Combo control = this.getWidget();
        ridget.bindToModel((Object)this.manager, "persons", String.class, null, (Object)this.manager, "selectedPerson");
        this.manager.setSelectedPerson(this.selection1);
        ridget.updateFromModel();
        ComboRidgetTest.assertEquals((String)this.selection1.toString(), (String)control.getText());
        ComboRidgetTest.assertEquals((Object)this.selection1, (Object)ridget.getSelection());
        ComboRidgetTest.assertEquals((Object)this.selection1, (Object)this.manager.getSelectedPerson());
        ridget.setEnabled(false);
        ComboRidgetTest.assertEquals((String)"", (String)control.getText());
        ComboRidgetTest.assertEquals((Object)this.selection1, (Object)ridget.getSelection());
        ComboRidgetTest.assertEquals((Object)this.selection1, (Object)this.manager.getSelectedPerson());
        this.manager.setSelectedPerson(this.selection2);
        ridget.updateFromModel();
        ComboRidgetTest.assertEquals((String)"", (String)control.getText());
        ComboRidgetTest.assertEquals((Object)this.selection2, (Object)ridget.getSelection());
        ComboRidgetTest.assertEquals((Object)this.selection2, (Object)this.manager.getSelectedPerson());
        ridget.setEnabled(true);
        ComboRidgetTest.assertEquals((String)this.selection2.toString(), (String)control.getText());
        ComboRidgetTest.assertEquals((Object)this.selection2, (Object)ridget.getSelection());
        ComboRidgetTest.assertEquals((Object)this.selection2, (Object)this.manager.getSelectedPerson());
    }

    public void testDisabledDoesNotFireSelection() {
        ComboRidget ridget = this.getRidget();
        ridget.bindToModel((Object)this.manager, "persons", String.class, null, (Object)this.manager, "selectedPerson");
        ridget.updateFromModel();
        FTPropertyChangeListener pcl = new FTPropertyChangeListener();
        ridget.addPropertyChangeListener("selection", (PropertyChangeListener)pcl);
        ridget.setSelection((Object)this.selection1);
        ComboRidgetTest.assertEquals((int)1, (int)pcl.getCount());
        ridget.setEnabled(false);
        ComboRidgetTest.assertEquals((int)1, (int)pcl.getCount());
        ridget.setSelection((Object)this.selection2);
        ComboRidgetTest.assertEquals((int)2, (int)pcl.getCount());
        ridget.setEnabled(true);
        ComboRidgetTest.assertEquals((int)2, (int)pcl.getCount());
    }

    public void testDisableWithoutBoundModel() {
        ComboRidget ridget = this.getRidget();
        Combo control = this.getWidget();
        ComboRidgetTest.assertTrue((boolean)ridget.getObservableList().isEmpty());
        ridget.setEnabled(false);
        ComboRidgetTest.assertFalse((boolean)ridget.isEnabled());
        ComboRidgetTest.assertFalse((boolean)control.isEnabled());
        ridget.setEnabled(true);
        ComboRidgetTest.assertTrue((boolean)ridget.isEnabled());
        ComboRidgetTest.assertTrue((boolean)control.isEnabled());
    }

    public void testDisableAndClearOnBind() {
        ComboRidget ridget = this.getRidget();
        Combo control = this.getWidget();
        ridget.setUIControl(null);
        ridget.setEnabled(false);
        this.manager.setSelectedPerson(this.selection1);
        ridget.bindToModel((Object)this.manager, "persons", String.class, null, (Object)this.manager, "selectedPerson");
        ridget.updateFromModel();
        ridget.setUIControl((Object)control);
        ComboRidgetTest.assertFalse((boolean)control.isEnabled());
        ComboRidgetTest.assertEquals((String)"", (String)control.getText());
        ComboRidgetTest.assertEquals((Object)this.selection1, (Object)ridget.getSelection());
        ridget.setEnabled(true);
        ComboRidgetTest.assertTrue((boolean)control.isEnabled());
        ComboRidgetTest.assertEquals((String)this.selection1.toString(), (String)control.getText());
        ComboRidgetTest.assertEquals((Object)this.selection1, (Object)ridget.getSelection());
    }

    private String getSelectedString(Combo combo) {
        int index = combo.getSelectionIndex();
        return index == -1 ? null : combo.getItem(index);
    }

    private boolean find(PersonManager manager, String item) {
        boolean result = false;
        Iterator iter = manager.getPersons().iterator();
        while (!result && iter.hasNext()) {
            result = ((Person)iter.next()).toString().equals(item);
        }
        return result;
    }

    private void checkPersonList(PersonManager manager) {
        Combo control = this.getWidget();
        ComboRidgetTest.assertEquals((int)manager.getPersons().size(), (int)control.getItemCount());
        ArrayList<String> listEntries = new ArrayList<String>();
        for (Person person : manager.getPersons()) {
            listEntries.add(person.getListEntry());
        }
        int i = 0;
        while (i < control.getItemCount()) {
            String item = control.getItem(i);
            if (!listEntries.contains(item)) {
                ComboRidgetTest.fail();
            }
            ++i;
        }
    }

    private Collection<Person> createPersonList() {
        ArrayList<Person> newList = new ArrayList<Person>();
        Person person = new Person("Doe", "John");
        person.setEyeColor(1);
        newList.add(person);
        person = new Person("Jackson", "Janet");
        person.setEyeColor(1);
        newList.add(person);
        person = new Person("Jackson", "Jermaine");
        person.setEyeColor(1);
        newList.add(person);
        person = new Person("Jackson", "John");
        person.setEyeColor(3);
        newList.add(person);
        person = new Person("JJ Jr. Shabadoo", "Joey");
        person.setEyeColor(3);
        newList.add(person);
        person = new Person("Johnson", "Jack");
        person.setEyeColor(2);
        newList.add(person);
        person = new Person("Johnson", "Jane");
        person.setEyeColor(3);
        newList.add(person);
        person = new Person("Zappa", "Frank");
        person.setEyeColor(2);
        newList.add(person);
        return newList;
    }

    private static final class FTPropertyChangeListener
    implements PropertyChangeListener {
        private int count;

        private FTPropertyChangeListener() {
        }

        public int getCount() {
            return this.count;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ++this.count;
        }
    }

    private final class SelectionPropertyChangeEvent
    extends PropertyChangeEvent {
        private static final long serialVersionUID = 4711L;

        public SelectionPropertyChangeEvent(Object oldValue, Object newValue) {
            super(ComboRidgetTest.this.getRidget(), "selection", oldValue, newValue);
        }
    }
}

