/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonManager;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractTableRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.ListRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.tests.FTActionListener;
import org.eclipse.riena.tests.UITestHelper;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.swt.uibinding.DefaultSwtControlRidgetMapper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class ListRidgetTest
extends AbstractTableRidgetTest {
    protected Control createWidget(Composite parent) {
        return new org.eclipse.swt.widgets.List(parent, 2);
    }

    protected IRidget createRidget() {
        return new ListRidget();
    }

    protected org.eclipse.swt.widgets.List getWidget() {
        return (org.eclipse.swt.widgets.List)super.getWidget();
    }

    protected ListRidget getRidget() {
        return (ListRidget)super.getRidget();
    }

    protected void bindRidgetToModel() {
        this.getRidget().bindToModel((Object)this.manager, "persons", Person.class, new String[]{"firstname"}, new String[]{""});
    }

    public void testRidgetMapping() {
        DefaultSwtControlRidgetMapper mapper = new DefaultSwtControlRidgetMapper();
        ListRidgetTest.assertSame(ListRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testUpdateFromModel() {
        org.eclipse.swt.widgets.List control = this.getWidget();
        ListRidget ridget = this.getRidget();
        int oldCount = this.manager.getPersons().size();
        ListRidgetTest.assertEquals((int)oldCount, (int)ridget.getObservableList().size());
        ListRidgetTest.assertEquals((int)oldCount, (int)control.getItemCount());
        this.manager.getPersons().remove(this.person1);
        int newCount = oldCount - 1;
        ListRidgetTest.assertEquals((int)newCount, (int)this.manager.getPersons().size());
        ListRidgetTest.assertEquals((int)oldCount, (int)ridget.getObservableList().size());
        ListRidgetTest.assertEquals((int)oldCount, (int)control.getItemCount());
        ridget.updateFromModel();
        ListRidgetTest.assertEquals((int)newCount, (int)this.manager.getPersons().size());
        ListRidgetTest.assertEquals((int)newCount, (int)ridget.getObservableList().size());
        ListRidgetTest.assertEquals((int)newCount, (int)control.getItemCount());
    }

    public void testUpdateFromModelPreservesSelection() {
        ListRidget ridget = this.getRidget();
        ridget.setSelection((Object)this.person2);
        ListRidgetTest.assertSame((Object)this.person2, ridget.getSelection().get(0));
        this.manager.getPersons().remove(this.person1);
        ridget.updateFromModel();
        ListRidgetTest.assertSame((Object)this.person2, ridget.getSelection().get(0));
    }

    public void testContainsOption() {
        ListRidget ridget = this.getRidget();
        ListRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person1));
        ListRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person2));
        ListRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person3));
        ListRidgetTest.assertFalse((boolean)ridget.containsOption(null));
        ListRidgetTest.assertFalse((boolean)ridget.containsOption((Object)new Person("", "")));
        List<Person> persons = Arrays.asList(this.person3);
        PersonManager manager = new PersonManager(persons);
        this.getRidget().bindToModel((Object)manager, "persons", Person.class, new String[]{"firstname"}, new String[]{""});
        ListRidgetTest.assertFalse((boolean)ridget.containsOption((Object)this.person1));
        ListRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person3));
    }

    public void testSetSelectionType() {
        ListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        ListRidgetTest.assertEquals((Object)ISelectableRidget.SelectionType.SINGLE, (Object)ridget.getSelectionType());
        ListRidgetTest.assertTrue(((control.getStyle() & 2) != 0 ? 1 : 0) != 0);
        int[] nArray = new int[2];
        nArray[1] = 1;
        ridget.setSelection(nArray);
        ListRidgetTest.assertEquals((int)1, (int)ridget.getSelectionIndices().length);
        ListRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        ridget.setSelection(nArray2);
        ListRidgetTest.assertEquals((int)2, (int)ridget.getSelectionIndices().length);
        ListRidgetTest.assertEquals((int)2, (int)control.getSelectionCount());
    }

    public void testAddDoubleClickListener() {
        ListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        try {
            ridget.addDoubleClickListener(null);
            ListRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        FTActionListener listener1 = new FTActionListener();
        ridget.addDoubleClickListener((IActionListener)listener1);
        FTActionListener listener2 = new FTActionListener();
        ridget.addDoubleClickListener((IActionListener)listener2);
        ridget.addDoubleClickListener((IActionListener)listener2);
        Event doubleClick = new Event();
        doubleClick.widget = control;
        doubleClick.type = 8;
        control.notifyListeners(8, doubleClick);
        ListRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        ListRidgetTest.assertEquals((int)1, (int)listener2.getCount());
        ridget.removeDoubleClickListener((IActionListener)listener1);
        control.notifyListeners(8, doubleClick);
        ListRidgetTest.assertEquals((int)1, (int)listener1.getCount());
    }

    public void testSetComparator() {
        ListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        StringComparator comparator = new StringComparator();
        try {
            ridget.setComparator(-1, (Comparator)comparator);
            ListRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.setComparator(1, (Comparator)comparator);
            ListRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        int lastItemIndex = control.getItemCount() - 1;
        ListRidgetTest.assertEquals((String)"John", (String)control.getItem(0));
        ListRidgetTest.assertEquals((String)"Frank", (String)control.getItem(lastItemIndex));
        ridget.setComparator(0, (Comparator)comparator);
        ridget.setSortedColumn(0);
        ListRidgetTest.assertEquals((String)"Frank", (String)control.getItem(0));
        ListRidgetTest.assertEquals((String)"John", (String)control.getItem(lastItemIndex));
        ridget.setComparator(0, null);
        ListRidgetTest.assertEquals((String)"John", (String)control.getItem(0));
        ListRidgetTest.assertEquals((String)"Frank", (String)control.getItem(lastItemIndex));
    }

    public void testGetSortedColumn() {
        ListRidget ridget = this.getRidget();
        try {
            ridget.setSortedColumn(1);
            ListRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.setSortedColumn(-2);
            ListRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setComparator(0, (Comparator)new StringComparator());
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setSortedColumn(0);
        ListRidgetTest.assertEquals((int)0, (int)ridget.getSortedColumn());
        ridget.setComparator(0, null);
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setSortedColumn(-1);
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setSortedColumn(0);
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
    }

    public void testIsColumnSortable() {
        ListRidget ridget = this.getRidget();
        try {
            ListRidgetTest.assertFalse((boolean)ridget.isColumnSortable(-1));
            ListRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ListRidgetTest.assertFalse((boolean)ridget.isColumnSortable(1));
            ListRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        ListRidgetTest.assertFalse((boolean)ridget.isColumnSortable(0));
        ridget.setComparator(0, (Comparator)new StringComparator());
        ListRidgetTest.assertTrue((boolean)ridget.isColumnSortable(0));
        ridget.setComparator(0, null);
        ListRidgetTest.assertFalse((boolean)ridget.isColumnSortable(0));
    }

    public void testSetColumnSortable() {
        ListRidget ridget = this.getRidget();
        try {
            ridget.setColumnSortable(0, true);
            ListRidgetTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.ok();
        }
    }

    public void testSetSortedAscending() {
        org.eclipse.swt.widgets.List control = this.getWidget();
        ListRidget ridget = this.getRidget();
        ridget.bindToModel((Object)this.manager, "persons", Person.class, new String[]{"lastname"}, new String[]{""});
        int lastItemIndex = control.getItemCount() - 1;
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ListRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
        ridget.setSortedAscending(false);
        ListRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        ridget.setComparator(0, (Comparator)new StringComparator());
        ridget.setSortedColumn(0);
        ListRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        ListRidgetTest.assertEquals((String)"Zappa", (String)control.getItem(0));
        ListRidgetTest.assertEquals((String)"Doe", (String)control.getItem(lastItemIndex));
        ridget.setSortedAscending(true);
        ListRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
        ListRidgetTest.assertEquals((String)"Doe", (String)control.getItem(0));
        ListRidgetTest.assertEquals((String)"Zappa", (String)control.getItem(lastItemIndex));
        ridget.setComparator(0, null);
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ListRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
    }

    public void testSetSortedAscendingFiresEvents() {
        ListRidget ridget = this.getRidget();
        ListRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortAscending", Boolean.TRUE, Boolean.FALSE));
        ridget.setSortedAscending(false);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSortedAscending(false);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortAscending", Boolean.FALSE, Boolean.TRUE));
        ridget.setSortedAscending(true);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSortedAscending(true);
        this.verifyPropertyChangeEvents();
    }

    public void testSetSortedColumnFiresEvents() {
        ListRidget ridget = this.getRidget();
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortedColumn", -1, 0));
        ridget.setSortedColumn(0);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSortedColumn(0);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortedColumn", 0, -1));
        ridget.setSortedColumn(-1);
        this.verifyPropertyChangeEvents();
    }

    public void testHasMoveableColumns() {
        ListRidget ridget = this.getRidget();
        ListRidgetTest.assertFalse((boolean)ridget.hasMoveableColumns());
        try {
            ridget.setMoveableColumns(true);
            ListRidgetTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.ok();
        }
    }

    public void testOutputSingleSelectionCannotBeChangedFromUI() {
        ListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        ListRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        ListRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(true);
        control.setFocus();
        UITestHelper.sendString(control.getDisplay(), " ");
        ListRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        ListRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(false);
        control.setFocus();
        UITestHelper.sendString(control.getDisplay(), " ");
        ListRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        ListRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
    }

    public void testOutputMultipleSelectionCannotBeChangedFromUI() {
        ListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        ListRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        ListRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(true);
        control.setFocus();
        UITestHelper.sendString(control.getDisplay(), " ");
        ListRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        ListRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(false);
        control.setFocus();
        UITestHelper.sendString(control.getDisplay(), " ");
        ListRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        ListRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
    }

    public void testTogglingOutputDoesNotChangeSelection() {
        ListRidget ridget = this.getRidget();
        ridget.setSelection(0);
        ListRidgetTest.assertEquals((int)0, (int)ridget.getSelectionIndex());
        ridget.setOutputOnly(true);
        ListRidgetTest.assertEquals((int)0, (int)ridget.getSelectionIndex());
        ridget.setSelection(null);
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSelectionIndex());
        ridget.setOutputOnly(false);
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSelectionIndex());
    }

    public void testDisabledListIsEmptyFromRidget() {
        if (!MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT) {
            System.out.println("Skipping ListRidgetTest.testDisabledListIsEmptyFromRidget()");
            return;
        }
        ListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        this.getRidget().bindSingleSelectionToModel((Object)this.manager, "selectedPerson");
        ridget.setSelection((Object)this.person1);
        ListRidgetTest.assertEquals((String)this.person1.getFirstname(), (String)control.getItem(control.getSelectionIndex()));
        ListRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
        ListRidgetTest.assertEquals((Object)this.person1, (Object)this.manager.getSelectedPerson());
        ridget.setEnabled(false);
        ListRidgetTest.assertEquals((int)-1, (int)control.getSelectionIndex());
        ListRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
        ListRidgetTest.assertEquals((Object)this.person1, (Object)this.manager.getSelectedPerson());
        ridget.setSelection((Object)this.person2);
        ListRidgetTest.assertEquals((int)-1, (int)control.getSelectionIndex());
        ListRidgetTest.assertEquals((Object)this.person2, ridget.getSelection().get(0));
        ListRidgetTest.assertEquals((Object)this.person2, (Object)this.manager.getSelectedPerson());
        ridget.setEnabled(true);
        ListRidgetTest.assertEquals((String)this.person2.getFirstname(), (String)control.getItem(control.getSelectionIndex()));
        ListRidgetTest.assertEquals((Object)this.person2, ridget.getSelection().get(0));
        ListRidgetTest.assertEquals((Object)this.person2, (Object)this.manager.getSelectedPerson());
    }

    public void testDisabledListIsEmptyFromModel() {
        if (!MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT) {
            System.out.println("Skipping ListRidgetTest.testDisabledListIsEmptyFromModel()");
            return;
        }
        ListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        this.getRidget().bindSingleSelectionToModel((Object)this.manager, "selectedPerson");
        this.manager.setSelectedPerson(this.person1);
        ridget.updateSingleSelectionFromModel();
        ListRidgetTest.assertEquals((String)this.person1.getFirstname(), (String)control.getItem(control.getSelectionIndex()));
        ListRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
        ListRidgetTest.assertEquals((Object)this.person1, (Object)this.manager.getSelectedPerson());
        ridget.setEnabled(false);
        ListRidgetTest.assertEquals((int)-1, (int)control.getSelectionIndex());
        ListRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
        ListRidgetTest.assertEquals((Object)this.person1, (Object)this.manager.getSelectedPerson());
        this.manager.setSelectedPerson(this.person2);
        ridget.updateSingleSelectionFromModel();
        ListRidgetTest.assertEquals((int)-1, (int)control.getSelectionIndex());
        ListRidgetTest.assertEquals((Object)this.person2, ridget.getSelection().get(0));
        ListRidgetTest.assertEquals((Object)this.person2, (Object)this.manager.getSelectedPerson());
        ridget.setEnabled(true);
        ListRidgetTest.assertEquals((String)this.person2.getFirstname(), (String)control.getItem(control.getSelectionIndex()));
        ListRidgetTest.assertEquals((Object)this.person2, ridget.getSelection().get(0));
        ListRidgetTest.assertEquals((Object)this.person2, (Object)this.manager.getSelectedPerson());
    }

    public void testDisabledDoesNotFireSelection() {
        ListRidget ridget = this.getRidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        FTPropertyChangeListener listener = new FTPropertyChangeListener();
        ridget.addPropertyChangeListener("selection", (PropertyChangeListener)listener);
        ridget.setSelection((Object)this.person1);
        int count = listener.getCount();
        ridget.setEnabled(false);
        ListRidgetTest.assertEquals((int)count, (int)listener.getCount());
        ridget.setSelection((Object)this.person2);
        count = listener.getCount();
        ridget.setEnabled(true);
        ListRidgetTest.assertTrue((count < listener.getCount() ? 1 : 0) != 0);
    }

    public void testDisableWithoutBoundModel() {
        ListRidget ridget = (ListRidget)this.createRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        ridget.setUIControl((Object)control);
        ListRidgetTest.assertNull((Object)ridget.getObservableList());
        ridget.setEnabled(false);
        ListRidgetTest.assertFalse((boolean)ridget.isEnabled());
        ListRidgetTest.assertFalse((boolean)control.isEnabled());
        ridget.setEnabled(true);
        ListRidgetTest.assertTrue((boolean)ridget.isEnabled());
        ListRidgetTest.assertTrue((boolean)control.isEnabled());
    }

    public void testDisableAndClearOnBind() {
        if (!MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT) {
            System.out.println("Skipping ListRidgetTest.testDisableAndClearOnBind()");
            return;
        }
        ListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        this.getRidget().bindSingleSelectionToModel((Object)this.manager, "selectedPerson");
        ridget.setUIControl(null);
        ridget.setEnabled(false);
        this.manager.setSelectedPerson(this.person1);
        ridget.updateSingleSelectionFromModel();
        ridget.setUIControl((Object)control);
        ListRidgetTest.assertFalse((boolean)control.isEnabled());
        ListRidgetTest.assertEquals((String)"", (String)control.getItem(0));
        ListRidgetTest.assertEquals((int)-1, (int)control.getSelectionIndex());
        ListRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
        ridget.setEnabled(true);
        ListRidgetTest.assertTrue((boolean)control.isEnabled());
        ListRidgetTest.assertTrue((control.getItem(0).length() > 0 ? 1 : 0) != 0);
        ListRidgetTest.assertTrue((control.getSelectionIndex() > -1 ? 1 : 0) != 0);
        ListRidgetTest.assertEquals((int)this.manager.getPersons().size(), (int)control.getItemCount());
        ListRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
    }

    protected void clearUIControlRowSelection() {
        this.getWidget().deselectAll();
        this.fireSelectionEvent();
    }

    protected int getUIControlSelectedRowCount() {
        return this.getWidget().getSelectionCount();
    }

    protected int getUIControlSelectedRow() {
        return this.getWidget().getSelectionIndex();
    }

    protected Object getRowValue(int i) {
        IObservableList rowObservables = (IObservableList)ReflectionUtils.invokeHidden((Object)this.getRidget(), (String)"getRowObservables", (Object[])new Object[0]);
        return rowObservables.get(i);
    }

    protected int[] getSelectedRows() {
        IObservableList rowObservables = (IObservableList)ReflectionUtils.invokeHidden((Object)this.getRidget(), (String)"getRowObservables", (Object[])new Object[0]);
        Object[] elements = this.getRidget().getMultiSelectionObservable().toArray();
        int[] result = new int[elements.length];
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            result[i] = rowObservables.indexOf(element);
            ++i;
        }
        return result;
    }

    protected int[] getUIControlSelectedRows() {
        return this.getWidget().getSelectionIndices();
    }

    protected void setUIControlRowSelection(int[] indices) {
        this.getWidget().setSelection(indices);
        this.fireSelectionEvent();
    }

    protected void setUIControlRowSelectionInterval(int start, int end) {
        this.getWidget().setSelection(start, end);
        this.fireSelectionEvent();
    }

    private static final class FTPropertyChangeListener
    implements PropertyChangeListener {
        private int count;

        private FTPropertyChangeListener() {
        }

        public int getCount() {
            return this.count;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ++this.count;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StringComparator
    implements Comparator<Object>,
    Serializable {
        private StringComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s1.compareTo(s2);
        }
    }
}

