/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.controllers;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.navigation.ui.filter.UIFilterRuleNavigationDisabledMarker;
import org.eclipse.riena.internal.navigation.ui.filter.UIFilterRuleNavigationHiddenMarker;
import org.eclipse.riena.internal.navigation.ui.filter.UIFilterRuleRidgetHiddenMarker;
import org.eclipse.riena.internal.ui.ridgets.swt.LabelRidget;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationNodeController;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.NavigationProcessor;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.IUIFilterRuleClosure;
import org.eclipse.riena.navigation.ui.controllers.NavigationUIFilterApplier;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.tests.collect.UITestCase;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.filter.IUIFilter;
import org.eclipse.riena.ui.filter.impl.UIFilter;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

@UITestCase
public class NavigationUIFilterApplierTest
extends TestCase {
    protected void setUp() throws Exception {
        Display display = Display.getDefault();
        Realm realm = SWTObservables.getRealm((Display)display);
        NavigationUIFilterApplierTest.assertNotNull((Object)realm);
        ReflectionUtils.invokeHidden((Object)realm, (String)"setDefault", (Object[])new Object[]{realm});
    }

    public void testCollectFilters() {
        NavigationUIFilterApplier applier = new NavigationUIFilterApplier();
        ArrayList filters = new ArrayList();
        NavigationNodeId id = new NavigationNodeId("4711");
        SubModuleNode node = new SubModuleNode(id);
        ReflectionUtils.invokeHidden((Object)applier, (String)"collectFilters", (Object[])new Object[]{node, filters});
        NavigationUIFilterApplierTest.assertTrue((boolean)filters.isEmpty());
        UIFilter filter = new UIFilter();
        node.addFilter((IUIFilter)filter);
        ReflectionUtils.invokeHidden((Object)applier, (String)"collectFilters", (Object[])new Object[]{node, filters});
        NavigationUIFilterApplierTest.assertTrue((filters.size() == 1 ? 1 : 0) != 0);
        NavigationUIFilterApplierTest.assertSame((Object)filter, filters.iterator().next());
        filters.clear();
        NavigationNodeId id2 = new NavigationNodeId("parent");
        SubModuleNode node2 = new SubModuleNode(id2);
        node2.addChild((INavigationNode)node);
        UIFilter filter2 = new UIFilter();
        node2.addFilter((IUIFilter)filter2);
        ReflectionUtils.invokeHidden((Object)applier, (String)"collectFilters", (Object[])new Object[]{node, filters});
        NavigationUIFilterApplierTest.assertTrue((filters.size() == 2 ? 1 : 0) != 0);
        NavigationUIFilterApplierTest.assertSame((Object)filter, filters.iterator().next());
        NavigationUIFilterApplierTest.assertTrue((boolean)filters.contains(filter2));
        filters.clear();
        NavigationNodeId id3 = new NavigationNodeId("child");
        SubModuleNode node3 = new SubModuleNode(id3);
        node.addChild((INavigationNode)node3);
        UIFilter filter3 = new UIFilter();
        node3.addFilter((IUIFilter)filter3);
        ReflectionUtils.invokeHidden((Object)applier, (String)"collectFilters", (Object[])new Object[]{node, filters});
        NavigationUIFilterApplierTest.assertTrue((filters.size() == 2 ? 1 : 0) != 0);
        NavigationUIFilterApplierTest.assertFalse((boolean)filters.contains(filter3));
    }

    public void testApplyFilters() {
        NavigationUIFilterApplier applier = new NavigationUIFilterApplier();
        NavigationNodeId id = new NavigationNodeId("4711");
        SubModuleNode node = new SubModuleNode(id);
        node.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        ArrayList<UIFilterRuleNavigationDisabledMarker> attributes = new ArrayList<UIFilterRuleNavigationDisabledMarker>(1);
        attributes.add(new UIFilterRuleNavigationDisabledMarker("*" + node.getNodeId().getTypeId()));
        UIFilter filter = new UIFilter(attributes);
        node.addFilter((IUIFilter)filter);
        ArrayList<UIFilterRuleNavigationHiddenMarker> attributes2 = new ArrayList<UIFilterRuleNavigationHiddenMarker>(1);
        attributes2.add(new UIFilterRuleNavigationHiddenMarker("*" + node.getNodeId().getTypeId()));
        UIFilter filter2 = new UIFilter(attributes2);
        node.addFilter((IUIFilter)filter2);
        ReflectionUtils.invokeHidden((Object)applier, (String)"applyFilters", (Object[])new Object[]{node});
        NavigationUIFilterApplierTest.assertFalse((boolean)node.getMarkersOfType(DisabledMarker.class).isEmpty());
        NavigationUIFilterApplierTest.assertFalse((boolean)node.getMarkersOfType(HiddenMarker.class).isEmpty());
    }

    public void testApplyFilter() {
        NavigationUIFilterApplier applier = new NavigationUIFilterApplier();
        NavigationNodeId id = new NavigationNodeId("4711");
        SubModuleNode node = new SubModuleNode(id);
        node.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        NavigationNodeId id2 = new NavigationNodeId("0815");
        SubModuleNode node2 = new SubModuleNode(id2);
        node.addChild((INavigationNode)node2);
        ArrayList<Object> attributes = new ArrayList<Object>(2);
        attributes.add(new UIFilterRuleNavigationDisabledMarker("*" + node.getNodeId().getTypeId()));
        attributes.add(new UIFilterRuleNavigationHiddenMarker("*" + node.getNodeId().getTypeId()));
        UIFilter filter = new UIFilter(attributes);
        IUIFilterRuleClosure closure = (IUIFilterRuleClosure)ReflectionUtils.getHidden((Object)applier, (String)"APPLY_CLOSURE");
        ReflectionUtils.invokeHidden((Object)applier, (String)"applyFilter", (Object[])new Object[]{node, filter, closure});
        NavigationUIFilterApplierTest.assertFalse((boolean)node.getMarkersOfType(DisabledMarker.class).isEmpty());
        NavigationUIFilterApplierTest.assertFalse((boolean)node.getMarkersOfType(HiddenMarker.class).isEmpty());
        NavigationUIFilterApplierTest.assertFalse((boolean)node2.getMarkersOfType(DisabledMarker.class).isEmpty());
        NavigationUIFilterApplierTest.assertFalse((boolean)node2.getMarkersOfType(HiddenMarker.class).isEmpty());
        closure = (IUIFilterRuleClosure)ReflectionUtils.getHidden((Object)applier, (String)"REMOVE_CLOSURE");
        ReflectionUtils.invokeHidden((Object)applier, (String)"applyFilter", (Object[])new Object[]{node, filter, closure});
        NavigationUIFilterApplierTest.assertTrue((boolean)node.getMarkersOfType(DisabledMarker.class).isEmpty());
        NavigationUIFilterApplierTest.assertTrue((boolean)node.getMarkersOfType(HiddenMarker.class).isEmpty());
        NavigationUIFilterApplierTest.assertTrue((boolean)node2.getMarkersOfType(DisabledMarker.class).isEmpty());
        NavigationUIFilterApplierTest.assertTrue((boolean)node2.getMarkersOfType(HiddenMarker.class).isEmpty());
    }

    public void testApplyFilterRule() {
        NavigationUIFilterApplier applier = new NavigationUIFilterApplier();
        NavigationNodeId id = new NavigationNodeId("4711");
        SubModuleNode node = new SubModuleNode(id);
        node.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        UIFilterRuleNavigationDisabledMarker attribute = new UIFilterRuleNavigationDisabledMarker("*" + node.getNodeId().getTypeId());
        IUIFilterRuleClosure closure = (IUIFilterRuleClosure)ReflectionUtils.getHidden((Object)applier, (String)"APPLY_CLOSURE");
        ReflectionUtils.invokeHidden((Object)applier, (String)"applyFilterRule", (Object[])new Object[]{node, attribute, closure});
        NavigationUIFilterApplierTest.assertFalse((boolean)node.getMarkersOfType(DisabledMarker.class).isEmpty());
        SubModuleController controller = new SubModuleController();
        node.setNavigationNodeController((INavigationNodeController)controller);
        controller.setNavigationNode((ISubModuleNode)node);
        Shell shell = new Shell();
        Label label = new Label((Composite)shell, 0);
        label.setData("binding_property", (Object)"0815");
        LabelRidget ridget = new LabelRidget(label);
        controller.addRidget("0815", (IRidget)ridget);
        attribute = new UIFilterRuleRidgetHiddenMarker("*0815");
        ReflectionUtils.invokeHidden((Object)applier, (String)"applyFilterRule", (Object[])new Object[]{node, attribute, closure});
        NavigationUIFilterApplierTest.assertFalse((boolean)ridget.getMarkersOfType(HiddenMarker.class).isEmpty());
        shell.dispose();
    }
}

