/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import java.math.BigInteger;
import junit.framework.TestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.tests.collect.UITestCase;
import org.eclipse.riena.ui.swt.EmbeddedTitleBar;
import org.eclipse.riena.ui.swt.lnf.renderer.EmbeddedTitlebarRenderer;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class EmbeddedTitleBarTest
extends TestCase {
    private Shell shell;
    private EmbeddedTitleBarMock titleBar;

    protected void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
        this.titleBar = new EmbeddedTitleBarMock((Composite)this.shell, 0);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        SwtUtilities.disposeWidget((Widget)this.titleBar);
        SwtUtilities.disposeWidget((Widget)this.shell);
    }

    public void testAddListeners() {
        EmbeddedTitleBarTest.assertEquals((int)1, (int)this.titleBar.getListeners(9).length);
    }

    public void testGetLnfTitlebarRenderer() {
        EmbeddedTitlebarRenderer renderer = (EmbeddedTitlebarRenderer)ReflectionUtils.invokeHidden((Object)((Object)this.titleBar), (String)"getLnfTitlebarRenderer", (Object[])new Object[0]);
        EmbeddedTitleBarTest.assertNotNull((Object)renderer);
    }

    public void testSetTitle() {
        this.titleBar.setTitle("Hello");
        this.titleBar.resetRedrawCalled();
        this.titleBar.setTitle("Hello");
        EmbeddedTitleBarTest.assertFalse((boolean)this.titleBar.isRedrawCalled());
        this.titleBar.setTitle("Hi");
        EmbeddedTitleBarTest.assertTrue((boolean)this.titleBar.isRedrawCalled());
    }

    public void testSetActive() {
        this.titleBar.setWindowActive(true);
        this.titleBar.resetRedrawCalled();
        this.titleBar.setWindowActive(true);
        EmbeddedTitleBarTest.assertFalse((boolean)this.titleBar.isRedrawCalled());
        this.titleBar.setWindowActive(false);
        EmbeddedTitleBarTest.assertTrue((boolean)this.titleBar.isRedrawCalled());
    }

    public void testSetCloseable() {
        this.titleBar.setCloseable(true);
        this.titleBar.resetRedrawCalled();
        this.titleBar.setCloseable(true);
        EmbeddedTitleBarTest.assertFalse((boolean)this.titleBar.isRedrawCalled());
        this.titleBar.setCloseable(false);
        EmbeddedTitleBarTest.assertTrue((boolean)this.titleBar.isRedrawCalled());
    }

    public void testSetHover() {
        this.titleBar.setHover(true);
        this.titleBar.resetRedrawCalled();
        this.titleBar.setHover(true);
        EmbeddedTitleBarTest.assertFalse((boolean)this.titleBar.isRedrawCalled());
        this.titleBar.setHover(false);
        EmbeddedTitleBarTest.assertTrue((boolean)this.titleBar.isRedrawCalled());
    }

    public void testSetPressed() {
        this.titleBar.setPressed(true);
        this.titleBar.resetRedrawCalled();
        this.titleBar.setPressed(true);
        EmbeddedTitleBarTest.assertFalse((boolean)this.titleBar.isRedrawCalled());
        this.titleBar.setPressed(false);
        EmbeddedTitleBarTest.assertTrue((boolean)this.titleBar.isRedrawCalled());
    }

    public void testHasChanged() {
        String strg1 = "1";
        String strg2 = "2";
        boolean changed = (Boolean)ReflectionUtils.invokeHidden((Object)((Object)this.titleBar), (String)"hasChanged", (Object[])new Object[]{strg1, strg2});
        EmbeddedTitleBarTest.assertTrue((boolean)changed);
        strg2 = "1";
        changed = (Boolean)ReflectionUtils.invokeHidden((Object)((Object)this.titleBar), (String)"hasChanged", (Object[])new Object[]{strg1, strg2});
        EmbeddedTitleBarTest.assertFalse((boolean)changed);
        strg1 = null;
        strg2 = null;
        changed = (Boolean)ReflectionUtils.invokeHidden((Object)((Object)this.titleBar), (String)"hasChanged", (Object[])new Object[]{strg1, strg2});
        EmbeddedTitleBarTest.assertFalse((boolean)changed);
        strg1 = "1";
        changed = (Boolean)ReflectionUtils.invokeHidden((Object)((Object)this.titleBar), (String)"hasChanged", (Object[])new Object[]{strg1, strg2});
        EmbeddedTitleBarTest.assertTrue((boolean)changed);
        strg1 = null;
        strg2 = "1";
        changed = (Boolean)ReflectionUtils.invokeHidden((Object)((Object)this.titleBar), (String)"hasChanged", (Object[])new Object[]{strg1, strg2});
        EmbeddedTitleBarTest.assertTrue((boolean)changed);
        BigInteger bigInt1 = BigInteger.valueOf(1L);
        BigInteger bigInt2 = BigInteger.valueOf(2L);
        changed = (Boolean)ReflectionUtils.invokeHidden((Object)((Object)this.titleBar), (String)"hasChanged", (Object[])new Object[]{bigInt1, bigInt2});
        EmbeddedTitleBarTest.assertTrue((boolean)changed);
        bigInt2 = BigInteger.valueOf(1L);
        changed = (Boolean)ReflectionUtils.invokeHidden((Object)((Object)this.titleBar), (String)"hasChanged", (Object[])new Object[]{bigInt1, bigInt2});
        EmbeddedTitleBarTest.assertFalse((boolean)changed);
        boolean b1 = true;
        boolean b2 = false;
        changed = (Boolean)ReflectionUtils.invokeHidden((Object)((Object)this.titleBar), (String)"hasChanged", (Object[])new Object[]{b1, b2});
        EmbeddedTitleBarTest.assertTrue((boolean)changed);
        b2 = true;
        changed = (Boolean)ReflectionUtils.invokeHidden((Object)((Object)this.titleBar), (String)"hasChanged", (Object[])new Object[]{b1, b2});
        EmbeddedTitleBarTest.assertFalse((boolean)changed);
        int i1 = 11;
        int i2 = 12;
        changed = (Boolean)ReflectionUtils.invokeHidden((Object)((Object)this.titleBar), (String)"hasChanged", (Object[])new Object[]{i1, i2});
        EmbeddedTitleBarTest.assertTrue((boolean)changed);
        i2 = 11;
        changed = (Boolean)ReflectionUtils.invokeHidden((Object)((Object)this.titleBar), (String)"hasChanged", (Object[])new Object[]{i1, i2});
        EmbeddedTitleBarTest.assertFalse((boolean)changed);
    }

    private static class EmbeddedTitleBarMock
    extends EmbeddedTitleBar {
        private boolean redrawCalled;

        public EmbeddedTitleBarMock(Composite parent, int style) {
            super(parent, style);
            this.resetRedrawCalled();
        }

        public void resetRedrawCalled() {
            this.redrawCalled = false;
        }

        public boolean isRedrawCalled() {
            return this.redrawCalled;
        }

        public void redraw() {
            super.redraw();
            this.redrawCalled = true;
        }
    }
}

