/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.security.common.authentication;

import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.login.LoginException;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.internal.security.common.Activator;
import org.eclipse.riena.security.common.ISubjectHolderService;
import org.eclipse.riena.security.common.authentication.AuthenticationFailure;
import org.eclipse.riena.security.common.authentication.AuthenticationTicket;
import org.eclipse.riena.security.common.authentication.Callback2CredentialConverter;
import org.eclipse.riena.security.common.authentication.IAuthenticationService;
import org.eclipse.riena.security.common.authentication.credentials.AbstractCredential;

public class RemoteLoginProxy {
    private IAuthenticationService authenticationService;
    private ISubjectHolderService subjectHolderService;
    private final String loginContext;
    private AuthenticationTicket ticket;
    private Subject subject;

    public RemoteLoginProxy(String loginContext, Subject subject) {
        this.loginContext = loginContext;
        this.subject = subject;
        Inject.service((String)IAuthenticationService.class.getName()).useRanking().into((Object)this).andStart(Activator.getDefault().getContext());
        Inject.service((String)ISubjectHolderService.class.getName()).useRanking().into((Object)this).andStart(Activator.getDefault().getContext());
    }

    public void bind(IAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void unbind(IAuthenticationService authenticationService) {
        if (this.authenticationService == authenticationService) {
            authenticationService = null;
        }
    }

    public void bind(ISubjectHolderService subjectHolderService) {
        this.subjectHolderService = subjectHolderService;
    }

    public void unbind(ISubjectHolderService subjectHolderService) {
        if (this.subjectHolderService == subjectHolderService) {
            this.subjectHolderService = null;
        }
    }

    public boolean login(Callback[] callbacks) throws LoginException {
        try {
            AbstractCredential[] creds = Callback2CredentialConverter.callbacks2Credentials(callbacks);
            if (this.authenticationService == null) {
                throw new AuthenticationFailure("no authentication service");
            }
            this.ticket = this.authenticationService.login(this.loginContext, creds);
            for (Principal principal : this.ticket.getPrincipals()) {
                this.subject.getPrincipals().add(principal);
            }
            this.subjectHolderService.fetchSubjectHolder().setSubject(this.subject);
            return true;
        }
        catch (AuthenticationFailure failure) {
            throw new LoginException(failure.getMessage());
        }
    }

    public boolean commit() {
        Set<Principal> pSet = this.subject.getPrincipals();
        for (Principal p : this.ticket.getPrincipals()) {
            pSet.add(p);
        }
        this.subjectHolderService.fetchSubjectHolder().setSubject(this.subject);
        return true;
    }

    public boolean logout() throws LoginException {
        try {
            this.authenticationService.logout();
            this.subject.getPrincipals().clear();
        }
        catch (AuthenticationFailure e) {
            throw new LoginException(e.getMessage());
        }
        return true;
    }
}

