/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSelectableIndexedRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.internal.ui.ridgets.swt.OutputAwareMultipleSelectionObservableList;
import org.eclipse.riena.internal.ui.ridgets.swt.OutputAwareValidator;
import org.eclipse.riena.internal.ui.ridgets.swt.SortableComparator;
import org.eclipse.riena.ui.common.ISortableByColumn;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.databinding.IUnboundPropertyObservable;
import org.eclipse.riena.ui.ridgets.databinding.UnboundPropertyWritableList;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListRidget
extends AbstractSelectableIndexedRidget
implements ITableRidget {
    private final SelectionListener selectionTypeEnforcer = new SelectionTypeEnforcer();
    private final MouseListener doubleClickForwarder = new DoubleClickForwarder();
    private ListenerList<IActionListener> doubleClickListeners;
    private DataBindingContext dbc;
    private Binding viewerSSB;
    private Binding viewerMSB;
    private ListViewer viewer;
    private Class<?> rowBeanClass;
    private IObservableList rowObservables;
    private String renderingMethod;
    private boolean isSortedAscending = true;
    private int sortedColumn = -1;
    private ViewerComparator comparator;

    public ListRidget() {
        this.getSingleSelectionObservable().addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                ListRidget.this.disableMandatoryMarkers(ListRidget.this.hasInput());
            }
        });
        this.getMultiSelectionObservable().addListChangeListener(new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                ListRidget.this.disableMandatoryMarkers(ListRidget.this.hasInput());
            }
        });
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                boolean isEnabled = (Boolean)evt.getNewValue();
                ListRidget.this.updateEnabled(isEnabled);
            }
        });
    }

    @Override
    protected void checkUIControl(Object uiControl) {
        AbstractSWTRidget.assertType(uiControl, org.eclipse.swt.widgets.List.class);
    }

    @Override
    protected void bindUIControl() {
        org.eclipse.swt.widgets.List control = this.getUIControl();
        if (control != null && this.rowObservables != null) {
            this.viewer = new ListViewer(control);
            ObservableListContentProvider viewerCP = new ObservableListContentProvider();
            IObservableMap[] attrMap = BeansObservables.observeMaps((IObservableSet)viewerCP.getKnownElements(), this.rowBeanClass, (String[])new String[]{this.renderingMethod});
            this.viewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(attrMap){

                public String getColumnText(Object element, int columnIndex) {
                    if (MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT && !ListRidget.this.isEnabled()) {
                        return "";
                    }
                    return super.getColumnText(element, columnIndex);
                }
            });
            this.viewer.setContentProvider((IContentProvider)viewerCP);
            this.viewer.setInput((Object)this.rowObservables);
            this.updateComparator();
            this.updateEnabled(this.isEnabled());
            control.addSelectionListener(this.selectionTypeEnforcer);
            control.addMouseListener(this.doubleClickForwarder);
        }
    }

    @Override
    protected void unbindUIControl() {
        org.eclipse.swt.widgets.List control;
        if (this.dbc != null) {
            this.disposeSelectionBindings();
            this.dbc.dispose();
            this.dbc = null;
        }
        if ((control = this.getUIControl()) != null) {
            control.removeSelectionListener(this.selectionTypeEnforcer);
            control.removeMouseListener(this.doubleClickForwarder);
        }
        this.viewer = null;
    }

    @Override
    protected List<?> getRowObservables() {
        return this.rowObservables;
    }

    public org.eclipse.swt.widgets.List getUIControl() {
        return (org.eclipse.swt.widgets.List)super.getUIControl();
    }

    public void addDoubleClickListener(IActionListener listener) {
        Assert.isNotNull((Object)listener, (String)"listener is null");
        if (this.doubleClickListeners == null) {
            this.doubleClickListeners = new ListenerList(IActionListener.class);
        }
        this.doubleClickListeners.add((Object)listener);
    }

    public void bindToModel(IObservableList listObservableValue, Class<? extends Object> rowBeanClass, String[] columnPropertyNames, String[] columnHeaders) {
        this.unbindUIControl();
        this.rowBeanClass = rowBeanClass;
        this.rowObservables = listObservableValue;
        this.renderingMethod = columnPropertyNames[0];
        this.bindUIControl();
    }

    public void bindToModel(Object listBean, String listPropertyName, Class<? extends Object> rowBeanClass, String[] columnPropertyNames, String[] columnHeaders) {
        UnboundPropertyWritableList listObservableValue = new UnboundPropertyWritableList(listBean, listPropertyName);
        this.bindToModel((IObservableList)listObservableValue, rowBeanClass, columnPropertyNames, columnHeaders);
    }

    public void updateFromModel() {
        super.updateFromModel();
        if (this.viewer != null) {
            this.viewer.getControl().setRedraw(false);
            StructuredSelection currentSelection = new StructuredSelection(this.getSelection());
            try {
                if (this.rowObservables instanceof IUnboundPropertyObservable) {
                    ((UnboundPropertyWritableList)this.rowObservables).updateFromBean();
                }
                this.viewer.refresh(true);
            }
            finally {
                this.viewer.setSelection((ISelection)currentSelection);
                this.viewer.getControl().setRedraw(true);
            }
        }
    }

    public IObservableList getObservableList() {
        return this.rowObservables;
    }

    public void removeDoubleClickListener(IActionListener listener) {
        if (this.doubleClickListeners != null) {
            this.doubleClickListeners.remove((Object)listener);
        }
    }

    public void setComparator(int columnIndex, Comparator<Object> comparator) {
        Assert.isLegal((columnIndex == 0 ? 1 : 0) != 0, (String)"columnIndex out of bounds (must be 0)");
        if (comparator != null) {
            SortableComparator sortableComparator = new SortableComparator((ISortableByColumn)this, comparator);
            this.comparator = new ViewerComparator((Comparator)sortableComparator);
        } else {
            this.comparator = null;
        }
        this.updateComparator();
    }

    public int getSortedColumn() {
        return this.comparator != null && this.sortedColumn == 0 ? 0 : -1;
    }

    public boolean isColumnSortable(int columnIndex) {
        Assert.isLegal((columnIndex == 0 ? 1 : 0) != 0, (String)"columnIndex out of bounds (must be 0)");
        return this.comparator != null;
    }

    @Override
    public boolean isDisableMandatoryMarker() {
        return this.hasInput();
    }

    public boolean isSortedAscending() {
        return this.isSortedAscending;
    }

    public final void setColumnSortable(int columnIndex, boolean sortable) {
        throw new UnsupportedOperationException();
    }

    public void setSortedAscending(boolean ascending) {
        if (ascending != this.isSortedAscending) {
            boolean oldSortedAscending = this.isSortedAscending;
            this.isSortedAscending = ascending;
            if (this.viewer != null) {
                this.viewer.refresh();
            }
            this.firePropertyChange("sortAscending", oldSortedAscending, this.isSortedAscending);
        }
    }

    public final void setSortedColumn(int columnIndex) {
        String msg = "columnIndex out of range (-1 - 0): " + columnIndex;
        Assert.isLegal((columnIndex >= -1 && columnIndex <= 0 ? 1 : 0) != 0, (String)msg);
        if (this.sortedColumn != columnIndex) {
            int oldSortedColumn = this.sortedColumn;
            this.sortedColumn = columnIndex;
            this.updateComparator();
            this.firePropertyChange("sortedColumn", oldSortedColumn, this.sortedColumn);
        }
    }

    @Override
    public int getSelectionIndex() {
        org.eclipse.swt.widgets.List control = this.getUIControl();
        return control == null ? -1 : control.getSelectionIndex();
    }

    @Override
    public int[] getSelectionIndices() {
        org.eclipse.swt.widgets.List control = this.getUIControl();
        return control == null ? new int[]{} : control.getSelectionIndices();
    }

    @Override
    public int indexOfOption(Object option) {
        org.eclipse.swt.widgets.List control = this.getUIControl();
        if (control != null) {
            int optionCount = control.getItemCount();
            int i = 0;
            while (i < optionCount) {
                if (this.viewer.getElementAt(i).equals(option)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public final boolean hasMoveableColumns() {
        return false;
    }

    public final void setMoveableColumns(boolean moveableColumns) {
        throw new UnsupportedOperationException("not implemented");
    }

    private void createSelectionBindings() {
        StructuredSelection currentSelection = new StructuredSelection(this.getSelection());
        this.dbc = new DataBindingContext();
        IViewerObservableValue viewerSelection = ViewersObservables.observeSingleSelection((Viewer)this.viewer);
        this.viewerSSB = this.dbc.bindValue((IObservableValue)viewerSelection, this.getSingleSelectionObservable(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setAfterGetValidator((IValidator)new OutputAwareValidator(this)), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        OutputAwareMultipleSelectionObservableList viewerSelections = new OutputAwareMultipleSelectionObservableList(this.dbc.getValidationRealm(), (ISelectionProvider)this.viewer, Object.class, this);
        this.viewerMSB = this.dbc.bindList((IObservableList)viewerSelections, this.getMultiSelectionObservable(), new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE), new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE));
        this.viewer.setSelection((ISelection)currentSelection);
    }

    private void disposeSelectionBindings() {
        if (this.viewerSSB != null && !this.viewerSSB.isDisposed()) {
            this.viewerSSB.dispose();
        }
        if (this.viewerMSB != null && !this.viewerMSB.isDisposed()) {
            this.viewerMSB.dispose();
        }
    }

    private boolean hasInput() {
        return !this.getSelection().isEmpty();
    }

    private void updateComparator() {
        if (this.viewer != null) {
            if (this.sortedColumn == 0) {
                this.viewer.setComparator(this.comparator);
            } else {
                this.viewer.setComparator(null);
            }
        }
    }

    private void updateEnabled(boolean isEnabled) {
        if (isEnabled) {
            if (this.viewer != null && this.rowObservables != null) {
                this.viewer.refresh();
                this.createSelectionBindings();
                org.eclipse.swt.widgets.List list = this.viewer.getList();
                list.setBackground((Color)list.getData("oldbg"));
                list.setData("oldbg", null);
            }
        } else {
            this.disposeSelectionBindings();
            if (this.viewer != null) {
                this.viewer.refresh();
                org.eclipse.swt.widgets.List list = this.viewer.getList();
                if (MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT) {
                    list.deselectAll();
                }
                list.setData("oldbg", (Object)list.getBackground());
                list.setBackground(list.getDisplay().getSystemColor(22));
            }
        }
    }

    private final class DoubleClickForwarder
    extends MouseAdapter {
        private DoubleClickForwarder() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (ListRidget.this.doubleClickListeners != null) {
                IActionListener[] iActionListenerArray = (IActionListener[])ListRidget.this.doubleClickListeners.getListeners();
                int n = iActionListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IActionListener listener = iActionListenerArray[n2];
                    listener.callback();
                    ++n2;
                }
            }
        }
    }

    private final class SelectionTypeEnforcer
    extends SelectionAdapter {
        private SelectionTypeEnforcer() {
        }

        public void widgetSelected(SelectionEvent e) {
            org.eclipse.swt.widgets.List control = (org.eclipse.swt.widgets.List)e.widget;
            if (ListRidget.this.isOutputOnly()) {
                this.revertSelection(control);
            } else if (ISelectableRidget.SelectionType.SINGLE.equals((Object)ListRidget.this.getSelectionType()) && control.getSelectionCount() > 1) {
                e.doit = false;
                this.selectFirstItem(control);
            }
        }

        private void selectFirstItem(org.eclipse.swt.widgets.List control) {
            control.setSelection(control.getSelectionIndex());
            Event event = new Event();
            event.type = 13;
            event.doit = true;
            control.notifyListeners(13, event);
        }

        private void revertSelection(org.eclipse.swt.widgets.List control) {
            control.setRedraw(false);
            try {
                ListRidget.this.viewer.setSelection((ISelection)new StructuredSelection(ListRidget.this.getSelection()));
            }
            finally {
                control.setRedraw(true);
            }
        }
    }
}

