/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.ui.ridgets.AbstractRidget;
import org.eclipse.riena.ui.ridgets.IWindowRidget;
import org.eclipse.riena.ui.ridgets.UIBindingFailure;
import org.eclipse.riena.ui.ridgets.listener.IWindowRidgetListener;
import org.eclipse.riena.ui.swt.utils.ImageUtil;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;

public class ShellRidget
extends AbstractRidget
implements IWindowRidget {
    private static Image missingImage;
    private Shell shell;
    private String toolTip = null;
    private boolean blocked;
    private boolean closeable = true;
    private boolean active = true;
    private String title = "";
    private String icon;
    private ListenerList<IWindowRidgetListener> windowRidgetListeners = new ListenerList(IWindowRidgetListener.class);
    private ShellListener shellListener = new RidgetShellListener();

    public ShellRidget() {
    }

    public ShellRidget(Shell shell) {
        this();
        this.setUIControl(shell);
    }

    public Shell getUIControl() {
        return this.shell;
    }

    public void setUIControl(Object uiControl) {
        if (uiControl != null && !(uiControl instanceof Shell)) {
            throw new UIBindingFailure("uiControl of a ShellRidget must be a Shell but was a " + uiControl.getClass().getSimpleName());
        }
        this.removeShellListener();
        this.shell = (Shell)uiControl;
        this.addShellListener();
        this.updateToolTip();
    }

    private void addShellListener() {
        if (this.getUIControl() != null) {
            this.getUIControl().addShellListener(this.shellListener);
        }
    }

    private void removeShellListener() {
        if (this.getUIControl() != null) {
            this.getUIControl().removeShellListener(this.shellListener);
        }
    }

    public void addWindowRidgetListener(IWindowRidgetListener listener) {
        this.windowRidgetListeners.add((Object)listener);
    }

    public void removeWindowRidgetListener(IWindowRidgetListener listener) {
        this.windowRidgetListeners.remove((Object)listener);
    }

    public boolean isVisible() {
        return this.getUIControl().isVisible();
    }

    public void setVisible(boolean visible) {
        this.getUIControl().setVisible(visible);
    }

    public void dispose() {
        this.getUIControl().dispose();
    }

    public void setTitle(String title) {
        if (title != null && !this.title.equals(title)) {
            this.title = title;
            this.updateTitle();
        }
    }

    private void updateTitle() {
        if (this.getUIControl() != null) {
            this.getUIControl().setText(this.title);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setIcon(String icon) {
        String oldIcon = this.icon;
        this.icon = icon;
        if (this.hasChanged(oldIcon, icon)) {
            this.updateIcon();
        }
    }

    private void updateIcon() {
        Shell control = this.getUIControl();
        if (control != null) {
            Image image = null;
            if (this.icon != null) {
                image = this.getManagedImage(this.icon);
            }
            control.setImage(image);
        }
    }

    protected Image getManagedImage(String key) {
        Image image = ImageUtil.getImage((String)key);
        if (image == null) {
            image = this.getMissingImage();
        }
        return image;
    }

    public final synchronized Image getMissingImage() {
        if (missingImage == null) {
            missingImage = ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        return missingImage;
    }

    protected boolean hasChanged(Object oldValue, Object newValue) {
        if (oldValue == null && newValue == null) {
            return false;
        }
        if (oldValue == null || newValue == null) {
            return true;
        }
        return !oldValue.equals(newValue);
    }

    public void setDefaultButton(Object defaultButton) {
        if (defaultButton instanceof Button) {
            this.getUIControl().setDefaultButton((Button)defaultButton);
        }
    }

    public Object getDefaultButton() {
        return this.getUIControl().getDefaultButton();
    }

    public void requestFocus() {
        if (this.getUIControl() != null) {
            this.getUIControl().setFocus();
        }
    }

    public boolean hasFocus() {
        if (this.getUIControl() != null) {
            return this.getUIControl().isFocusControl();
        }
        return false;
    }

    public boolean isFocusable() {
        return false;
    }

    public void setFocusable(boolean focusable) {
    }

    public String getToolTipText() {
        return this.toolTip;
    }

    public void setToolTipText(String toolTipText) {
        String oldValue = this.toolTip;
        this.toolTip = toolTipText;
        this.updateToolTip();
        this.firePropertyChange("tooltip", oldValue, this.toolTip);
    }

    private void updateToolTip() {
        if (this.getUIControl() != null) {
            this.getUIControl().setToolTipText(this.toolTip);
        }
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean blocked) {
        if (this.blocked != blocked) {
            this.blocked = blocked;
        }
    }

    public void setActive(boolean active) {
        if (this.active != active) {
            this.active = active;
            this.updateActive();
        }
    }

    public void setCloseable(boolean closeable) {
        if (this.closeable != closeable) {
            this.closeable = closeable;
            this.updateCloseable();
        }
    }

    private void updateCloseable() {
    }

    private void updateActive() {
        if (this.getUIControl() != null) {
            this.getUIControl().setEnabled(this.active);
        }
    }

    public void updateFromModel() {
        super.updateFromModel();
        if (this.getUIControl() != null) {
            this.updateTitle();
            this.updateIcon();
            this.updateActive();
        }
    }

    public String getID() {
        if (this.getUIControl() != null) {
            SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
            return locator.locateBindingProperty((Object)this.getUIControl());
        }
        return null;
    }

    private class RidgetShellListener
    implements ShellListener {
        private RidgetShellListener() {
        }

        public void shellActivated(ShellEvent e) {
            IWindowRidgetListener[] iWindowRidgetListenerArray = (IWindowRidgetListener[])ShellRidget.this.windowRidgetListeners.getListeners();
            int n = iWindowRidgetListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWindowRidgetListener l = iWindowRidgetListenerArray[n2];
                l.activated();
                ++n2;
            }
        }

        public void shellClosed(ShellEvent e) {
            IWindowRidgetListener[] iWindowRidgetListenerArray = (IWindowRidgetListener[])ShellRidget.this.windowRidgetListeners.getListeners();
            int n = iWindowRidgetListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWindowRidgetListener l = iWindowRidgetListenerArray[n2];
                l.closed();
                ++n2;
            }
        }

        public void shellDeactivated(ShellEvent e) {
        }

        public void shellDeiconified(ShellEvent e) {
        }

        public void shellIconified(ShellEvent e) {
        }
    }
}

