/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractEditableRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.ValueBindingSupport;
import org.eclipse.riena.ui.ridgets.validation.ValidationRuleStatus;
import org.eclipse.riena.ui.ridgets.validation.ValidatorCollection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class TextRidget
extends AbstractEditableRidget
implements ITextRidget {
    private static final String EMPTY_STRING = "";
    private final FocusListener focusListener;
    private final KeyListener crKeyListener = new CRKeyListener();
    private final ModifyListener modifyListener;
    private final ValidationListener verifyListener;
    private String textValue = "";
    private boolean isDirectWriting = false;

    public TextRidget() {
        this.focusListener = new FocusManager();
        this.modifyListener = new SyncModifyListener();
        this.verifyListener = new ValidationListener();
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                TextRidget.this.forceTextToControl(TextRidget.this.getTextInternal());
            }
        });
        this.addPropertyChangeListener("output", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Text control = TextRidget.this.getUIControl();
                if (control != null && !control.isDisposed()) {
                    control.setEditable(!TextRidget.this.isOutputOnly());
                }
            }
        });
    }

    protected TextRidget(String initialValue) {
        this();
        Assert.isNotNull((Object)initialValue);
        this.textValue = initialValue;
    }

    IObservableValue getRidgetObservable() {
        return BeansObservables.observeValue((Object)((Object)this), (String)"text");
    }

    protected void checkUIControl(Object uiControl) {
        AbstractSWTRidget.assertType(uiControl, Text.class);
    }

    protected boolean isNotEmpty(String input) {
        return input.length() > 0;
    }

    protected final synchronized void bindUIControl() {
        Text control = this.getUIControl();
        if (control != null) {
            control.setText(this.textValue);
            control.setSelection(0, 0);
            control.setEditable(!this.isOutputOnly());
            this.addListeners(control);
        }
    }

    protected final synchronized void unbindUIControl() {
        Text control = this.getUIControl();
        if (control != null) {
            this.removeListeners(control);
        }
    }

    protected synchronized void addListeners(Text control) {
        control.addKeyListener(this.crKeyListener);
        control.addFocusListener(this.focusListener);
        control.addModifyListener(this.modifyListener);
        control.addVerifyListener((VerifyListener)this.verifyListener);
    }

    protected synchronized void removeListeners(Text control) {
        control.removeKeyListener(this.crKeyListener);
        control.removeFocusListener(this.focusListener);
        control.removeModifyListener(this.modifyListener);
        control.removeVerifyListener((VerifyListener)this.verifyListener);
    }

    public Text getUIControl() {
        return (Text)super.getUIControl();
    }

    public synchronized String getText() {
        return this.textValue;
    }

    public synchronized void setText(String text) {
        Assert.isNotNull((Object)text);
        String oldValue = this.textValue;
        this.textValue = text;
        this.forceTextToControl(this.textValue);
        this.disableMandatoryMarkers(this.isNotEmpty(this.textValue));
        IStatus onEdit = this.checkOnEditRules(text);
        this.validationRulesCheckedMarkFlash(onEdit);
        if (onEdit.isOK()) {
            this.firePropertyChange("text", oldValue, this.textValue);
        }
    }

    public synchronized boolean revalidate() {
        Text control = this.getUIControl();
        String text = control != null ? control.getText() : this.textValue;
        this.textValue = null;
        this.setText(text);
        return !this.isErrorMarked();
    }

    public synchronized void updateFromModel() {
        super.updateFromModel();
        IStatus onEdit = this.checkOnEditRules(this.textValue);
        IStatus onUpdate = this.checkOnUpdateRules(this.textValue);
        IStatus joinedStatus = ValidationRuleStatus.join((IStatus[])new IStatus[]{onEdit, onUpdate});
        this.validationRulesCheckedMarkFlash(joinedStatus);
    }

    public synchronized boolean isDirectWriting() {
        return this.isDirectWriting;
    }

    public synchronized void setDirectWriting(boolean directWriting) {
        if (this.isDirectWriting != directWriting) {
            this.isDirectWriting = directWriting;
        }
    }

    public final boolean isDisableMandatoryMarker() {
        return this.isNotEmpty(this.textValue);
    }

    public int getAlignment() {
        throw new UnsupportedOperationException("not implemented");
    }

    public final void setAlignment(int alignment) {
        throw new UnsupportedOperationException("not supported");
    }

    private IStatus checkOnEditRules(String newValue) {
        ValueBindingSupport vbs = this.getValueBindingSupport();
        ValidatorCollection onEditValidators = vbs.getOnEditValidators();
        IStatus result = onEditValidators.validate((Object)newValue);
        return result;
    }

    private IStatus checkOnUpdateRules(String newValue) {
        ValueBindingSupport vbs = this.getValueBindingSupport();
        ValidatorCollection afterGetValidators = vbs.getAfterGetValidators();
        IStatus result = afterGetValidators.validate((Object)newValue);
        return result;
    }

    private synchronized void forceTextToControl(String newValue) {
        Text control = this.getUIControl();
        if (control != null) {
            Listener[] listeners;
            Listener[] listenerArray = listeners = control.getListeners(25);
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Listener listener = listenerArray[n2];
                control.removeListener(25, listener);
                ++n2;
            }
            boolean hideValue = !this.isEnabled() && MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT;
            control.setText(hideValue ? EMPTY_STRING : newValue);
            control.setSelection(0, 0);
            Listener[] listenerArray2 = listeners;
            int n3 = listeners.length;
            n = 0;
            while (n < n3) {
                Listener listener = listenerArray2[n];
                control.addListener(25, listener);
                ++n;
            }
        }
    }

    private synchronized String getTextInternal() {
        return this.textValue;
    }

    private IStatus suppressBlockWithFlash(IStatus status) {
        Object theStatus = status.getCode() == 1024 ? new Status(status.getSeverity(), status.getPlugin(), 1025, status.getMessage(), status.getException()) : status;
        return theStatus;
    }

    private synchronized void updateTextValue() {
        String oldValue = this.textValue;
        String newValue = this.getUIControl().getText();
        if (!oldValue.equals(newValue)) {
            this.textValue = newValue;
            if (this.checkOnEditRules(newValue).isOK()) {
                this.firePropertyChange("text", oldValue, newValue);
            }
        }
    }

    private synchronized void updateTextValueWhenDirectWriting() {
        if (this.isDirectWriting) {
            this.updateTextValue();
        }
    }

    private void validationRulesCheckedMarkFlash(IStatus status) {
        IStatus newStatus = this.suppressBlockWithFlash(status);
        this.validationRulesChecked(newStatus);
    }

    private final class CRKeyListener
    extends KeyAdapter
    implements KeyListener {
        private CRKeyListener() {
        }

        public void keyReleased(KeyEvent e) {
            if (e.character == '\r') {
                TextRidget.this.updateTextValue();
            }
        }
    }

    private final class FocusManager
    implements FocusListener {
        private FocusManager() {
        }

        public void focusGained(FocusEvent e) {
            Text text;
            if (TextRidget.this.isFocusable() && ((text = (Text)e.getSource()).getStyle() & 2) == 0) {
                text.selectAll();
            }
        }

        public void focusLost(FocusEvent e) {
            TextRidget.this.updateTextValue();
        }
    }

    private final class SyncModifyListener
    implements ModifyListener {
        private SyncModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            TextRidget.this.updateTextValueWhenDirectWriting();
            String text = ((Text)e.widget).getText();
            TextRidget.this.disableMandatoryMarkers(TextRidget.this.isNotEmpty(text));
        }
    }

    private final class ValidationListener
    implements VerifyListener {
        private ValidationListener() {
        }

        public synchronized void verifyText(VerifyEvent e) {
            boolean doit;
            if (!e.doit) {
                return;
            }
            String newText = this.getText(e);
            IStatus status = TextRidget.this.checkOnEditRules(newText);
            e.doit = doit = status.getCode() != 1024;
            TextRidget.this.validationRulesChecked(status);
        }

        private String getText(VerifyEvent e) {
            Text widget = (Text)e.widget;
            String oldText = widget.getText();
            String newText = e.keyCode == 127 || e.keyCode == 8 ? String.valueOf(oldText.substring(0, e.start)) + oldText.substring(e.end) : String.valueOf(oldText.substring(0, e.start)) + e.text + oldText.substring(e.end);
            return newText;
        }
    }
}

