/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.TreeRidget;

public final class TreeRidgetContentProvider
extends ObservableListTreeContentProvider {
    private final TreeViewer viewer;
    private boolean hasInput = false;
    private PropertyChangeListener listener;

    public TreeRidgetContentProvider(TreeViewer viewer, IObservableFactory listFactory, TreeStructureAdvisor structureAdvisor) {
        super(listFactory, structureAdvisor);
        Assert.isNotNull((Object)viewer);
        this.viewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof TreeRidget.FakeRoot) {
            return ((TreeRidget.FakeRoot)inputElement).toArray();
        }
        return (Object[])inputElement;
    }

    public synchronized void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        boolean bl = this.hasInput = newInput != null;
        if (oldInput instanceof TreeRidget.FakeRoot) {
            this.removePropertyChangeListener((TreeRidget.FakeRoot)oldInput);
        }
        if (newInput instanceof TreeRidget.FakeRoot) {
            this.addPropertyChangeListener((TreeRidget.FakeRoot)newInput);
        }
        super.inputChanged(viewer, oldInput, newInput);
    }

    public boolean hasInput() {
        return this.hasInput;
    }

    private synchronized void removePropertyChangeListener(TreeRidget.FakeRoot fakeRoot) {
        if (this.listener != null) {
            ReflectionUtils.invoke((Object)fakeRoot.getRoot(), (String)"removePropertyChangeListener", (Object[])new Object[]{this.listener});
            this.listener = null;
        }
    }

    private synchronized void addPropertyChangeListener(final TreeRidget.FakeRoot fakeRoot) {
        Assert.isLegal((this.listener == null ? 1 : 0) != 0);
        this.listener = new PropertyChangeListener(){
            private final String accessor;
            {
                this.accessor = fakeRoot2.getChildrenAccessor().toUpperCase();
            }

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().toUpperCase().endsWith(this.accessor)) {
                    fakeRoot.refresh();
                    TreeRidgetContentProvider.this.viewer.refresh((Object)fakeRoot);
                }
            }
        };
        ReflectionUtils.invoke((Object)fakeRoot.getRoot(), (String)"addPropertyChangeListener", (Object[])new Object[]{this.listener});
    }
}

