/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.swt;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.internal.databinding.provisional.swt.AbstractSWTObservableValue;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

public class SpinnerObservableValue
extends AbstractSWTObservableValue {
    private final Spinner spinner;
    private final String attribute;
    private boolean updating = false;
    private int currentSelection;
    private ModifyListener modifyListener;

    public SpinnerObservableValue(Spinner spinner, String attribute) {
        super((Widget)spinner);
        this.spinner = spinner;
        this.attribute = attribute;
        this.init();
    }

    public SpinnerObservableValue(Realm realm, Spinner spinner, String attribute) {
        super(realm, (Widget)spinner);
        this.spinner = spinner;
        this.attribute = attribute;
        this.init();
    }

    private void init() {
        if (this.attribute.equals("selection")) {
            this.currentSelection = this.spinner.getSelection();
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!SpinnerObservableValue.this.updating) {
                        int newSelection = SpinnerObservableValue.this.spinner.getSelection();
                        SpinnerObservableValue.this.notifyIfChanged(SpinnerObservableValue.this.currentSelection, newSelection);
                        SpinnerObservableValue.this.currentSelection = newSelection;
                    }
                }
            };
            this.spinner.addModifyListener(this.modifyListener);
        } else if (!this.attribute.equals("min") && !this.attribute.equals("max")) {
            throw new IllegalArgumentException("Attribute name not valid: " + this.attribute);
        }
    }

    public void doSetValue(Object value) {
        try {
            int oldValue;
            this.updating = true;
            int newValue = (Integer)value;
            if (this.attribute.equals("selection")) {
                oldValue = this.spinner.getSelection();
                this.spinner.setSelection(newValue);
                this.currentSelection = newValue;
            } else if (this.attribute.equals("min")) {
                oldValue = this.spinner.getMinimum();
                this.spinner.setMinimum(newValue);
            } else if (this.attribute.equals("max")) {
                oldValue = this.spinner.getMaximum();
                this.spinner.setMaximum(newValue);
            } else {
                Assert.isTrue((boolean)false, (String)("invalid attribute name:" + this.attribute));
                return;
            }
            this.notifyIfChanged(oldValue, newValue);
        }
        finally {
            this.updating = false;
        }
    }

    public Object doGetValue() {
        int value = 0;
        if (this.attribute.equals("selection")) {
            value = this.spinner.getSelection();
        } else if (this.attribute.equals("min")) {
            value = this.spinner.getMinimum();
        } else if (this.attribute.equals("max")) {
            value = this.spinner.getMaximum();
        }
        return new Integer(value);
    }

    public Object getValueType() {
        return Integer.TYPE;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public synchronized void dispose() {
        super.dispose();
        if (this.modifyListener != null && !this.spinner.isDisposed()) {
            this.spinner.removeModifyListener(this.modifyListener);
        }
    }

    private void notifyIfChanged(int oldValue, int newValue) {
        if (oldValue != newValue) {
            this.fireValueChange(Diffs.createValueDiff((Object)new Integer(oldValue), (Object)new Integer(newValue)));
        }
    }
}

