/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.publisher;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.communication.core.RemoteServiceDescription;
import org.eclipse.riena.communication.core.publisher.IServicePublishBinder;
import org.eclipse.riena.communication.core.publisher.IServicePublisher;
import org.eclipse.riena.internal.communication.publisher.Activator;
import org.eclipse.riena.internal.communication.publisher.ServiceHooksProxy;
import org.osgi.framework.ServiceReference;

public class ServicePublishBinder
implements IServicePublishBinder {
    private Map<String, IServicePublisher> servicePublishers = new HashMap<String, IServicePublisher>();
    private List<RemoteServiceDescription> unpublishedServices = new ArrayList<RemoteServiceDescription>();
    private Map<String, RemoteServiceDescription> rsDescs = new HashMap<String, RemoteServiceDescription>();
    private static final Logger LOGGER = Activator.getDefault().getLogger(ServicePublishBinder.class);

    public void bind(IServicePublisher publisher) {
        this.servicePublishers.put(publisher.getProtocol(), publisher);
        if (this.unpublishedServices.size() > 0) {
            LOGGER.log(4, "servicePublish=" + publisher.getProtocol() + " REGISTER...publishing all services that were waiting for him");
        } else {
            LOGGER.log(4, "servicePublish=" + publisher.getProtocol() + " REGISTER...no unpublished services waiting for this protocol");
        }
        this.checkUnpublishedServices(publisher.getProtocol());
    }

    public void unbind(IServicePublisher publisher) {
        String protocol = publisher.getProtocol();
        LOGGER.log(4, "servicePublish=" + publisher.getProtocol() + " UNREGISTER...unpublishing all its services");
        this.servicePublishers.remove(protocol);
    }

    private void checkUnpublishedServices(String protocol) {
        ArrayList<RemoteServiceDescription> removedItems = new ArrayList<RemoteServiceDescription>();
        for (RemoteServiceDescription rsd : this.unpublishedServices) {
            if (!rsd.getProtocol().equals(protocol)) continue;
            this.publish(rsd);
            removedItems.add(rsd);
        }
        for (RemoteServiceDescription item : removedItems) {
            this.unpublishedServices.remove(item);
        }
    }

    public void publish(ServiceReference ref, String url, String protocol) {
        String[] interfaces = (String[])ref.getProperty("objectClass");
        assert (interfaces.length == 1) : "OSGi service registrations only with one interface supported";
        String interfaceName = interfaces[0];
        this.publish(interfaceName, ref, url, protocol);
    }

    public void unpublish(ServiceReference serviceRef) {
        for (RemoteServiceDescription rsd : this.rsDescs.values()) {
            if (!serviceRef.equals(rsd.getServiceRef())) continue;
            IServicePublisher servicePublisher = this.servicePublishers.get(rsd.getProtocol());
            if (servicePublisher != null) {
                servicePublisher.unpublishService(rsd);
            }
            this.rsDescs.remove(String.valueOf(rsd.getProtocol()) + "::" + rsd.getPath());
            return;
        }
    }

    public void publish(String interfaceName, ServiceReference serviceRef, String path, String protocol) {
        try {
            Class interfaceClazz = serviceRef.getBundle().loadClass(interfaceName);
            RemoteServiceDescription rsd = new RemoteServiceDescription(serviceRef, Activator.getDefault().getContext().getService(serviceRef), interfaceClazz);
            rsd.setService(Activator.getDefault().getContext().getService(serviceRef));
            rsd.setPath(path);
            rsd.setProtocol(protocol);
            this.publish(rsd);
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(2, "Could not load class for remote service interface for service reference" + serviceRef, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publish(RemoteServiceDescription rsd) {
        Map<String, RemoteServiceDescription> map = this.rsDescs;
        synchronized (map) {
            ServiceHooksProxy handler = new ServiceHooksProxy(rsd.getService());
            Object service = Proxy.newProxyInstance(rsd.getServiceInterfaceClass().getClassLoader(), new Class[]{rsd.getServiceInterfaceClass()}, (InvocationHandler)handler);
            rsd.setService(service);
            handler.setRemoteServiceDescription(rsd);
            RemoteServiceDescription rsDescFound = this.rsDescs.get(String.valueOf(rsd.getProtocol()) + "::" + rsd.getPath());
            if (rsDescFound != null) {
                LOGGER.log(2, "A service endpoint with path=[" + rsd.getPath() + "] and remoteType=[" + rsd.getProtocol() + "] already published... ignored");
                return;
            }
            if (rsd.getPath() == null) {
                LOGGER.log(2, "no path for service: " + service.toString() + " Service not published remote");
                return;
            }
            IServicePublisher servicePublisher = this.servicePublishers.get(rsd.getProtocol());
            if (servicePublisher == null) {
                LOGGER.log(3, "no publisher found for protocol " + rsd.getProtocol());
                this.unpublishedServices.add(rsd);
                return;
            }
            String url = null;
            try {
                url = servicePublisher.publishService(rsd);
            }
            catch (RuntimeException e) {
                LOGGER.log(1, e.getMessage());
                return;
            }
            rsd.setURL(url);
            handler.setMessageContextAccessor(servicePublisher.getMessageContextAccessor());
            this.rsDescs.put(String.valueOf(rsd.getProtocol()) + "::" + rsd.getPath(), rsd);
            LOGGER.log(4, "service endpoints count: " + this.rsDescs.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteServiceDescription[] getAllServices() {
        RemoteServiceDescription[] result = new RemoteServiceDescription[this.rsDescs.size()];
        Map<String, RemoteServiceDescription> map = this.rsDescs;
        synchronized (map) {
            this.rsDescs.values().toArray(result);
        }
        return result;
    }
}

