/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Comparator;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonManager;
import org.eclipse.riena.internal.example.client.beans.PersonFactory;
import org.eclipse.riena.internal.example.client.beans.PersonModificationBean;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;

public class ListSubModuleController
extends SubModuleController {
    private final PersonManager manager = new PersonManager(PersonFactory.createPersonList());
    private final PersonModificationBean value;

    public ListSubModuleController() {
        this(null);
    }

    public ListSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
        this.manager.setSelectedPerson((Person)this.manager.getPersons().iterator().next());
        this.value = new PersonModificationBean();
    }

    public void configureRidgets() {
        final ITableRidget listPersons = (ITableRidget)this.getRidget("listPersons");
        listPersons.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        listPersons.setComparator(0, (Comparator)new StringComparator());
        listPersons.setSortedColumn(0);
        listPersons.bindToModel((Object)this.manager, "persons", Person.class, new String[]{"listEntry"}, new String[]{""});
        listPersons.updateFromModel();
        listPersons.bindSingleSelectionToModel((Object)this.manager, "selectedPerson");
        final ITextRidget textFirst = (ITextRidget)this.getRidget("textFirst");
        textFirst.bindToModel((Object)this.value, "firstName");
        textFirst.updateFromModel();
        final ITextRidget textLast = (ITextRidget)this.getRidget("textLast");
        textLast.bindToModel((Object)this.value, "lastName");
        textLast.updateFromModel();
        listPersons.addPropertyChangeListener("selection", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ListSubModuleController.this.value.setPerson(ListSubModuleController.this.manager.getSelectedPerson());
                textFirst.updateFromModel();
                textLast.updateFromModel();
            }
        });
        final IToggleButtonRidget buttonSort = (IToggleButtonRidget)this.getRidget("buttonSort");
        buttonSort.setText("Sort ascending");
        buttonSort.setSelected(true);
        listPersons.setSortedAscending(buttonSort.isSelected());
        buttonSort.addListener(new IActionListener(){

            public void callback() {
                boolean ascending = buttonSort.isSelected();
                listPersons.setSortedAscending(ascending);
            }
        });
        IActionRidget buttonAdd = (IActionRidget)this.getRidget("buttonAdd");
        buttonAdd.setText("&Add");
        buttonAdd.addListener(new IActionListener(){
            private int count = 0;

            public void callback() {
                Person newPerson = new Person("Average", "Joe #" + ++this.count);
                ListSubModuleController.this.manager.getPersons().add(newPerson);
                listPersons.updateFromModel();
                ListSubModuleController.this.manager.setSelectedPerson(newPerson);
                listPersons.updateSingleSelectionFromModel();
            }
        });
        IActionRidget buttonRemove = (IActionRidget)this.getRidget("buttonRemove");
        buttonRemove.setText("&Remove");
        buttonRemove.addListener(new IActionListener(){

            public void callback() {
                Person selPerson = ListSubModuleController.this.manager.getSelectedPerson();
                if (selPerson != null) {
                    ListSubModuleController.this.manager.getPersons().remove(selPerson);
                    listPersons.updateFromModel();
                    ListSubModuleController.this.manager.setSelectedPerson(null);
                }
            }
        });
        IActionRidget buttonSave = (IActionRidget)this.getRidget("buttonSave");
        buttonSave.setText("&Save");
        buttonSave.addListener(new IActionListener(){

            public void callback() {
                ListSubModuleController.this.value.update();
                listPersons.updateFromModel();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StringComparator
    implements Comparator<Object>,
    Serializable {
        private StringComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s1.compareTo(s2);
        }
    }
}

