/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.cm;

import org.eclipse.equinox.internal.cm.SerializedTaskQueue;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class EventDispatcher {
    final ServiceTracker tracker;
    private final SerializedTaskQueue queue = new SerializedTaskQueue("ConfigurationListener Event Queue");
    private ServiceReference configAdminReference;
    final LogService log;
    static /* synthetic */ Class class$0;

    public EventDispatcher(BundleContext context, LogService log) {
        this.log = log;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.cm.ConfigurationListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.tracker = new ServiceTracker(context, clazz.getName(), null);
    }

    public void start() {
        this.tracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.tracker.close();
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            this.configAdminReference = null;
        }
    }

    synchronized void setServiceReference(ServiceReference reference) {
        if (this.configAdminReference == null) {
            this.configAdminReference = reference;
        }
    }

    public void dispatchEvent(int type, String factoryPid, String pid) {
        final ConfigurationEvent event = this.createConfigurationEvent(type, factoryPid, pid);
        if (event == null) {
            return;
        }
        ServiceReference[] refs = this.tracker.getServiceReferences();
        if (refs == null) {
            return;
        }
        int i = 0;
        while (i < refs.length) {
            final ServiceReference ref = refs[i];
            this.queue.put(new Runnable(){

                public void run() {
                    ConfigurationListener listener = (ConfigurationListener)EventDispatcher.this.tracker.getService(ref);
                    if (listener == null) {
                        return;
                    }
                    try {
                        listener.configurationEvent(event);
                    }
                    catch (Throwable t) {
                        EventDispatcher.this.log.log(1, t.getMessage(), t);
                    }
                }
            });
            ++i;
        }
    }

    private synchronized ConfigurationEvent createConfigurationEvent(int type, String factoryPid, String pid) {
        if (this.configAdminReference == null) {
            return null;
        }
        return new ConfigurationEvent(this.configAdminReference, type, factoryPid, pid);
    }
}

