/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.presentation.stack;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.listener.ISubModuleNodeListener;
import org.eclipse.riena.navigation.listener.NavigationTreeObserver;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.ui.controllers.SubApplicationController;
import org.eclipse.riena.navigation.ui.swt.binding.InjectSwtViewBindingDelegate;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ModuleGroupRenderer;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.SubModuleViewRenderer;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewProviderAccessor;
import org.eclipse.riena.ui.ridgets.swt.uibinding.AbstractViewBindingDelegate;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.StackDropResult;
import org.eclipse.ui.presentations.StackPresentation;

public class TitlelessStackPresentation
extends StackPresentation {
    public static final String PROPERTY_NAVIGATION = "navigation";
    public static final String PROPERTY_STATUSLINE = "statusLine";
    public static final int PADDING_LEFT = 2;
    public static final int PADDING_RIGHT = 2;
    public static final int PADDING_TOP = 10;
    public static final int PADDING_BOTTOM = 2;
    public static final int NAVIGATION_SUB_MODULE_GAP = 4;
    private Set<IPresentablePart> knownParts = new HashSet<IPresentablePart>();
    private IPresentablePart current;
    private IPresentablePart navigation;
    private Composite parent;
    private SubModuleViewRenderer renderer;
    private boolean hasListener;

    public TitlelessStackPresentation(Composite parent, IStackPresentationSite stackSite) {
        super(stackSite);
        this.parent = new Composite(parent, 0x20000000);
        this.createSubModuleViewArea();
    }

    public void addPart(IPresentablePart newPart, Object cookie) {
        this.initializeSubModuleChangeListener();
        if (this.isNavigation(newPart)) {
            this.navigation = newPart;
        }
        this.knownParts.add(newPart);
    }

    protected AbstractViewBindingDelegate createBinding() {
        return new InjectSwtViewBindingDelegate();
    }

    public void selectPart(IPresentablePart toSelect) {
        if (this.current == toSelect) {
            return;
        }
        if (this.isNavigation(toSelect)) {
            Rectangle navi = TitlelessStackPresentation.calcNavigationBounds(this.parent);
            toSelect.setBounds(navi);
            this.redrawSubModuleTitle();
        } else if (toSelect != null) {
            Rectangle inner = this.calcSubModuleInnerBounds();
            toSelect.setBounds(inner);
            if (this.current != null) {
                this.current.setVisible(false);
            }
            this.redrawSubModuleTitle();
            this.current = toSelect;
        }
        if (toSelect != null) {
            toSelect.setVisible(true);
        }
    }

    public void setBounds(Rectangle bounds) {
        this.parent.setBounds(bounds);
        if (this.navigation != null) {
            Rectangle navi = TitlelessStackPresentation.calcNavigationBounds(this.parent);
            this.navigation.setBounds(navi);
        }
        if (this.current != null) {
            Rectangle inner = this.calcSubModuleInnerBounds();
            this.current.setBounds(inner);
        }
        this.parent.setVisible(true);
    }

    public void removePart(IPresentablePart oldPart) {
        if (this.isNavigation(oldPart)) {
            this.navigation = null;
        } else if (oldPart == this.current) {
            this.current = null;
        }
        this.knownParts.remove(oldPart);
    }

    public void dispose() {
        if (this.getRenderer() != null) {
            this.getRenderer().dispose();
        }
    }

    public StackDropResult dragOver(Control currentControl, Point location) {
        return null;
    }

    public Control getControl() {
        return this.parent;
    }

    public Control[] getTabList(IPresentablePart part) {
        return new Control[0];
    }

    public void setActive(int newState) {
    }

    public void setState(int state) {
    }

    public void setVisible(boolean isVisible) {
        this.parent.setVisible(isVisible);
    }

    public void showPaneMenu() {
    }

    public void showSystemMenu() {
    }

    private Rectangle calcSubModuleInnerBounds() {
        return this.getSubModuleViewRenderer().computeInnerBounds(this.calcSubModuleOuterBounds());
    }

    private Rectangle calcSubModuleOuterBounds() {
        Rectangle naviBounds = TitlelessStackPresentation.calcNavigationBounds(this.parent);
        int x = naviBounds.x + naviBounds.width + 4;
        int y = naviBounds.y;
        int width = this.parent.getBounds().width - x - 2;
        int height = naviBounds.height;
        Rectangle outerBounds = new Rectangle(x, y, width, height);
        return outerBounds;
    }

    public static Rectangle calcNavigationBounds(Composite parent) {
        GC gc = new GC((Drawable)parent);
        try {
            Point size = TitlelessStackPresentation.getModuleGroupRenderer().computeSize(gc, -1, -1);
            int x = 2;
            int y = 10;
            int width = size.x;
            int height = parent.getBounds().height - 2 - 10 - 22;
            Rectangle rectangle = new Rectangle(x, y, width, height);
            return rectangle;
        }
        finally {
            gc.dispose();
        }
    }

    private void createSubModuleViewArea() {
        this.parent.setBackground(LnfManager.getLnf().getColor("SubModule.background"));
        this.parent.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                SubModuleViewRenderer viewRenderer;
                if (TitlelessStackPresentation.this.current != null && (viewRenderer = TitlelessStackPresentation.this.getRenderer()) != null) {
                    Rectangle bounds = TitlelessStackPresentation.this.calcSubModuleOuterBounds();
                    viewRenderer.setBounds(bounds);
                    viewRenderer.paint(e.gc, null);
                }
            }
        });
    }

    private IWorkbenchPage getActivePage() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    private SubModuleViewRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = (SubModuleViewRenderer)LnfManager.getLnf().getRenderer("SubModuleView.renderer");
        }
        return this.renderer;
    }

    private static ModuleGroupRenderer getModuleGroupRenderer() {
        return (ModuleGroupRenderer)LnfManager.getLnf().getRenderer("ModuleGroup.renderer");
    }

    private SubModuleViewRenderer getSubModuleViewRenderer() {
        return (SubModuleViewRenderer)LnfManager.getLnf().getRenderer("SubModuleView.renderer");
    }

    private synchronized void initializeSubModuleChangeListener() {
        if (this.hasListener) {
            return;
        }
        SubApplicationController controller = this.getSubApplicationController();
        if (controller != null) {
            NavigationTreeObserver navigationTreeObserver = new NavigationTreeObserver();
            navigationTreeObserver.addListener((ISubModuleNodeListener)new SubModuleNodeListener(){

                public void activated(ISubModuleNode source) {
                    TitlelessStackPresentation.this.redrawSubModuleTitle();
                }
            });
            navigationTreeObserver.addListenerTo((ISubApplicationNode)controller.getNavigationNode());
            this.hasListener = true;
        }
    }

    private SubApplicationController getSubApplicationController() {
        SubApplicationController result = null;
        IWorkbenchPage page = this.getActivePage();
        if (page != null) {
            String id = page.getPerspective().getId();
            ISubApplicationNode subApplication = SwtViewProviderAccessor.getViewProvider().getNavigationNode(id, ISubApplicationNode.class);
            result = (SubApplicationController)subApplication.getNavigationNodeController();
        }
        return result;
    }

    private boolean isNavigation(IPresentablePart part) {
        return part.getPartProperty(PROPERTY_NAVIGATION) != null;
    }

    private void redrawSubModuleTitle() {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.redraw();
        }
    }
}

